
; Listing8p1a.s		Verhalten der Condition Codes bei der Anweisung MOVE

; Hier ist das Programm fr diese Lektion: 2 Anweisungen.
; Glauben sie, ich will sie auf den Arm nehmen? Nach allem, was Sie gesehen
; haben? Glauben Sie, dass Sie bis jetzt schon alles ber dieses einfache
; Programm wissen?
; Nun, sie liegen falsch. Folgen Sie den Anweisungen im Kommentar.

	SECTION	CONDCODES,CODE

Start:
	move.w	#$0000,d0
Stop:
	rts

	end

;	 oO
;	\__/
;	 U

In diesem und in den folgenden Listings werden wir die Bedingungscodes
(sogenannte CCs, Condition Codes) des Statusregisters sehen. Die CCs sind
ausfhrlich in der Lektion 68000-2.TXT beschrieben.
Wenn Sie sich nicht gut erinnern, was sie sind und wie sie funktionieren, 
empfehle ich Ihnen, sie erneut zu lesen.
Lassen Sie uns kurz daran erinnern, dass die CCs Bits sind, die im
Statusregister platziert sind. Diese werden von den Assembler-Anweisungen
gendert, um Informationen zum Ergebnis der durchgefhrten Operation zu geben.
Es gibt Anweisungen, die alle CCs ndern, andere, die nur einige ndern und
andere, die keine von ihnen ndern.
Darber hinaus tut jeder Befehl, der die CCs modifiziert, dies auf seine
eigene Weise. In Lektion 68000-2.TXT wird fr jede Assembler-Anweisung kurz die
Auswirkung auf die CCs beschrieben. In diesen Listings werden wir kleine
praktische Beispiele prsentieren, wie die am hufigsten verwendeten
Anweisungen die CCs modifizieren.
Dies sind langweiligere Listings als die, die wir bisher gesehen haben, aber es
ist notwendig, dass Sie sie gut studieren, wenn Sie einmal ein ECHTER Coder
werden wollen. In diesem Listing werden wir die MOVE-Anweisung untersuchen.

Es ist, wie Sie wissen sollten, eine Anweisung, die den Inhalt eines 
Registers oder einer Speicherstelle kopiert und die CCs entsprechend ndert.
Um zu beobachten, wie diese Anweisung funktioniert, verwenden wir ASMONE.
Fhren Sie das Programm STEP-BY-STEP aus, dh jeweils eine Anweisung.

Assemblieren Sie dazu das Programm wie gewohnt, aber noch NICHT ausfhren.
Geben Sie stattdessen im ASMONE den Befehl X ein, durch den der Inhalt 
aller vorhandenen Register des 68000 und die nchste Anweisung, die
ausgefhrt wird, ausgegeben wird.
Diese Informationen werden von ASMONE in 4 Zeilen unten zusammengefasst:

D0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07CAAE9C 
SSP=07CABFD3 USP=07CAAE9C SR=0000 -- -- PL=0 ----- PC=07CAE030
PC=07CAE030 303C0000             MOVE.W  #$0000,D0
>

Wir erklren kurz die Bedeutung dieser 4 Zeilen. Die erste Zeile reprsentiert
den Inhalt der 8 Datenregister des 68000. Sie knnen in der Tat sehen, wie es
8 Zahlen gibt, die durch ein Leerzeichen voneinander getrennt sind. Diese
stellen den Inhalt der Register dar, beginnend mit d0 (das auf der linken
Seite) und der Reihe nach weiter bis zu d7. Beachten Sie, wie alle Register
gelscht werden, bevor Sie das Programm ausfhren.

Die zweite Zeile reprsentiert exakt den Inhalt der Adressregister in der
gleichen Weise, wie die erste den Inhalt der Datenregister darstellt. Beachten
Sie, dass alle Register gelscht sind, mit Ausnahme von A7, das die Adresse
des Stackpointers (Stack) enthlt.

Die dritte Reihe zeigt andere Prozessorregister. Im Moment beschftigen wir uns
nur mit dem PC (Programmcounterr) und dem SR (Statusregister).

Der PC enthlt die Adresse des nchsten auszufhrenden Befehls. Wie sie wissen
befinden sich die Anweisungen, aus denen ein Assembler-Programm besteht, im
Speicher!

Die Speicheradresse der nchsten Anweisung, von der es bezogen wird, ist im PC 
enthalten. In diesem Fall lautet die Adresse 07CAE030, was Teil des 
32-Bit-FAST-Speichers ist, der auf A1200 / A4000 und dergleichen vorhanden ist. 

Es ist natrlich so, dass dieser Wert auf verschiedenen Computern an
verschiedenen Speicherorten sein wird, und auch auf dem gleichen Computer
kann er von Zeit zu Zeit anders sein, da die Programme verschoben werden
knnen.

Vom SR, dem Statusregister, haben wir bereits in 68000-2.TXT gesprochen. Wir 
werden uns vorerst nur um das Low-Byte mit den CCs kmmern. Beachten Sie, dass
der Inhalt von SR hexadezimal dargestellt wird.

Den Inhalt der einzelnen CCs zu lesen kann unpraktisch sein. Aus diesem Grund
werden die CCs getrennt dargestellt. 
Sie werden in der Tat feststellen, dass es unmittelbar vor dem Inhalt des PC
5 Striche gibt. Jeder Strich reprsentiert einen anderen CC und zeigt an, dass
es auf Null gesetzt ist. Wenn einer der CCs den Wert 1 anstelle des
Bindestrichs hat, wird der Buchstabe, der den Bindestrich benennt, gedruckt: 
Wenn zum Beispiel das Carry zu 1 wird, wird anstelle des entsprechenden Strichs 
der Buchstabe C gedruckt.

Schlielich knnen wir in der vierten Zeile die nchste Anweisung lesen, die
als Nchstes ausgefhrt wird. In diesem Fall ist es die erste Anweisung des
Programms.

HINWEIS: Wenn Sie die ASMONE-Ausgabe in eine Datei drucken mchten, knnen Sie
dies tun. Verwenden Sie den Befehl > oder whlen Sie den entsprechenden Eintrag
im Men Befehl aus.
Der ASMONE fragt Sie nach dem Namen der Datei, in der Sie die Ausgabe drucken
mchten und das Spiel ist geschafft. Genau so wurde die Ausgabe des X-Befehls
gedruckt.

An diesem Punkt knnen wir die erste Anweisung des Programms ausfhren, dh:

          move.w  #$0000,d0

Wir geben dem ASMONE den Befehl K. Die Anweisung wird ausgefhrt und es wird
automatisch der Inhalt der Register gedruckt:

D0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07CAAE9C 
SSP=07CABFCF USP=07CAAE9C SR=8004 T1 -- PL=0 --Z-- PC=07CAE034
PC=07CAE034 4E75		 RTS
>

Unsere Anweisung hat im Register d0 den Wert $0000 gesetzt. Auerdem hat es
auch die CCs gendert. Beachten Sie, dass der Inhalt von SR jetzt $8004 ist.
Das Low-Byte hat den Wert $04, was in Binrform %00000100 geschrieben wird. Das
bedeutet das Bit 2, das CC "Zero" entspricht, den Wert 1 angenommen hat. Wie
ich es am Anfang gesagt hatte, wurde einer der fnf Striche, die frher
erschienen, durch das Zeichen "Z", das anzeigt, dass das "Zero"-Flag den Wert 1
bernommen hat, ersetzt.

Der MOVE-Befehl ndert die CCs tatschlich wie folgt:
Die V- und C-Flags werden gelscht
Das X-Flag wird nicht gendert
Das Z-Flag nimmt den Wert 1 an, wenn die zu kopierenden Daten 0 sind
Das N-Flag nimmt den Wert 1 an, wenn die kopierten Daten negativ sind.

In unserem Fall nimmt das Z-Flag den Wert 1 an, da die Daten, die wir nach d0 
kopieren, $0000 sind und das Flag N nimmt den Wert 0 an (da $0000 KEINE
negative Zahl ist).

Schauen wir uns nun einige andere Beispiele fr die Verwendung der MOVE-
Anweisung an. ndere im Source den MOVE und schreibe:

	move.w	#$1000,d0

Wiederholen Sie nun den Vorgang, um das Programm STEP BY STEP auszufhren.
Nach dem Ausfhren des MOVE haben wir folgende Situation:

D0: 00001000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07C9EDFC 
SSP=07C9FF2F USP=07C9EDFC SR=8000 T1 -- PL=0 ----- PC=07CA2E40
PC=07Ca2E40 4E75		 RTS     

Wir knnen feststellen, dass d0 jetzt den Wert $00001000 enthlt, oder vielmehr 
das was wir mit dem MOVE zu ihm kopiert haben. Auch diesmal sind die CCs alle
gelscht. Das hngt davon ab, dass der Wert $1000 ist, den wir kopiert haben
anders als null und auch eine positive Zahl ist.

Nehmen wir eine weitere nderung vor.
Anstelle des Wertes von $1000 setzen wir $8020 ein und erhalten:

	move.w	#$8020,d0			; dh "move.w #-32736,d0

Diesmal nach der Ausfhrung des MOVE erhalten wir:

D0: 00008020 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07C9EDFC 
SSP=07C9FF2F USP=07C9EDFC SR=8008 T1 -- PL=0 -N--- PC=07CA2E40
PC=07CA2E40 4E75		 RTS

Wie Sie sehen, hat d0 den gewnschten Wert und das Flag N hat den Wert 1
angenommen. Der Grund ist, dass die Zahl $8020 eine negative Zahl ist,
weil sein hchstwertiges Bit 1 ist.

Lassen Sie uns jetzt das MOVE wie folgt ndern:

	move.l	#$8020,d0

Wir haben einfach die Gre der verschobenen Daten gendert. Diese Tatsache
bedeutet, dass wir jetzt den Wert $8020 als 32-Bit-Zahl betrachten mssen
oder als $00008020. Jetzt ist das hchstwertige Bit das Bit 31, nicht das
Bit 15 wie zuvor! In diesem Fall handelt es sich also um eine
POSITIVE Zahl. In der Tat erhalten Sie durch Ausfhren des MOVE:

D0: 00008020 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07C9EDC4 
SSP=07C9FEF7 USP=07C9EDC4 SR=8000 T1 -- PL=0 ----- PC=07CA33CA
PC=07CA33CA 4E75		 RTS
>

Hier knnen Sie sehen, dass das Flag "N" gelscht ist. 
