
; Listing8o.s	8 hohe Balken mit jeweils 13 * 2 Zeilen, die abprallen.
; Klicken Sie mit der rechten Maustaste, um die Hintergrundbereinigung zu
; deaktivieren.

	SECTION	BAR,CODE

*****************************************************************************
	include	"/Sources/Startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA
;			 -----a-bcdefghij

;	a: Blitter Nasty
;	b: Bitplane DMA	   (Wenn es nicht gesetzt ist, verschwinden auch die Sprites)
;	c: Copper DMA
;	d: Blitter DMA
;	e: Sprite DMA
;	f: Disk DMA
;	g-j: Audio 3-0 DMA

Start:
	bsr.s	InitCopper			; die Copperliste mit einer Routine erstellen

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper

	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10800,d2			; Warte auf Zeile = $108
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	bne.s	WarteY1

	btst	#2,$16(a5)			; rechte Maustaste gedrckt?
	beq.s	SkipClear			; Wenn ja nicht "reinigen"

	bsr.s	ClrCopper			; Copperhintergrund "reinigen"

SkipClear:
	bsr.s	DoBars				; die Bar erstellen

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	rts

*************************************************************************
*	COPPERBALKEN - ANWEISUNGEN:											*
*																		*
*	bsr.s InitCopper ; vor dem Zeigen auf die Copperlist durchfhren	*
*					 ; erstellen der Copperlist (bestehend				*
					 ; aus WAIT und COLOR0)								*
*																		*
*	bsr.s ClrCopper	 ; ausfhren um alte Balken zu lschen				*
*					 ; "Schwrzen" aller COLOR0 in der copperrlist		*
*					 ; HINWEIS: Sie knnen die Hintergrundfarbe ndern  *
*					 ; durch nderung einwirken Hintergrund = $xxx		*
*																		*
*	bsr.s DoBars	 ; Anzeigen der Balken durch Aufrufen von PutBar	*
*																		*
*************************************************************************

COPLINES	=	100 			; Anzahl der zu erledigenden Copperlistenzeilen
								; fr die Wirkung der Balken.
BACKGROUND	=	$004			; Color des "Hintergrunds"


;	    /\
;	  .~            ~.
;	  |      \/   : |
;	  | |_____||___| |
;	.--./ ___ \/ __\.-.
;	|~\/ ( o~\></o~)\~|
;	`c(   _/ \  )'
;	  /\    ( ( )) /\
;	 /  .'___~\_/~___ \
;	 \   {IIIII[]II: /
;	  \   \::.   //  /
;	   \  \::::.//  /
;	    \  \\IIII]_/
;	     \     )
;	      \  /
;	       ~~~~

; InitCopper Erstellen der Copperliste mit vielen WAIT und COLOR0 unten

InitCopper:
	lea	BarCopper,a0			; Adresse, an der die Copperlistdas erstellt werden soll 
	move.l	#$3001fffe,d1		; erstes wait: Zeile $30 - WAIT in d1
	move.l	#$01800000,d2		; COLOR0 in d2
	move.w  #COPLINES-1,d0		; Anzahl der copperzeilen
InitLoop:
	move.l	d1,(a0)+			; das WAIT setzen
	move.l	d2,(a0)+			; das COLOR0 setzen
	add.l	#$02000000,d1		; nchstes wait, 2 Zeilen tiefer warten
	dbra	d0,InitLoop
	rts

; ClrCopper es "reinigt" den Coppereffekt indem es alle Elemente SCHWARZ ($000) macht
; die Werte von COLOR0 in der Copperliste (bzw. der Hintergrundfarbe)

ClrCopper:
	lea	BarCopper,a0			; Adresse WAIT/COLOR0 in Copperlist
	move.w	#COPLINES-1,d0		; Anzahl der Zeilen
	move.w	#BACKGROUND,d1		; RGB-Hintergrundfarbe
ClrLoop:
	move.w	d1,6(a0)			; ndern Sie dies Color 0
	addq.w	#8,a0				; nchste Color0 in Copperlist
	dbra 	d0,ClrLoop
	rts

; DoBars fhrt das "Scrollen" der farbigen Balken durch, einen nach dem anderen,
; Aufruf des Unterprogramms PutBar fr jeden Balken

DoBars:
	lea	Bar1(pc),a0
	move.l	BarPos1(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos1
	lea	Bar2(pc),a0
	move.l	BarPos2(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos2
	lea Bar3(pc),a0
	move.l	BarPos3(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos3
	lea Bar4(pc),a0
	move.l	BarPos4(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos4
	lea Bar5(pc),a0
	move.l	BarPos5(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos5
	lea Bar6(pc),a0
	move.l	BarPos6(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos6
	lea Bar7(pc),a0
	move.l	BarPos7(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos7
	lea Bar8(pc),a0
	move.l	BarPos8(pc),d0
	bsr.s	PutBar
	move.l 	d0,BarPos8
	rts

;	Unterroutine, Eingang:
;	a0 = Adresse BARx, d.h. Balkenfarben
;	d0 = Position BARx-

PutBar:	
	lsl.l	#1,d0				; die BarPos um 1 Bit nach links verschieben
	lea	PosList(pc),a1			; Adresstabelle mit Positionen in a1
	add.l	d0,a1				; summiere BarPos zu a1 und finde den richtigen
								; Positionswert in der Tabelle
	cmp.b	#$ff,(a1)			; sind wir an der letzten Position der Tabelle ??
	bne.s	PutBar1				; wenn nicht, nicht wieder von vorne anfangen
	moveq	#0,d0
	lea	PosList,a1				; wenn ja, fange von vorne an
PutBar1:
	moveq	#0,d2
	move.b	(a1),d2				; Wert aus der Tabelle PosList
	lsl.l	#3,d2				; Bits um 3 Stellen nach links verschieben (Multipl.*8)
	lea	BarCopper,a2			; Adresse Bar in Copperlist
	add.l	d2,a2				; Summenwert aus der Tabelle PosList und
								; multipliziert mit 8, dh in a2 finden wir die
								; Adresse des richtigen waits wo sie sein sollte
								; meine Bar
	moveq	#13-1,d4			; Jeder Balken ist 14 Zeilen hoch
PutLoop:
	move.w	(a0)+,6(a2)			; die Farbe des Balkens von BARx nach
								; dc.w $180,xxx in die Copperlist kopieren
	addq.w	#8,a2				; zum nchsten Wert von COLOR00 gehen
	dbra	d4,PutLoop			; und 14-mal wiederholen, um die gesamte Bar zu erstellen

	lsr.l	#1,d0				; die BarPos um 1 Bit nach rechts verschieben
	addq.l	#1,d0				; und addiere 1 fr den nchsten Zyklus.
	rts


; Dies sind die Positionen der Balken relativ zueinander. Wie sie sehen knnen
; werden sie nacheinander angeordnet und folgen in dieser Reihenfolge aufeinander.

BarPos1:	dc.l 0
BarPos2:	dc.l 4
BarPos3:	dc.l 8
BarPos4:	dc.l 12
BarPos5:	dc.l 16
BarPos6:	dc.l 20
BarPos7:	dc.l 24
BarPos8:	dc.l 28


; Dies sind die 8 Balken, dh die 13 RGB-Farben, aus denen sie jedes der folgenden
; Elemente zusammensetzt. zum Beispiel: Bar1 ist blau, Bar2 ist GRAU usw.

; color:  RGB, RGB, RGB, RGB, RGB, RGB, RGB, RGB, RGB, RGB, RGB, RGB, RGB
Bar1:
	dc.w $002,$004,$006,$008,$00a,$00c,$00f,$00c,$00a,$008,$006,$004,$002
Bar2:
	dc.w $222,$444,$666,$888,$aaa,$ccc,$fff,$ccc,$aaa,$888,$666,$444,$222
Bar3:
	dc.w $200,$400,$600,$800,$a00,$c00,$f00,$c00,$a00,$800,$600,$400,$200
Bar4:
	dc.w $020,$040,$060,$080,$0a0,$0c0,$0f0,$0c0,$0a0,$080,$060,$040,$020
Bar5:
	dc.w $012,$024,$036,$048,$05a,$06c,$07f,$06c,$05a,$048,$036,$024,$012
Bar6:
	dc.w $202,$404,$606,$808,$a0a,$c0c,$f0f,$c0c,$a0a,$808,$606,$404,$202
Bar7:
	dc.w $210,$420,$630,$840,$a50,$c60,$f70,$c80,$a70,$860,$650,$440,$230
Bar8:
	dc.w $220,$440,$660,$880,$aa0,$cc0,$ff0,$cc0,$aa0,$880,$660,$440,$220



; Dies ist die Tabelle (oder Liste) der vertikalen Positionen, die mglich 
; sind. Die farbigen Balken werden mit dem Wert $ff abgeschlossen.
; Diese Tabelle wurde von "IS" (Insert Sinus) mit diesen Parametern erstellt:
; BEG>0
; END>180
; AMOUNT>150
; AMPLITUDE>85
; YOFFSET>0
; SIZE (B/W/L)>B
; MULTIPLIER>1

PosList:
	dc.b	$01,$03,$04,$06,$08,$0a,$0c,$0d,$0f,$11,$13,$14,$16,$18,$19,$1b
	dc.b	$1d,$1e,$20,$22,$23,$25,$27,$28,$2a,$2b,$2d,$2e,$30,$31,$33,$34
	dc.b	$35,$37,$38,$3a,$3b,$3c,$3d,$3f,$40,$41,$42,$43,$44,$45,$46,$47
	dc.b	$48,$49,$4a,$4b,$4c,$4d,$4d,$4e,$4f,$4f,$50,$51,$51,$52,$52,$53
	dc.b	$53,$53,$54,$54,$54,$54,$55,$55,$55,$55,$55,$55,$55,$55,$55,$55
	dc.b	$54,$54,$54,$54,$53,$53,$53,$52,$52,$51,$51,$50,$4f,$4f,$4e,$4d
	dc.b	$4d,$4c,$4b,$4a,$49,$48,$47,$46,$45,$44,$43,$42,$41,$40,$3f,$3d
	dc.b	$3c,$3b,$3a,$38,$37,$35,$34,$33,$31,$30,$2e,$2d,$2b,$2a,$28,$27
	dc.b	$25,$23,$22,$20,$1e,$1d,$1b,$19,$18,$16,$14,$13,$11,$0f,$0d,$0c
	dc.b	$0a,$08,$06,$04,$03,$01

	dc.b	$ff					; Ende Tabelle

	even

*************************************************************************
;	Copperlist
*************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD
	dc.w	$100,$200			; 0 Bitplanes

BarCopper:						; Hier wird die Copperliste erstellt fr
	dcb.w	COPLINES*4,0		; die Wirkung der Balken - in diesem Fall
								; werden 400 Wrter bentigt. (COPLINES = 100)

	dc.w	$ffdf,$fffe
	dc.w	$0107,$fffe
	dc.w	$180,$222			; COLOR00 grau

	dc.w	$ffff,$fffe			; Ende Copperlist

	end

Dieses Listing zeigt, wie Sie lange, aber regelmige Copperlisten mit 
Routinen "erstellen" knnen. Spter werden wir sehen, das hinter den meisten
spektakulren Effekten sich oft kilometerlange Copperlisten verstecken.

nderungsvorschlag: Um das Ganze etwas "flacher" zu machen, warten sie in
jeder Zeile und nicht alle zwei Zeilen. ndern Sie einfach InitCopper:

	add.l	#$01000000,d1		; nchstes wait, warte 1 Zeile tiefer

Jetzt sind die Balken 13 Zeilen hoch und nicht 13 * 2 Zeilen!
Sie knnen sie auch alle 3 Zeilen warten lassen, aber dadurch gehen Sie zu weit
runter, aber versuchen Sie es trotzdem:

	add.l	#$03000000,d1		; nchstes wait, warte 3 Zeilen tiefer
	   