
; Listing8m5.s - Routine zum Drucken eines Punktes, verwendet in einer Schleife fr die
; Berechnung y = a * x * x oder Parabeln

	SECTION	PUNKT,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/Startup1.s"	; damit mache ich Einsparungen und 
									; schreib es nicht jedes mal neu!	
*****************************************************************************


; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche
; geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper und Bitplane DMA aktivieren
;			 -----a-bcdefghij


Start:
	move.l	#Bitplane,d0		; Adresse der Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.w	#DMASET,$96(a5)		; DMACON - Copper und Bitplane DMA aktivieren

	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	lea	Bitplane,a0				; Bitplane-Adresse, an der gedruckt werden soll

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; Warte auf Zeile = $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile = $130 (304)
	bne.s	WarteY1

	bsr.s	BerechneParabel		; y=a*x*x

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; Warte auf Zeile = $130 (304)
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile = $130 (304)
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
Ende:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Ende
	rts							; exit

;	  _       , _
;	 / \ , , /,/'
;	    \\\////
;	    /'';``\
;	   /       \
;	 _/ __  --- \_
;	(/ ___ ___  \)
;	/  --- (  )  \
;	\    /     /
;	 \  ( .      /
;	  \_ o  ____/
;	   l____| T
;	      |   |xCz
;	      `---'

;	Y=a*x*x, Koeffizienten*d0*d0=d1

BerechneParabel:
	addq.w	#1,MeinX			; das X erhhen
	move.w	MeinX(pc),d1
	mulu.w	d1,d1				; x*x
	mulu.w	Koeff(pc),d1		; y=a*x*x
	lsr.w	#8,d1				; dividiere durch 256 um das Y "zu erweitern"

	cmp.w	#255,MeinY			; Sind wir unter dem Bildschirm?
	bhi.s	NeuStarten			; wenn ja, wir haben nur 1 Bildschirm !!! dann neu Starten
	cmp.w	#319-160,MeinX		; Sind wir ganz rechts auf dem Bildschirm?
	ble.s	NichtEnde
NeuStarten:
	addq.w	#1,Koeff			; Addiere 1 zum Koeffizienten der Parabel
	cmp.w	#6,Koeff			; sind wir schon bei Koeff = 6
	beq.s	Ende				; Wenn ja, gehen wir raus!
	tst.w	Koeff				; Sind wir bei null
	bne.s	OkKoeff				; Wenn nicht, ist das in Ordnung
	addq.w	#1,Koeff			; sonst springen wir sofort auf 1!
OkKoeff:
	move.w	#-160,MeinX			; und Starten erneut mit X = -160 fr die neue Parabel
	rts							; Diesmal gibt es nichts zu zeichnen.

NichtEnde:
	move.w	d1,MeinY

; wir zeichnen den Punkt:

	move.w	MeinX(pc),d0		; Koordinate X
	add.w	#160,d0				; um 160 nach rechts verschieben, da das Ergebnis der
								; Berechnung im Bereich von -160 bis +160 liegt, damit
								; wird es auf die Koordinaten von 0 bis 320 normalisiert
								; ... auf diese Weise bewege ich die Parabel nach rechts.
	move.w	MeinY(pc),d1		; Koordinate Y
	bsr.s	PlotPix				; den Punkt auf die Koordinate X=d0, Y=d1 drucken

	rts


MeinX:
	dc.w	-160				; Ich beginne von -160, um die Parabel zu "zentrieren".
MeinY:
	dc.w	0
Koeff:
	dc.w	-5

*****************************************************************************
;			Routine zum Plotten eines Punktes
*****************************************************************************

;	Eingehende Parameter von PlotPix:
;
;	a0 = Ziel-Bitplane-Adresse
;	d0.w = Koordinate X (0-319)
;	d1.w = Koordinate Y (0-255)

BreiteBildschirm	equ	40		; Bildschirmbreite in Bytes.


PlotPix:
	move.w	d0,d2				; Koordinate X in d2 kopieren 
	lsr.w	#3,d0				; den horizontalen Versatz finden, in dem wir
								; die X-Koordinate durch 8 teilen
	mulu.w	#BreiteBildschirm,d1
	add.w	d1,d0				; den vertikalen zum horizontalen Versatz hinzufgen

	and.w	#%111,d2			; nur die ersten 3 Bits von X auswhlen
								; (In Wirklichkeit wre es der Rest der Division
								; durch 8, vorher gemacht)
	not.w	d2					; negieren

	bset.b	d2,(a0,d0.w)		; Bit d2 des Bytes setzen, das d0 Bytes 
								; vom Anfang des Bildschirms entfernt ist
	rts

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,$24			; BPLCON2 - Alle Sprites ber der Bitplane
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD
			    ; 5432109876543210
	dc.w	$100,%0001001000000000	; 1 Bitplane LOWRES 320x256

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste Bitplane

	dc.w	$0180,$000			; COLOR00 - Hintergrund
	dc.w	$0182,$1af			; COLOR01 - Schrift

	dc.w	$ffff,$fffe			; Ende Copperlist


*****************************************************************************

	SECTION	MEINEPLANE,BSS_C

Bitplane:
	ds.b	40*256				; eine Bitplane lowres 320x256

	end

In diesem Listing ist die einzige nderung, dass wir auch negative Koeffizienten 
verwenden.
                                                                                                                                                   nze um 160 nach rechts und zentrieren die Parabel,
