
; Listing8h.s - Verwendung der UniBewegeSprite-Routine zum Erstellen eines Panels
; Steuerung mit Schaltflchen

	SECTION	MAINPROGRAM,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/Startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110100000	; Copper, Bitplane, Sprite DMA aktiviert
;			 -----a-bcdefghij

;	a: Blitter Nasty
;	b: Bitplane DMA
;	c: Copper DMA
;	d: Blitter DMA
;	e: Sprite DMA
;	f: Disk DMA
;	g-j: Audio 3-0 DMA

Start:
	bsr.w	PointerFig1			; Zeiger auf Fig.1
	bsr.w	PointerFigBase		; Zeiger auf Fig.base

	move.l	#Buffer,d0			; freier Platz, an dem es sein wird
	lea	Bplpointers2,a1			; gedruckter Text
	move.w	d0,6(a1)	
	swap	d0
	move.w	d0,2(a1)

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper, Sprite
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	move.b	$dff00a,MouseY		; JOY0DAT - Wir geben den Variablen MouseY -_x 
	move.b	$dff00b,MouseX		; JOY1DAT - den aktuellen Lesewert der Maus

;*****************************************************************************
; 				HAUPTSCHLEIFE
;*****************************************************************************

Clear:
	clr.b	Action				; die Variablen zurcksetzen
	clr.b	KeyActive
	clr.b	ExitVar

Programm:
	****1
	btst	#6,$bfe001			; linke Maustaste gedrckt? Wenn nicht
	bne.s	ContProg			; setze das Programm fort, ansonsten:
	bsr.w	CheckAction			; Kontrolle welche Taste wir gedrckt haben
	cmpi.b	#1,KeyActive		; Wenn wir eine der "Tasten" gedrckt haben
	beq.s	Command				; Variante "Switched Key" und = 1; gehen wir
								; um zu berprfen, auf welche Taste wir geklickt haben!
ContProg:
	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	bra.s	Programm			; Ende des Programms: wir kehren zum Anfang zurck!

;*****************************************************************************
;	Routine "Command" zur Interpretation der gedrckten Taste
;*****************************************************************************

; In der Variable "Action" (Aktion) finden wir einen eingegebenen Wert den wir
; zuvor aus der Routine "CheckAction" erhalten haben. Wir berprfen den Wert
; und wissen damit, auf welche Taste wir "geklickt" haben und gehen in sein
; entsprechendes kleines Programm um es auszufhren.

Command:
	cmpi.b	#$f,Action			; Wenn Aktion "f", ist, haben wir auf die Schaltflche geklickt
	beq.s	Green				; grn	
	cmpi.b	#$e,Action			; Wenn Aktion "e", ist, haben wir auf die Schaltflche geklickt
	beq.w	Red					; rot
	cmpi.b	#$d,Action			; Wenn Aktion "d", ist, haben wir auf die Schaltflche geklickt
	beq.w	Yellow				; gelb
	cmpi.b	#7,Action			; Wenn Aktion "7", ist, haben wir auf die Schaltflche geklickt
	beq.w	MusicOn				; Music On
	cmpi.b	#6,Action			; Wenn Aktion "6", ist, haben wir auf die Schaltflche geklickt
	beq.w	MusicOff			; Music Off
	cmpi.b	#5,Action			; Wenn Aktion "5", ist, haben wir auf die Schaltflche geklickt
	beq.w	Quit				; Quit
	cmpi.b	#4,Action			; Wenn Aktion "4", ist, haben wir auf die Schaltflche geklickt
	beq.w	PalNtsc				; PalNtsc
	cmpi.b	#3,Action			; Wenn Aktion "3", ist, haben wir auf die Schaltflche geklickt
	beq.w	More				; mehr
	cmpi.b	#$2,Action			; Wenn Aktion "2", ist, haben wir auf die Schaltflche geklickt
	beq.w	Less				; weniger
;	cmpi.b	#1,Action			; Wenn Aktion "1", ist, haben wir auf die Schaltflche geklickt
	bra.w	OpenClose			; OpenClose (In Wahrheit ist nur noch diese brig)
								; Mglichkeit, also springen wir direkt

;*****************************************************************************

Green:
	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	lea	Bar+6,a6				; Zur Rckgabe der Multiplikation
	move.b	#$1,ColorB			; speichern, welche Farbe wir anzeigen
	move.w	#$0030,(a6)			; wir ndern die FARBEN des Balkens (den Abstand)
	move.w	#$0060,8(a6)		; zwischen einem wait und dem anderen sind 8 Bytes
	move.w	#$0090,8*2(a6)
	move.w	#$00c0,8*3(a6)
	move.w	#$00f0,8*4(a6)
	move.w	#$00c0,8*5(a6)
	move.w	#$0090,8*6(a6)
	move.w	#$0060,8*7(a6)
	move.w	#$0030,8*8(a6)
	bra.w	Clear				; wir kehren zum Anfang zurck!

;*****************************************************************************

Red:
	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	lea	Bar+6,a6				; Zur Rckgabe der Multiplikation
	move.b	#$2,ColorB			; speichern, welche Farbe wir anzeigen
	move.w	#$0300,(a6)			; wir ndern die FARBEN des Balkens (den Abstand)
	move.w	#$0600,8(a6)		; zwischen einem wait und dem anderen sind 8 Bytes
	move.w	#$0900,8*2(a6)
	move.w	#$0c00,8*3(a6)
	move.w	#$0f00,8*4(a6)
	move.w	#$0c00,8*5(a6)
	move.w	#$0900,8*6(a6)
	move.w	#$0600,8*7(a6)
	move.w	#$0300,8*8(a6)
	bra.w	Clear				; wir kehren zum Anfang zurck!
		
;*****************************************************************************

Yellow:
	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	lea	Bar+6,a6				; Zur Rckgabe der Multiplikation
	clr.b	ColorB				; speichern, welche Farbe wir anzeigen
	move.w	#$0310,(a6)			; wir ndern die FARBEN des Balkens (den Abstand)
	move.w	#$0640,8(a6)		; zwischen einem wait und dem anderen sind 8 Bytes
	move.w	#$0970,8*2(a6)
	move.w	#$0ca0,8*3(a6)
	move.w	#$0fd0,8*4(a6)
	move.w	#$0ca0,8*5(a6)
	move.w	#$0970,8*6(a6)
	move.w	#$0640,8*7(a6)
	move.w	#$0310,8*8(a6)
	bra.w	Clear				; wir kehren zum Anfang zurck!

;*****************************************************************************

PaNtFlag:
	dc.w	0

PalNtsc:
	bchg.b	#1,PaNtflag
	btst.b	#1,PaNtflag
	beq.s	GoPal
	move.w	#0,$1dc(a5)			; BEAMCON0 (ECS+) Videoauflsung NTSC
	bra.w	Clear				; wir kehren zum Anfang zurck!
GoPal
	move.w	#$20,$1dc(a5)		; BEAMCON0 (ECS+) Videoauflsung PAL
	bra.w	Clear				; wir kehren zum Anfang zurck!


;*****************************************************************************

; Denken Sie daran, die 'MoveArrow'-Routine IMMER in den Punkten zu platzieren,
; zum Beispiel wie das folgende, das nicht zur Ausfhrung des Hauptprogramms 
; zurckkehrt, bis die linke Maustaste gedrckt wird. Wenn sie weggelassen wrde,
; wrde die Maus sich nicht bewegen, bis die Maustaste losgelassen wird!

More:
	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	lea	Bar,a6					; in a6, die Adresse von "Bar" einsetzen, um zu
								; vermeiden, das es jedes Mal neu geschrieben werden
								; muss, und darber hinaus ist die Ausfhrung schneller!
	cmpi.b	#$84,8*9(a6)		; sind wir an der Zeile an $84 angekommen?
	beq.s	EndMore				; Wenn ja, sind wir oben und hren auf.
	addq.b	#1,(a6)				; Wir verschieben die Position des Balkens um ein
	addq.b	#1,8(a6)			; Pixel zu einem Zeitpunkt
	addq.b	#1,8*2(a6)
	addq.b	#1,8*3(a6)
	addq.b	#1,8*4(a6)
	addq.b	#1,8*5(a6)
	addq.b	#1,8*6(a6)
	addq.b	#1,8*7(a6)
	addq.b	#1,8*8(a6)
	addq.b	#1,8*9(a6)

**2
	btst.b	#6,$bfe001			; bis die linke Maustaste losgelassen wird
	beq.s	More				; bewegt sich der Balken weiter, auch wenn 	
								; sich die Maus nicht mehr ber der "+"-Taste befindet:
								; Versuchen Sie, unter der ersten Zeile hinzuzufgen
								; "bsr.w MoveArrow" die Bezeichnung "More2" und	
								; ndern Sie auch die Zeile unter *** 2 in
								; "beq.s More2". Trotz der Tatsache, dass sich die
								; Maus bewegt, bewegt sich der Pfeil nicht!

	bra.w	Clear				; wir kehren zum Anfang zurck!

; sind wir bis zum Boden gegangen? Dann der blaue Balken

EndMore:
	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	lea	Bar+6,a6				; Bar in Copperlist
	move.w	#$0003,(a6)			; wir ndern die Farben des Balkens auf blau
	move.w	#$0006,8(a6)
	move.w	#$0009,8*2(a6)
	move.w	#$000c,8*3(a6)
	move.w	#$000f,8*4(a6)
	move.w	#$000c,8*5(a6)
	move.w	#$0009,8*6(a6)
	move.w	#$0006,8*7(a6)
	move.w	#$0003,8*8(a6)
	btst.b	#6,$bfe001			; solange die linke Maustaste nicht losgelassen wird
	beq.s	EndMore				; bewegt sich der Balken weiter, auch wenn
								; sich die Maus nicht mehr ber der "+" Taste befindet:
	cmp.b	#1,ColorB			; wir berprfen, welche Farbe es vorher hatte
								; der Balken durch die Variable ColorB:
								; Wenn der Wert "1" war, ist der Balken grn
	beq.w	Green				; wir gehen zum Label grn und geben dem 
								; Balken seine ursprngliche Farbe zurck
	cmp.b	#2,ColorB			; Auch hier, wenn die Variable den Wert
	beq.w	Red					; "2" hat, gehen wir zum Label rot
	bra.w	Yellow				; Wenn keine Bedingung aufgetreten ist
								; war die Bar unvermeidlich
								; gelb, denn die mglichen Farben
								; sind drei: rot, grn oder gelb!

;*****************************************************************************

Less:
	bsr.w	MoveArrow			; Es gilt das Gleiche wie oben, nur dass wir
	lea	Bar,a6					; addiere den Wert "1" zu "Bar",
	cmpi.b	#$36,8*9(a6)		; Haben wir den Boden erreicht?
	beq.s	EndLess				; anhalten und den Balken blau frben
	subq.b	#1,(a6)				; wir subtrahieren, so dass es sich in die
	subq.b	#1,8(a6)			; entgegengesetzte Richtung (nach oben) bewegt
	subq.b	#1,8*2(a6)
	subq.b	#1,8*3(a6)
	subq.b	#1,8*4(a6)
	subq.b	#1,8*5(a6)
	subq.b	#1,8*6(a6)
	subq.b	#1,8*7(a6)
	subq.b	#1,8*8(a6)
	subq.b	#1,8*9(a6)
	**3
	btst.b	#6,$bfe001
	beq.s	Less
	bra.w	Clear				; Wir kehren zum Anfang zurck !!

; sind wir oben angekommen? Dann blauer Balken!

EndLess:
	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	lea	Bar+6,a6
	move.w	#$0003,(a6)			; color blau
	move.w	#$0006,8(a6)
	move.w	#$0009,8*2(a6)
	move.w	#$000c,8*3(a6)
	move.w	#$000f,8*4(a6)
	move.w	#$000c,8*5(a6)
	move.w	#$0009,8*6(a6)
	move.w	#$0006,8*7(a6)
	move.w	#$0003,8*8(a6)
	btst.b	#6,$bfe001
	beq.s	EndLess
	cmpi.b	#$1,ColorB			; berprfen, welche Farbe der Balken hatte
	beq.w	Green
	cmpi.b	#$2,ColorB
	beq.w	Red
	bra.w	Yellow

;*****************************************************************************

MusicOn:
	move.b	#1,MusicFlag		; der MusicFlag-Variablen den Wert "1" geben,
								; Wann immer wir es testen, werden wir wissen
								; wenn die Musik aktiviert wurde.
	move.l	a5,-(sp)			; speichern a5 im stack
	bsr.w	mt_init				; zur Routine springen, die die Musik spielt
	move.l	(sp)+,a5			; a5 vom Stack wiederherstellen

	**4
;	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	bra.w	Clear				; wir kehren zum Anfang zurck!

;*****************************************************************************

MusicOff:
	clr.b	MusicFlag			; der MusicFlag-Variablen den Wert "0" geben,
								; Wann immer wir es testen, werden wir wissen
								; wenn die Musik ausgeschaltet wurde.
	move.l	a5,-(sp)			; speichern a5 im stack
	bsr.w	mt_end				; zur Routine springen, die die Musik stoppt
	move.l	(sp)+,a5			; a5 vom Stack wiederherstellen
	**5
;	bsr.w	MoveArrow			; Routine, die die Maus liest / bewegt
	bra.w	Clear				; wir kehren zum Anfang zurck!

;*****************************************************************************
;		
;*****************************************************************************

Quit:							; wir verlassen das Programm!!!
	move.l	a5,-(sp)			; speichern a5 im stack
	bsr.w	mt_end				; die Musik ausschalten !!!: Wenn wir auf die
								; "EXIT" Taste drcken, whrend die Musik
								; spielt, passiert ein durcheinander
	move.l	(sp)+,a5			; a5 vom Stack wiederherstellen
	rts	


*******************************************************************************
*				Verschiedene BSR											  *
*******************************************************************************

PointerFig1:
	move.l	#Picture,d0
	moveq	#4-1,d1				; 4 Bitplane!
	lea	Bplpointers,a1
PointBp1:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*84,d0			; die Bitplane ist 84 Zeilen hoch, nicht 256!!
	addq.w	#8,a1
	dbra	d1,PointBp1

; alle Sprites zeigen auf das Null-Sprite, um sicherzustellen
; das es keine Probleme gibt

	move.l	#SpriteNull,d0		; Adresse des Sprite in d0
	lea	SpritePointers,a1		; Spritezeiger in Copperlist
	moveq	#8-1,d1				; alle 8 Sprite
NulLoop:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addq.w	#8,a1
	dbra	d1,NulLoop

; Zeiger erste Sprite

	move.l	#MeinSprite0,d0
	lea	SpritePointers,a1
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	rts							; Rckkehr zum BSR

PointerFigBase:	
	move.l	#PictureBase,d0
	lea	BplpointersBase,a1
	moveq	#0,d1				; 1 Bitplane!
PointBp2:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*105,d0			; die Bitplane ist 105 Zeilen hoch, nicht 256!!
	addq.w	#8,a1
	dbra	d1,PointBp2
	rts							; Rckkehr

******************************************************************************
; Diese Routine prft, ob wir einen "Button" / "Gadget" gedrckt haben.
; Wenn eine "Taste" gedrckt wird, weisen Sie den Wert, der der "Taste" 
; entspricht, der Variable "Action" zu.
******************************************************************************


;                 _,'|             _.-''``-...___..--';)
;                /_ \'.      __..-' ,      ,--...--'''
;                    .`--'''       `     /'
;                `-';'               ;   ; ;
;          __...--''     ___...--_..'  .;.'
;         (,__....----'''       (,..--''
;||||||||///|||||||||||||||||||||||||||||||||||||||||||||||||||||

CheckAction:

; berprfen Sie zuerst die Positionen Y

	move.b	#$1,KeyActive		; Wir nehmen das im Voraus an
								; Wir drckten eine der Tasten
								; und geben der Variable "Switched Key"
								; der Wert "1"
	cmpi.w	#$00fc,SpriteY		; Der Pfeil befindet sich unter der Position
								; der Schaltflchen?
								; SpriteY ist > 00fc, wenn ja:
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$00f1,SpriteY		; Der Pfeil ist an der Linie ausgerichtet
								; die "Farbe ndern in grn"?
;
	bhi.w	EffectGreen			; Wenn ja: Gehen Sie zu Aktion Grn 
;
	cmpi.w	#$00fe,SpriteY		; Sind wir zwischen 00f1 und 00fe? Wenn ja:
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$00e4,SpriteY		; Der Pfeil ist an der Linie ausgerichtet
								; die "Farbe ndern in rot"?
;
	bhi.w	EffectRed			; Wenn ja, gehen Sie zu Aktion rot
;
	cmpi.w	#$00e1,SpriteY		; Sind wir zwischen 00e1 und 00d7? Wenn ja:
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$00d7,SpriteY		; Der Pfeil ist an der Linie ausgerichtet
								; der "Farbe ndern in gelb"?
;
	bhi.w	EffectYellow		; Wenn ja, gehen Sie zu Aktion gelb
;
	cmpi.w	#$00d0,SpriteY		; Sind wir zwischen 00d7 und 00d0? Wenn ja:
	bhi.s	RtnCheck			; Wir sind raus!

	cmpi.w	#$00b0,SpriteY		; Der Pfeil befindet sich zwischen "+", "-",
;								; "Pal-Ntsc","Exit"...
	bhi.s	ActionKey			; Wenn ja, gehen Sie zu Aktion _Tasti
;
RtnCheck:
	clr.b	KeyActive			; es wurden keine Tasten gedrckt,
	rts							; wir verhindern, dass das Programm 
								; Zeit durch sofortiges erneutes Lesen 
								; der Mausposition verschwendet, ber die
								; Variable "KeyActivate".

;*****************************************************************************
; Jetzt, da wir wissen, dass das Y das einer "Schaltflche" ist, lassen Sie  
; uns auch berprfen, ob das X das richtige ist!
;*****************************************************************************

ActionKey:
	cmpi.w	#$0111,SpriteX		; Der Pfeil befindet sich jenseits der Tasten
								; "Music Off"? wenn ja:
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$00ea,SpriteX		; Der Pfeil befindet sich zwischen den Tasten
								; "Music Off"? wenn ja:
	bhi.w	EffectMusicOff		; Gehe zu EffectMusicOff

	cmpi.w	#$00dc,SpriteX		; Der Pfeil befindet sich zwischen 00ea und 00dc? wenn ja:
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$00b3,SpriteX		; Der Pfeil befindet sich ber der Taste
								; "Music On"? wenn ja:
	bhi.w	EffectMusicOn		; Gehe zu EffectMusicOn
	cmpi.w	#$00ab,SpriteX		; Der Pfeil befindet sich jenseits der Tasten
								; "Pal/Ntsc" und "Quit"
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$0077,SpriteX		; Der Pfeil befindet sich zwischen den Tasten
								; "Pal/Ntsc,Quit"?
	bhi.s	WhichTwo2			; Mal sehen, welche der "Pal / Ntsc" oder "Quit"
	cmpi.w	#$006c,SpriteX		; Der Pfeil befindet sich zwischen 77 und 6c?
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$005d,SpriteX		; Der Pfeil befindet sich zwischen den Tasten
								; "+" und "-"?
	bhi.s	WhichTwo1			; Mal sehen, welche der "+" oder "-"
	cmpi.w	#$004f,SpriteX		; Der Pfeil befindet sich zwischen 77 und 6c?
	bhi.s	RtnCheck			; Wir sind raus!
	cmpi.w	#$003e,SpriteX		; Der Pfeil ist auf dem Schaltflche: -> <- !!
	bhi.s	EffectOpenClose		; Gehen wir zu EffectOpenClose
	bra.s	RtnCheck			; Wenn keine Aktion aufgetreten ist
								; dann lass uns zu RtnCheck gehen

WhichTwo2:
	cmpi.w	#$00c3,SpriteY		; Der Pfeil befindet sich ber der Taste
	bhi.w	EffectQuit			; "Quit"? Wenn ja, gehe zu EffectQuit
	cmpi.w	#$00bc,SpriteY		; Der Pfeil befindet sich zwischen 00c3 und 00bc?
	bhi.w	RtnCheck			; Wir sind in der Mitte der beiden Taste!
	cmpi.w	#$00b0,SpriteY		; Der Pfeil befindet sich zwischen 00bc und 00b0?
	bhi.w	EffectPal			; wir gehen zu  EffectPal
	
WhichTwo1:
	cmpi.w	#$00c3,SpriteY		; Der Pfeil befindet sich ber der Taste
	bhi.s	EffectMore			; "Piu"? Wenn ja, gehe zu EffectMore
	cmpi.w	#$00bc,SpriteY 		; Der Pfeil befindet sich zwischen 00bc und 00c3?
	bhi.w	RtnCheck			; Wir sind in der Mitte der beiden Taste!
	cmpi.w	#$00b0,SpriteY		; Der Pfeil befindet sich zwischen 00b0 und 00bc?
	bhi.w	EffectLess			; wir gehen zu EffectLess


;*****************************************************************************
; Geben wir nun der Aktionsvariablen den Wert der gedrckten Taste
;*****************************************************************************

EffectGreen:					; Wenn ja, wird dieser Zustand berprft
	move.b	#$d,Action			; es bedeutet, dass wir ber der grnen Bar
	rts							; sind! Dann informieren wir das
								; Programm, das diese "Schaltflche" gedrckt
								; wurde durch die Variable Action
								; (Aktion) mit dem Wert "d".
EffectRed:
	move.b	#$e,Action			; Wie oben, bis auf die Schaltflche
	rts							; -rot- Wir geben den Wert von  "e".

EffectYellow:
	move.b	#$f,Action			; Wie oben, bis auf die Schaltflche
	rts							; -gelb- Wir geben den Wert von   "f".

EffectOpenClose:
	move.b	#$1,Action			; Wie oben, bis auf die Schaltflche
	rts							; -UpDown- Wir geben den Wert von "1".

EffectMore:
	move.b	#$2,Action			; Wie oben, bis auf die Schaltflche
	rts							; -plus- Wir geben den Wert von "2".

EffectLess:
	move.b	#$3,Action			; Wie oben, bis auf die Schaltflche
	rts							; -minus- Wir geben den Wert von "3".

EffectPal:
	move.b	#$4,Action			; Wie oben, bis auf die Schaltflche
	rts							; -Pal- Wir geben den Wert von "4".

EffectQuit:
	move.b	#$5,Action			; Wie oben, bis auf die Schaltflche
	rts							; -Quit- Wir geben den Wert von "5".

EffectMusicOff
	move.b	#$6,Action			; Wie oben, bis auf die Schaltflche
	rts							; -Off_Music- Wir geben den Wert von "6".

EffectMusicOn
	move.b	#$7,Action			; Wie oben, bis auf die Schaltflche
	rts							; -On_Music- Wir geben den Wert von "7".
	
*************************************************************************
* Routine, die die Position der Maus lieste				*
* Betreten der Koordinaten in Mouse_x/Mouse_y - SpriteX/Sprite_Y	*
*************************************************************************

ReadMouse:
	move.b	$a(a5),d1			; $dff00a - JOY0DAT byte hoch
	move.b	d1,d0
	sub.b	MouseY(PC),d0
	beq.s	NoVert
	ext.w	d0
	add.w	d0,SpriteY
NoVert:
  	move.b	d1,MouseY
	move.b	$b(a5),d1			; $dff00a - JOY0DAT byte niedrig
	move.b	d1,d0
	sub.b	MouseX(PC),d0
	beq.s	NoHoriz
	ext.w	d0
	add.w	d0,SpriteX
NoHoriz:
	move.b	d1,MouseX
	cmpi.w	#$0021,SpriteX		; Minimale x-Position? (linker Rand)
	bpl.b	S1					; wenn noch nicht, ist es nicht notwendig zu blockieren.
	move.w	#$0021,SpriteX		; Ansonsten lassen Sie es uns aufhren
								; Lage $21  .. NICHT BER !!
S1:
	cmpi.w	#$0004,SpriteY		; Minimale y-Position? (Anfang des Bildschirms)
	bpl.b	S2					; wenn noch nicht, nicht blockieren
	move.w	#$0004,SpriteY		; ansonsten nagelt das Sprite an
								; oberer linker Rand
S2:
	cmpi.w	#$011d,SpriteX		; Maximale x-Position? (rechter Rand)
	ble.b	S3					; wenn noch nicht, ist es nicht notwendig zu blockieren
	move.w	#$011d,SpriteX		; Ansonsten lasst es uns fr $11d blockieren
S3:
	cmpi.w	#$00ff,SpriteY		; Position und Masse? (Bildschirm unten)
	ble.b	S4					; wenn noch nicht, nicht blockieren
	move.w	#$00ff,SpriteY		; Ansonsten blockiere a $ff
S4:
	rts

*********************************************************
*		Routine die das sprite0	bewegt					*
*********************************************************
;	a1 = Adresse des Sprites
;	d0 = vertikale Y-Position des Sprites auf dem Bildschirm (0-255)
;	d1 = horizontale X-Position des Sprites auf dem Bildschirm (0-320)
;	d2 = Hhe des Ssprites

UniMoveSprite:
	add.w	#$2c,d0
	move.b	d0,(a1)
	btst.l	#8,d0
	beq.s	NichtVstartSet
	bset.b	#2,3(a1)
	bra.s	ToVstop
NichtVstartSet:
	bclr.b	#2,3(a1)
ToVstop:
	add.w	d2,d0
	move.b	d0,2(a1)
	btst.l	#8,d0
	beq.s	NichtVstopSet
	bset.b	#1,3(a1)
	bra.b	VstopEnde
NichtVstopSet:
	bclr.b	#1,3(a1)
VstopEnde:
	add.w	#128,d1
	btst	#0,d1
	beq.s	NiederBitNull
	bset	#0,3(a1)
	bra.s	PlaceCoords
NiederBitNull:
	bclr	#0,3(a1)
PlaceCoords:
	lsr.w	#1,d1
	move.b	d1,1(a1)
	rts

*******************************************************************************
*		Timing und Update von Sprite-LOOPs									  *
*******************************************************************************

MoveArrow:

; Dies ist eine Timing-Routine, da der Vergleich mit den Elektronenstrahl 
; mit 50 Hz (es sei denn, Sie verwenden das NTSC-System! (60Hz!)) verwendet
; wird. Genau, der Elektronenstrahl hat in allen Computern die gleiche
; Geschwindigkeit, sowohl im alten A500 als auch im A4000.

	move.L	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.L	#$0fe00,d2			; Warte auf Zeile $fe (254)
WaitY1:
	move.L	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $fe (254)
	bne.s	WaitY1


	tst.b	MusicFlag			; Wenn MusicFlag "0" ist, ist Musik nicht
	beq.w	NoMusic2			; eingeschaltet worden, so berspringen wir die 
								; folgende Zeile
	move.l	a5,-(sp)			; speichern a5 im stack
	bsr.w	mt_music			; Die Musik wird abgespielt, wenn die Taste
								; gedrckt wurde "On_Music"
	move.l	(sp)+,a5			; a5 vom stack wiederherstellen

NoMusic2:
	bsr.w	ReadMouse			; Wechseln zur Routine, die die 
								; Mausposition liest
	move.w	SpriteY(pc),d0		; y-Koordinate vorbereiten
	move.w	SpriteX(pc),d1		; x-Koordinate vorbereiten
	lea	MeinSprite0,a1			; whle das zu bewegende Sprite aus
	moveq	#13,d2				; die Lnge des Sprites vorbereiten
	bsr.w	UniMoveSprite		; wir gehen zu der Routine, die das Sprite bewegt
	bsr.w	Print				; und schreiben den Text

	move.L	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.L	#$0fe00,d2			; Warte auf Zeile $0fe (254)
WaitY2:
	move.L	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $0fe (254)
	beq.s	WaitY2

	rts

;***************************************************************************
; "Spezialeffekt" Schlieen und ffnen mit DIWSTART/STOP
;***************************************************************************

	
OpenClose:
	bsr.w	ScreenClose			; zur Routine springen, die den Bildschirm schliet
	bsr.w	ScreenOpen			; zur Routine springen, die den Bildschirm ffnet
	bra.w	Clear				; wir kehren zum Anfang zurck!

;*****************************************************************************

ScreenClose:
	bsr.w	MoveArrow			; warte bis 1 FRAME-Zyklus abgelaufen ist !!
	addq.b	#1,DiwYStart		; wir senken den oberen Bildschirm um ein Pixel
	subq.b	#1,DiwYStop			; wir heben den unteren Bildschirm um ein Pixel
	cmpi.b	#$ad,DiwYStart		; Wenn wir die gewnschte Position erreicht haben,
	beq.s	Exit3				; dann gehen wir raus, sonst setzen wir das
	bra.s	ScreenClose			; pixel
Exit3:
	rts

ScreenOpen:
	bsr.w	MoveArrow			; anstatt es zu erhhen, verringern wir es,
								; das heit wir kehren um:
								; addq #1,DiwyStart
	subq.b	#5,DiwYStart		; subq #1,DiwyStop
	addq.b	#5,DiwYStop			; jeweils mit
	cmpi.b	#$2c,DiwYStop		; subq #5,DiwyStart
	beq.w	Exit4				; addq #5,DiwyStop
	bra.s	ScreenOpen
Exit4:
	rts


*******************************************************************************
*				Daten														   *
*******************************************************************************

Action:
	dc.l	0
KeyActive:
	dc.l	0
ExitVar:
	dc.l	0
ColorB:
	dc.b	2
	even

MusicFlag:
	dc.w	0
		
SpriteY:	dc.w	$a0			; hier wird das Y des Sprites gespeichert
								; Durch ndern dieses Wertes knnen wir Y ndern
								; die Ausgangsposition der Maus
SpriteX:	dc.w	0			; hier wird das X des Sprites gespeichert
								; Durch ndern dieses Wertes knnen wir X ndern
								; die Ausgangsposition der Maus
MouseY:		dc.b	0			; hier ist das Y der Maus gespeichert
MouseX:		dc.b	0			; hier ist das X der Maus gespeichert

*****************************************************************************
;			Druckroutine
*****************************************************************************

Print:
	move.L	PointerText(PC),a0	; Adresse des zu druckenden Textes in a0
	moveq	#0,d2				; leer d2
	move.b	(a0)+,d2			; Nchstes Zeichen in d2
	cmp.b	#$ff,d2				; Ende des Textsignals? ($FF)
	beq.s	EndeText			; wenn ja, beenden ohne zu drucken
	tst.b	d2					; Zeilenende-Signal? ($00)
	bne.s	NoEndLine			; Wenn nicht, nicht einpacken

	add.l	#40*7,PointerBitplane	; Gehen wir zum Kopf
	addq.l	#1,PointerText		; erste Zeichenzeile nach
								; (berspringe die NULL)
	move.b	(a0)+,d2			; erstes Zeichen der Zeile nach
								; (berspringe die NULL)

NoEndLine:
	sub.b	#$20,d2				; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG,
								; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
								; (Das $20 entspricht), IN $00, DAS
								; AUSRUFUNGSZEICHEN ($21) IN $01....
	lsl.w	#3,d2				; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
								; da die Charakter ja 8 Pixel hoch sind
	move.L	d2,a2
	add.l	#Font,a2			; FINDEN SIE DAS GEWNSCHTE ZEICHEN IM FONT...

	move.L	PointerBitplane(pc),A3 ; Adresse der Zielbitebene in a3

								; DRUCKE DEN BUCHSTABEN ZEILE FR ZEILE
	move.b	(a2)+,(a3)			; Drucke Zeile 1 des Zeichens
	move.b	(a2)+,40(a3)		; Drucke Zeile  2  " "
	move.b	(a2)+,40*2(a3)		; Drucke Zeile  3  " "
	move.b	(a2)+,40*3(a3)		; Drucke Zeile  4  " "
	move.b	(a2)+,40*4(a3)		; Drucke Zeile  5  " "
	move.b	(a2)+,40*5(a3)		; Drucke Zeile  6  " "
	move.b	(a2)+,40*6(a3)		; Drucke Zeile  7  " "
	move.b	(a2)+,40*7(a3)		; Drucke Zeile  8  " "

	addq.l	#1,PointerBitplane	; wir bewegen uns 8 Bits vorwrts (NCHSTES ZEICHEN)
	addq.l	#1,PointerText		; nchstes zu druckendes Zeichen

EndeText:
	rts


PointerText:
	dc.l	Text

PointerBitplane:
	dc.l	Buffer+40*3

;	$00 fr "Zeilenende" - $FF fr "Textende"

			 ; Anzahl Zeichen pro Zeile: 40
Text:	     ;		  1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890
	dc.b	'                                        ',0 ; 1
	dc.b	'    Usa il mouse per spostare la        ',0 ; 2
	dc.b	'                                        ',0 ; 3
	dc.b	'    barra, cambiarla di colore,         ',0 ; 4
	dc.b	'                                        ',0 ; 5
	dc.b	'    suonare la musica o "chiudere"      ',0 ; 6
	dc.b	'                                        ',0 ; 7
	dc.b	'    lo schermo con il DIWSTART/STOP     ',$FF ; 12

	even

; Die FONT 8x8-Zeichen, werden im CHIP von der CPU und nicht vom Blitter kopiert,
; so kann es auch im FAST RAM sein. In der Tat wre es besser!

Font:
	 incbin	"/Sources/nice.fnt"

*******************************************************************************
*			ROUTINE MUSICALE
*******************************************************************************

	include	"/Sources/music.s"

*******************************************************************************
;			MEGACOPPERLISTE GALAKTISCH (fast...)
*******************************************************************************


	SECTION	GRAPHIC,DATA_C


Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e					; DIWSTRT
DiwYStart:
	dc.b	$30
DiwXSTart:
	dc.b	$81
	dc.w	$90					; DIWSTOP
DiwYStop:
	dc.b	$2c
DiwXStop:
	dc.b	$c1
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,$24			; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

				; 5432109876543210
	dc.w	$100,%0100001000000000	; BPLCON0 - 4 planes lowres (16 color)

; Bitplane pointers

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste bitplane
	dc.w	$e4,0,$e6,0			; zweite bitplane
	dc.w	$e8,0,$ea,0			; dritte bitplane
	dc.w	$ec,0,$ee,0			; vierte bitplane

; Die ersten 16 Farben sind fr das LOGO

	dc.w	$180,$000,$182,$fff,$184,$200,$186,$310
	dc.w	$188,$410,$18a,$620,$18c,$841,$18e,$a73
	dc.w	$190,$b95,$192,$db6,$194,$dc7,$196,$111
	dc.w	$198,$222,$19a,$334,$19c,$99b,$19e,$446


	dc.w	$1a2,$fff			; COLOR17   Color
	dc.w	$1a4,$fa6			; COLOR18   der
	dc.w	$1a6,$000			; COLOR19   Maus

Bar:
	dc.w	$5c07,$fffe			; warte auf die Zeile $50
	dc.w	$180,$300			; starte den roten Balken: rot mit 3
	dc.w	$5d07,$fffe			; nchste Zeile
	dc.w	$180,$600			; rot mit 6
	dc.w	$5e07,$fffe
	dc.w	$180,$900			; rot mit 9
	dc.w	$5f07,$fffe
	dc.w	$180,$c00			; rot mit 12
	dc.w	$6007,$fffe
	dc.w	$180,$f00			; rot mit 15 (al massimo)
	dc.w	$6107,$fffe
	dc.w	$180,$c00			; rot mit 12
	dc.w	$6207,$fffe
	dc.w	$180,$900			; rot mit 9
	dc.w	$6307,$fffe
	dc.w	$180,$600			; rot mit 6
	dc.w	$6407,$fffe
	dc.w	$180,$300			; rot mit 3
	dc.w	$6507,$fffe
	dc.w	$180,$000			; color schwarz


; roter Balken unter dem Logo

	dc.w	$8407,$fffe			; Ende des logo

Bplpointers2:
	dc.w	$e0,$0000,$e2,$0000	; erste bitplane

	dc.w	$100,$1200			; 1 bitplane (zurcksetzen)

	dc.w	$8507,$fffe			; folgende Zeile
	dc.w	$180,$606			; violet
	dc.w	$8607,$fffe
	dc.w	$180,$909			; violet
	dc.w	$8707,$fffe
	dc.w	$180,$c0c			; violet
	dc.w	$8807,$fffe
	dc.w	$180,$f0f			; violet (maximal)
	dc.w	$8907,$fffe
	dc.w	$180,$c0c			; violet
	dc.w	$8a07,$fffe
	dc.w	$180,$909			; violet
	dc.w	$8b07,$fffe
	dc.w	$180,$606			; violet
	dc.w	$8c07,$fffe	
	dc.w	$180,$303			; violet
	dc.w	$8d07,$fffe		
	dc.w	$180,$000			; color schwarz

	dc.w	$182,$fe3			; Color Text

; zentrale Bar

	dc.w	$9007,$fffe			; folgende Zeile

	dc.w	$180,$011			; dunkelgrn mit 11
	dc.w	$9507,$fffe
	dc.w	$180,$022			; dunkelgrn mit 22
	dc.w	$9a07,$fffe
	dc.w	$180,$033			; dunkelgrn mit 33
	dc.w	$9f07,$fffe
	dc.w	$180,$055			; dunkelgrn mit 55
	dc.w	$a407,$fffe
	dc.w	$180,$077			; dunkelgrn mit 77
	dc.w	$a907,$fffe
	dc.w	$180,$099			; dunkelgrn mit 99
	dc.w	$ae07,$fffe
	dc.w	$180,$077			; dunkelgrn mit 77
	dc.w	$b307,$fffe
	dc.w	$180,$055			; dunkelgrn mit 55
	dc.w	$b807,$fffe
	dc.w	$180,$033			; dunkelgrn mit 33
	dc.w	$bd07,$fffe
	dc.w	$180,$022			; dunkelgrn mit 22
	dc.w	$c207,$fffe
	dc.w	$180,$011			; dunkelgrn mit 11

*****Bild am Boden:

	dc.w	$c607,$fffe			; auf Zeile $c6 warten
	dc.w	$180,$000			; color SCHWARZ

				; 5432109876543210
	dc.w	$100,%0001001000000000	; 1 bitplane LoRes

BplpointersBase:
	dc.w	$e0,$0000,$e2,$0000
CopBase:	
	dc.w	$0180,$0000,$0182,$0877

; violetter Balken ber dem Panel

	dc.w	$ca07,$fffe			; nchste Zeile
	dc.w	$180,$606			; violet
	dc.w	$cb07,$fffe
	dc.w	$180,$909			; violet
	dc.w	$cc07,$fffe	
	dc.w	$180,$c0c			; violet
	dc.w	$cd07,$fffe
	dc.w	$180,$f0f			; violet (maximal)
	dc.w	$ce07,$fffe
	dc.w	$180,$c0c			; violet
	dc.w	$cf07,$fffe
	dc.w	$180,$909			; violet
	dc.w	$d007,$fffe
	dc.w	$180,$606			; violet
	dc.w	$d107,$fffe
	dc.w	$180,$303			; violet
	dc.w	$d207,$fffe
	dc.w	$180,$000			; colore schwarz

	dc.w	$ca07,$fffe			; WAIT - warte auf Zeile $ca
	dc.w	$180,$001			; COLOR0 - sehr dunkelblau
	dc.w	$cc07,$fffe			; WAIT - warte auf Zeile $cc
	dc.w	$180,$002			; etwas intensiver blau
	dc.w	$ce07,$fffe			; nchstes wait 2 Zeilen tiefer
	dc.w	$180,$003			; blau mit 3
	dc.w	$d007,$fffe			; 
	dc.w	$180,$004			; blau mit 4
	dc.w	$d207,$fffe			; 
	dc.w	$180,$005			; blau mit 5
	dc.w	$d407,$fffe			; 
	dc.w	$180,$006			; blau mit 6
	dc.w	$d607,$fffe			; 
	dc.w	$180,$007			; blau mit 7
	dc.w	$d807,$fffe			; 
	dc.w	$180,$008			; blau mit 8
	dc.w	$da07,$fffe			; 
	dc.w	$180,$009			; blau mit 9
	dc.w	$e007,$fffe			; 
	dc.w	$180,$00a			; blau mit 10
	dc.w	$e507,$fffe			; 
	dc.w	$180,$00b			; blau mit 11
	dc.w	$ea07,$fffe			; 
	dc.w	$180,$00c			; blau mit 12
	dc.w	$f007,$fffe			; 
	dc.w	$180,$00d			; blau mit 13
	dc.w	$f507,$fffe			; 
	dc.w	$180,$00e			; blau mit 14
	dc.w	$fa07,$fffe			; 
	dc.w	$180,$00f			; blau mit 15

	dc.w	$ffdf,$fffe			; Warte auf Zeile $ff

	dc.w	$0207,$fffe			; warten
	dc.w	$182,$0f0			; color1 grn

	dc.w	$0f07,$fffe			; warten
	dc.w	$182,$f22			; color1 rot

	dc.w	$1c07,$fffe			; warten
	dc.w	$182,$ff0			; color1 gelb

	dc.w	$2907,$fffe			; warten
	dc.w	$182,$877			; color1 grau

	dc.w	$ffff,$fffe			; Ende copperlist

*******************************************************************************
*				Sprite														  *
*******************************************************************************
; Wie immer sollte die Grafik wie die copperliste NUR in CHIP geladen werden!!

MeinSprite0:
Vstart0:
	dc.b $50
Hstart0:
	dc.b $45
Vstop0:
	dc.b $5d
Vhbits0:
	dc.b $00
 dc.w	%0110000000000000,%1000000000000000
 dc.w	%0001100000000000,%1110000000000000
 dc.w	%1000011000000000,%1111100000000000
 dc.w	%1000000110000000,%1111111000000000
 dc.w	%0100000000000000,%0111111110000000
 dc.w	%0100000000000000,%0111111000000000
 dc.w	%0010000100000000,%0011111000000000
 dc.w	%0010010010000000,%0011111100000000
 dc.w	%0001001001000000,%0001101110000000
 dc.w	%0001000100100000,%0001100111000000
 dc.w	%0000000010000000,%0000000011100000
 dc.w	%0000000000000000,%0000000000000000
 dc.w	%0000000000000000,%0000000000000000
 dc.w	0,0


SpriteNull:					; Null-Sprite, auf das in der Copperlist gezeiget wird
	dc.l	0,0,0,0				; fr alle nicht verwendete Zeiger

PictureBase:
	incbin	"/Sources/base320x105x1.raw"	; 1 Bitplanes 
				
; Das ist das Bild 320 Pixel breit und 84 hoch, 4 Bitebenen (16 Farben).


Picture:
	incbin	"/Sources/logo320x84x16c.raw"	; 4 Bitplanes 
				
			
; Musik. Achtung: Die "music.s"-Routine von Diskette 2 ist nicht dieselbe wie
; die von Diskette 1. Die beiden nderungen betreffen die Entfernung eines BUGs
;

mt_data:
	dc.l	mt_data1

mt_data1:
	incbin	"/Sources/mod.JamInExcess"

	SECTION LEEREPLANE,BSS_C

;	Der Text wird in diesem Puffer gedruckt

Buffer:
	ds.b	40*68

	end			
								; Der Computer liest nicht ber das END hinaus!
								; Jetzt knnen wir alles ohne 
								; PUNKT und Komma oder Semikolon schreiben


Wenn wir mit jedem Tastendruck einen anderen Videoeffekt erzielen mchten, 
mssen wir wissen ob die linke Maustaste gedrckt wird und, wenn ja, die
Position des Sprite Mauszeigers. Kurz gesagt, wir mssen wissen, welche Taste
gedrckt wurde um einen anderen Videoeffekt auszufhren:

Sobald wir das Programm beginnen, finden wir eine berprfung: "Linke Taste
gedrckt?", Wenn die Taste nicht gedrckt wurde, wird das Programm fortgesetzt,
indem es aktualisiert wird, wobei der Pfeil auf dem Bildschirm bewegt wird und
wenn wir die Maustaste drcken, springen wir zu einer Routine, die die Position
von 
 - SpriteX
 - SpriteY
mit den Koordinaten, an denen sich unsere Schaltflchen befinden, vergleicht!

**************************** Tricks *****************************

Aber woher kennen wir die X- und Y-Koordinaten unserer "Button"? keine Sorge,
Sie mssen nicht Milliarden von Tests oder Berechnungen nach Augenma
durchfhren! Da der ASMONE einen eingebauten Monitor hat, knnen wir es so
machen: Entwerfen Sie das Bedienfeld mit seinen Schaltflchen, das Sie mchten. 
Wenn wir das ganze anzeigen, mssen wir nur noch wissen, welchen Koordinaten
die Tasten entsprechen und das erfolgt mit der Mausroutine. 

Wenn Sie die Position jeder Schaltflche berprfen mchten, setzen Sie einfach
an den Anfang des Programm (anstelle von ****1), diese einfache Schleife:

Wait:
	bsr.w	ReadMouse
	move.w	SpriteY(pc),d0
	move.w	SpriteX(pc),d1
	lea	MeinSprite0,a1
	moveq	#13,d2
	bsr.w	UniMoveSprite
	btst	#2,$dff016
	bne.w	Wait
	bra.w	Exit	

Dadurch wird die Mausposition aktualisiert und beim Drcken der linken
Maustaste, beenden wir einfach das Programm !!
Positionieren Sie sich an der gewnschten Koordinate, die Sie wissen mchten,
zum Beispiel an einer Ecke einer Schaltflche und beenden Sie das Programm mit
der linken Maustaste an dieser Stelle.
Jetzt mssen Sie nur noch die letzten Positionen sehen, die die Maus 
eingenommen hat mit dem mythischen "M"-Befehl (nach Drcken der ESC-Taste):

	m SpriteX   (RETURN drcken)
	m SpriteY   (RETURN drcken)

Der Befehl "M" ist sehr ntzlich. Er wird hufig verwendet, um zu berprfen,
an welchem "Punkt" oder bei welchem "Wert" es angekommen ist. Wenn Sie zum
Beispiel, ein Sprite oder einen Balken an einem bestimmten Punkt anhalten
wollen, machen Sie einfach eine Schleife, die es vorwrts bewegt bis die Maus
drcken. Starten Sie das Programm, drcken Sie die Maus, wenn es den
gewnschten Punkt erreicht haben, und machen Sie "M variable". Einfach !!!

***************************************************************************

Versuchen Sie testweise, das Sprite an verschiedenen Stellen auf dem
Bildschirm anzuzeigen. Versuchen Sie beim Starten des Programms auch, den
Mauszeiger in das Rechteck in der unteren Abbildung.

Sicherlich haben Sie schon bemerkt, dass, wenn Sie die Taste "+" oder "-"
drcken und die linke Maustaste nicht loslassen, wird der Balken weiter
angezeigt. Die Leiste wird unerschrocken fortgesetzt zu bewegen, auch wenn wir
den Pfeil aus der Schaltflche bewegen:
Dies liegt daran, dass wir, wie in **2 erlutert, bis zur Freigabe die
Maustaste drcken, prft das Programm die Mausposition nicht erneut!

Um dies zu ndern, fgen Sie einfach **2 hinzu:

	bsr.s	MoveArrow

natrlich das weglassen

	btst.b	#6,$bfe001
	beq.s	More

Versuchen Sie auch, Punkt ** 3 zu ndern 

jetzt einfach nur noch hinzufgen:

	brs.s	MoveArrow 

An den Punkten **4, **5 sehen Sie, was passiert:
Einfach die Taste eingeben oder verlassen und der Effekt startet!

Im Gegensatz zu den anderen Tasten reicht das fr die Tasten "Balkenfarbe
ndern" nur fahren Sie mit dem Mauszeiger darber, um den gewnschten Effekt
zu erzielen! Jetzt sollten sie wissen warum!

Schlielich "blockieren" die Tasten, die die Musik ein- und ausschalten, auch
die Pfeil ... fr Sie das schwierige Problem zu verstehen, warum.

	