
; Listing7w2.s	KOLLISIONEN ZWISCHEN UNGERADEN SPRITES
;
; In diesem Beispiel sehen wir, wie wir die Kollisionen zwischen ungeraden
; Sprites registrieren knnen. Diesmal sind zwei Raketen auf der Jagd nach
; dem Flugzeug, und einer der beiden ist ein ungerader Sprite.
; Wenn ihr das Programm startet, werdet ihr aber sehen, da die Rakete
; ganz rechts nicht funktioniert.
; Ihr wollt sie reparieren? Dann lest den Kommentar am Ende des Listings.

	SECTION CiriCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Name lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen das PIC auf die bliche Art

	move.l	#Pic,d0
	lea	Bplpointers,A1
	moveq	#2-1,d1
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0
	addq.w	#8,a1
	dbra	d1,PointBp

;	Pointen auf die Sprites

	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.l	#MeinSprite0,d0		; Adresse des Sprite in d0
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	add.l	#16,a1				; Spritepointer 2
	move.l	#MeinSprite2,d0		; Adresse des Sprite in d0
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	add.l	#8,a1				; Spritepointer 3
	move.l	#MeinSprite3,d0		; Adresse des Sprite in d0
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088			; START COP
	move.w	#0,$dff1fc			; NO AGA!
	move.w	#$c00,$dff106		; NO AGA!

Mouse:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	bne.s	Mouse

	bsr.s	BewegeSprite0		; Bewege das Flugzeug
	bsr.s	BewegeSprite2		; Bewege Rakete 1 gegen das Flugzeug
	bsr.s	BewegeSprite3		; Bewege Rakete 2 gegen das Flugzeug
	bsr.w	CheckColl			; Kontrolliert Kollisionen und greift ein

Warte:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	beq.s	Warte

	btst	#6,$bfe001			; Mouse gedrckt?
	bne.s	Mouse

	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088			; Starten die alte COP

	move.l	4.w,a6
	jsr	-$7e(a6)				 ; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine bewegt das Flugzeug um 2 Pixel pro Durchgang nach links

BewegeSprite0:
	subq.b	#1,Hstart0
	rts


; Diese Routine steuert die Rakete. Sie tut es nur, wenn das Flugzeug nah
; genug dran ist, um getroffen zu werden.


BewegeSprite2:
	cmp.b	#$b0,Hstart0
	bhi.s	NichtInSchusslinie2	; nicht starten, wenn das Flugzeug
	subq.b	#1,Vstart2				; zu weit rechts ist
	subq.b	#1,Vstop2
NichtInSchusslinie2:
	rts

; Diese Routine steuert die Rakete. Sie tut es nur, wenn das Flugzeug nah
; genug dran ist, um getroffen zu werden.

BewegeSprite3:
	cmp.b	#$d0,Hstart0
	bhi.s	NichtInSchusslinie3	; nicht starten, wenn das Flugzeug
	subq.b	#1,Vstart3				; zu weit rechts ist
	subq.b	#1,Vstop3
NichtInSchusslinie3:
	rts

; Diese Routine kontrolliert, ob es eine Kollision gab. Wenn ja, lscht sie
; die beiden Sprites, die zusammengestoen sind, indem sie die jeweiligen
; Spritepointer in der Copperlist lscht. Um unterscheiden zu knnen, welche
; der beiden Raketen ins Ziel gegangen ist, werden die Positionen abgefragt.
; In diesem Fall knnen die Raketen das Flugzeug nur von unten treffen; wenn
; sich eine Rakete also hher befindet als dieses, dann kann sie es nicht
; getroffen haben. Durch diese Methode knnen wir herausfinden, welche
; Rakete nun getroffen hat.

CheckColl:
	move.w	$dff00e,d0		; liest CLXDAT ($dff00e)
							; ein Lesevorgang dieses Register bewirkt
							; auch dessen komplette Lschung, es ist deshalb
							; ratsam, es sich in d0 zu kopieren, und dann
							; dort die Tests durchzufhren
	btst.l	#9,d0
	beq.s	NoColl	 		; wenn keine Kollision, berspringe

	moveq	#0,d0			; ansonsten lsche die Sprites
	lea	SpritePointers,a1	; Pointer Sprite 0
	move.w	d0,6(a1)		; Lsche Spritepointer 0 in der Copperlist
	move.w	d0,2(a1)

; Nun mssen wir noch verstehen, welche der beiden Raketen getroffen hat.
; Wir kontrollieren die Hhe der Rakete, die weiter rechts steht: wenn
; sie hher ist als das Flugzeug, dann KANN sie es NICHT getroffen haben.

	move.b	Vstart0,d1		; liest die Hhe des Flugzeuges
	cmp.b	Vstart3,d1		; vergleicht mit der Hhe der Rakete rechts
	bhi.s	Spr2Coll		; wenn das Flugzeug tiefer ist
							; (also Vstart0 grer als Vstart3 ist)
							; dann wurde die Kollision vom Sprite 2
							; ausgelst

	lea	SpritePointer3,a1	; ansonsten lsche Sprite 3
	move.w	d0,6(a1)		; Lscht Spritepointer 3 in der Copperlist
	move.w	d0,2(a1)
	bra.s	NoColl
	
Spr2Coll:
	lea	SpritePointer2,a1	; Lscht Sprite 2
	move.w	d0,6(a1)		; lscht Spritepointer 2 in der Copperlist
	move.w	d0,2(a1)
NoColl:
	rts


		SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0
SpritePointer2:
	dc.w	$128,0,$12a,0
SpritePointer3:
	dc.w	$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

			   ; 5432109876543210
	dc.w	$98,%0000000000000000	; CLXCON	$dff098

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,$0024		; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

		    ; 5432109876543210
	dc.w	$100,%0010001000000000	; 2 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste	Bitplane
	dc.w	$e4,0,$e6,0		; zweite Bitplane

	dc.w	$180,$000		; COLOR0	; schwarzer Hintergrund
	dc.w	$182,$005		; COLOR1	; Farbe 1 del bitplane
	dc.w	$184,$a40		; COLOR1	; Farbe 2 del bitplane
	dc.w	$186,$f80		; COLOR1	; Farbe 3 del bitplane

	dc.w	$1a2,$06f		; COLOR17, also COLOR1 des Sprite0
	dc.w	$1a4,$0c0		; COLOR18, also COLOR2 des Sprite0
	dc.w	$1a6,$0c0		; COLOR19, also COLOR3 des Sprite0

	dc.w	$1aa,$444		; COLOR21, also COLOR1 des Sprite2
	dc.w	$1ac,$888		; COLOR22, also COLOR2 des Sprite2
	dc.w	$1ae,$0c0		; COLOR23, also COLOR3 des Sprite2

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier ist der Sprite: KLARERWEISE in CHIP RAM! ************

MeinSprite0:	; Lnge 6 Zeilen
Vstart0:
	dc.b 180	; Vertikale Anfangsposition des Sprite (da $2c a $f2)
Hstart0:
	dc.b $d8	; Horizontale Anfangsposition des Sprite (da $40 a $d8)
Vstop0:
	dc.b 186	; 180+6=186
VhBits:
	dc.b $00
	dc.w	$0008,$0000
	dc.w	$1818,$0000
	dc.w	$2c28,$1010
	dc.w	$7ff8,$0000
	dc.w	$3fc0,$0000
	dc.w	$01c0,$0000
	dc.w	$0000,$0000

MeinSprite2:	; Lnge 16 Zeilen
Vstart2:
	dc.b 224	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart2:
	dc.b $86	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop2:
	dc.b 240
	dc.b 0
	dc.w	$0200,$0000
	dc.w	$0200,$0000
	dc.w	$0200,$0000
	dc.w	$0000,$0200
	dc.w	$0000,$0700
	dc.w	$0000,$0700
	dc.w	$0500,$0200
	dc.w	$0200,$0500
	dc.w	$0500,$0200
	dc.w	$0200,$0500
	dc.w	$1540,$0200
	dc.w	$0200,$1dc0
	dc.w	$0000,$1fc0
	dc.w	$0000,$1740
	dc.w	$0500,$0200
	dc.w	$0000,$0000
	dc.w	$0000,$0000

MeinSprite3:	; Lnge 16 Zeilen
Vstart3:
	dc.b 224	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart3:
	dc.b $a6	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop3:
	dc.b 240
	dc.b 0
	dc.w	$0200,$0000
	dc.w	$0200,$0000
	dc.w	$0200,$0000
	dc.w	$0000,$0200
	dc.w	$0000,$0700
	dc.w	$0000,$0700
	dc.w	$0500,$0200
	dc.w	$0200,$0500
	dc.w	$0500,$0200
	dc.w	$0200,$0500
	dc.w	$1540,$0200
	dc.w	$0200,$1dc0
	dc.w	$0000,$1fc0
	dc.w	$0000,$1740
	dc.w	$0500,$0200
	dc.w	$0000,$0000
	dc.w	$0000,$0000

;	Bild der Startrampe der Raketen

Pic:
	incbin	"/Sources/paesaggio.raw"

	end

Wie wir in der Lektion gesehen haben, erlaubt uns das Register CLXDAT  nur
zu  erkennen,  ob  eine Kollision zwischen Spritepaaren stattgefunden hat,
nicht zwischen den einzelnen Sprite. In diesem  Beispiel  sehen  wir,  wie
dieses  Problem  gelst  werden  kann.  Ich  erinnere  euch daran, da die
Kollisionen der geraden Sprite (also 0,2,4,6) immer  aktiviert  sind,  die
der  ungeraden  (1,3,5,7)  aber erst aktivert werden mssen. Das geschieht
durch Kontrollbits im Register CLXCON ($dff098). Jeder ungerade Sprite hat
ein  eigenes  Kontrollbit  und  kann demzufolge unabhngig von den anderen
eingeschaltet werden. Wenn ihr versucht,  das  Listing  auszufhren,  dann
bemerkt  ihr,  da die rechte Rakete nicht funktioniert. Das deshalb, weil
dieser Sprite ein ungerader ist (Sprite 3), und deaktiviert auch noch.  In
der Copperlist findet ihr folgenden Befehl:

			   ; 5432109876543210
	dc.w	$98,%0000000000000000

Er deaktiviert die Kollisionen fr alle ungeraden Sprites (fr die  genaue
Beschreibung  aller  Bits  seht  euch  die Lektion an). Um den Sprite 3 zu
aktivieren mu Bit 13 auf 1 gesetzt werden. Die Copperanweisung  mu  also
so aussehen:

		       ; 5432109876543210
	dc.w	$98,%0010000000000000

Probiert das Listing nun  aus,  und  ihr  werdet  sehen,  da  die  Rakete
funktioniert!

Ein  weiteres  Problem  der  Kollisionen  ist, da das Register CLXDAT nur
Kollisionen unter Spritepaaren aufsprt, nicht aber zwischen den einzelnen
Sprites.  In  unserem  Beispiel gehren die Raketen beide zum selben Paar.
Wenn nun eine Kollision auftritt  knnen  wir  nicht  wissen,  welche  der
beiden Raketen es gewesen ist, wenn wir nur das  Register CLXDAT lesen. Um
das zu erfahren ist die meistens verwendete Methode das kontrollieren  der
Spritepositionen.  In  diesem  recht  einfachem  Beispiel  braucht  nur
verglichen werden, ob der  Sprite  rechts  mehr  oder  weniger  ber  dem
Flugzeug ist, es ist besser im Kommentar der Routine CheckColl erklrt. In
komplexeren Situationen, bei denen sich die Sprites in mehrere  Richtungen
bewegen,  sind  aufwendigere  Kontrollen notwendig, dort mu man sich dann
auf vertikale und horizontale Position berufen. Das Prinzip ist aber immer
das gleiche.

Ihr  knnt  berprfen,  da  unsere  Routine  immer  die richtige  Rakete
erwischt, indem ihr die Startpositionen der rechten Rakete verndert.  Der
Anfangswert von Hstart3 ist auf $6a und garantiert der Rakete, da sie das
Flugzeug treffen wird. Ersetzt $6a durch $6b. Wenn ihr  das  Beispiel  nun
ausfhrt,  werdet ihr sehen, da sie nun das Flugzeug verfehlt. Aber keine
Angst! die zweite wird mitten rein dreschen!

