
; Listing7v1.s	PRIORITT SPRITE-PLAYFIELD
;		In diesem Listing werden die Prioritten zwischen den Sprite
;		und den Playfield vorgefhrt. Die Sprites durchqueren
;		vier Zeilen auf dem Bildschirm. Bei jedem Durchgang werden
;		die Prioritten mittels Copperlist verndert.

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Name lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf die bliche Art unser Pic an

	move.l	#PIC,d0
	lea	Bplpointers,A1
	moveq	#3-1,d1
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0
	addq.w	#8,a1
	dbra	d1,PointBp

;	Pointen auf die Sprites

	move.l	#MeinSprite0,d0		; Adresse des Sprite in d0
	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite1,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite2,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite3,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite4,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite5,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite6,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite7,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088			; START COP
	move.w	#0,$dff1fc			; NO AGA!
	move.w	#$c00,$dff106		; NO AGA!
	
Mouse:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	bne.s	Mouse

	bsr.s	BewegeSprites		; Bewege die Sprites nach unten

Warte1:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	beq.s	Warte1


	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse
	
	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088			; Starten die alte COP

	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine bewegt die 8 Sprites nach unten:
; Die Sprites werden einmal schon und einmal nicht bewegt. Deswegen wird
; die Variable Flag verwendet. Jedesmal, wenn die Routine ausgefhrt wird,
; verndert die Variable ihren Zustand, das geschieht mit einem NOT:
; wenn sie auf 0 war, dann wird sie $ffff
; wenn sie auf $ffff war, dann wird sie 0
; wenn die Variabel von 0 auf $ffff bergeht, dann werden die Sprites
; nicht bewegt.
; Alle Sprites haben die selbe Hhe.

BewegeSprites:

	not.w	Flag
	bne.w	Raus

; bewegt den Sprite 0

	addq.w	#1,Hoehe
	cmp.w	#300,Hoehe
	blo.s	NichtRand		; am unteren Rand angekommen?
	move.w	#$2c,Hoehe		; wenn ja, setz ihn wieder ganz rauf

NichtRand:
	move.w	Hoehe(pc),d0

	clr.b	VHBITS0			; Lsche die Bits 8 der horizontalen Position
	move.b	d0,Vstart0		; Kopiere die Bit von 0 bis 7 in Vstart
	btst.l	#8,d0			; ist die Position grer als 255?
	beq.s	NoBigVstart		; wenn nicht, dann geh weitde, denn das Bit wurde
							; bereits mit clr.b VhBits gelscht

	bset.b	#2,VhBits0		; ansonsten setze Bit 8 der vertikalen Startpos.
							; auf 1
NoBigVstart:
	addq.w	#8,d0			; Zhle die Lnge des Sprite dazu, um die
							; Endposition zu ermitteln (Vstop)
	move.b	d0,Vstop0		; Gib die Bit von 0 bis 7 in Vstop
	btst.l	#8,d0			; ist die Position grer als 255 ?
	beq.s	NoBigVstop		; wenn nicht, dann geh weiter, denn das Bit
							; wurde bereits mit clr.b VhBits gelscht

	bset.b	#1,VhBits0		; ansonsten setze Bit 8 der vertikalen Startp.
							; auf 1
NoBigVstop:

; kopiere die Hhe in die anderen Sprites

	move.b	Vstart0,Vstart1 ; kopiert Vstart
	move.w	vstop0,vstop1	; kopiert Vstop und VhBits

	move.b	Vstart0,Vstart2 ; kopiert Vstart
	move.w	vstop0,vstop2	; kopiert Vstop und VhBits

	move.b	Vstart0,Vstart3 ; kopiert Vstart
	move.w	vstop0,vstop3	; kopiert Vstop und VhBits

	move.b	Vstart0,Vstart4 ; kopiert Vstart
	move.w	vstop0,vstop4	; kopiert Vstop und VhBits

	move.b	Vstart0,Vstart5 ; kopiert Vstart
	move.w	vstop0,vstop5	; kopiert Vstop und VhBits

	move.b	Vstart0,Vstart6 ; kopiert Vstart
	move.w	vstop0,vstop6	; kopiert Vstop und VhBits

	move.b	Vstart0,Vstart7 ; kopiert Vstart
	move.w	vstop0,vstop7	; kopiert Vstop und VhBits

Raus:
	rts

Hoehe:
	dc.w	$2c
Flag:
	dc.w	0


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0011001000000000	; Bit 12 an!! 3 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0

	dc.w	$180,$000		; COLOR0 - schwarzer Hintergrund
	dc.w	$182,$ff0
	dc.w	$184,$800
	dc.w	$186,$0f0
	dc.w	$188,$ff0
	dc.w	$18a,$f00
	dc.w	$18c,$0f0
	dc.w	$18e,$0f0
	
	dc.w	$1a2,$f00		; Color17, - Color1 der Sprite0/1 -ROT
	dc.w	$1a4,$0f0		; Color18, - Color2 der Sprite0/1 -GRN
	dc.w	$1a6,$ff0		; Color19, - Color3 der Sprite0/1 -GELB

	dc.w	$1aa,$fff		; Color21, - Color1 der Sprite2/3 -WEI
	dc.w	$1ac,$0bd		; Color22, - Color2 der Sprite2/3 -WASSER
	dc.w	$1ae,$d50		; Color23, - Color3 der Sprite2/3 -ORANGE

	dc.w	$1b2,$00f		; Color25, - Color1 der Sprite4/5 -BLAU
	dc.w	$1b4,$f0f		; Color26, - Color2 der Sprite4/5 -VIOLETT
	dc.w	$1b6,$bbb		; Color27, - Color3 der Sprite4/5 -GRAU

	dc.w	$1ba,$8e0		; Color29, - Color1 der Sprite6/7 -HELLGRN
	dc.w	$1bc,$a70		; Color30, - Color2 der Sprite6/7 -BRAUN
	dc.w	$1be,$d00		; Color31, - Color3 der Sprite6/7 -DUNKELROT

; Ab hier beginnen die Befehle, die die Prioritt ndern.
; Ihr knnt sehen, da die Prioritten fr die geraden wie auch fr die
; ungeraden Bitplanes gleich sind, da wir hier mit einem einzigen Playfield
; arbeiten, und nicht einem Dual-Playfield: z.B. ist Wert $0009 der
; erste, der in das Register BPLCON2 geschrieben wird:
;
;		 5432109876543210
; $0009=%0000000000001001	ihr bemerkt da:
;
; in die Bits von 0 bis 2 kommt %001
; in die Bits von 3 bis 5 kommt %001, wie wir es vorausgesagt haben
;
; Ihr knnt es berprfen, es ist das selbe fr alle Werte, die in
; BPLCON2 geschrieben werden.


	dc.w	$104,$0000		; BPLCON2 - am Anfang alle Sprites darunter

	dc.w	$7007,$fffe		; WAIT - Warte das Ende des Streifens ab
	dc.w	$104,$0009		; BPLCON2 - Sprites 0,1 darber,
							; Sprites 2,3,4,5,6,7 darunter

	dc.w	$a007,$fffe		; WAIT - Warte das Ende des Streifens ab
	dc.w	$104,$0012		; BPLCON2 - Sprites 0,1,2,3 darber und
							; Sprites 4,5,6,7 darunter

	dc.w	$d007,$fffe		; WAIT - Warte das Ende des Streifens ab
	dc.w	$104,$001b		; BPLCON2 - Sprites 0,1,2,3,4,5 darber und
							; Sprites 6,7 darunter

	dc.w	$ff07,$fffe		; WAIT - Warte das Ende des Streifens ab
	dc.w	$104,$0024		; BPLCON2 - alle Sprites darber

	dc.w	$ffff,$fffe		; Ende der Copperlist

;			   543210
; ACH-	$0  = %000000 - alle Sprites darunter
; TUNG! $9  = %001001 - Sprites 0,1 darber	2,3,4,5,6,7 darunter
;	$12 = %010010 - Sprites 0,1,2,3 darber	4,5,6,7 darunter
;	$1b = %011011 - Sprites 0,1,2,3,4,5 darber	6,7 darunter
;	$24 = %100100 - alle Sprites darber



; ************ Hier die Sprite: KLARERWEISE in CHIP RAM! ************

 ; Referenztabelle zur Definition der Farben:


;  fr die Sprite 0 und 1
; BINR 00=COLOR 0 (TRANSPARENT)
; BINR 10=COLOR 1 (ROT)
; BINR 01=COLOR 2 (GRN)
; BINR 11=COLOR 3 (GELB)

MeinSprite0:	; Lnge: 8 Zeilen
Vstart0:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart0:
	dc.b $60	; Horizontale Pos. (von $40 bis $d8)
Vstop0:
	dc.b $68	; $60+8=$68	; Ende Vertikal
VHBITS0:
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite


MeinSprite1:	; Lnge: 8 Zeilen
Vstart1:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart1:
	dc.b $60+14	; Horizontale Pos. (von $40 bis $d8)
Vstop1:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000010001111
 dc.w	%0011111111111100,%1100000110000011
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0011111111111100,%1100000010000011
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

 ; fr die Sprite 2 und 3
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (WEI)
 ; BINR 01=COLOR 2 (WASSER)
 ; BINR 11=COLOR 3 (ORANGE)

MeinSprite2:	; Lnge: 8 Zeilen
Vstart2:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart2:
	dc.b $60+(14*2) ; Horizontale Pos. (von $40 bis $d8)
Vstop2:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0011111111111100,%1100001000100011
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0111111111111110,%1000000111000001
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

MeinSprite3:	; Lnge: 8 Zeilen
Vstart3:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart3:
	dc.b $60+(14*3) ; Horizontale Pos. (von $40 bis $d8)
Vstop3:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0111111111111110,%1000000111100001
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

 ; fr die Sprite 4 und 5
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (BLAU)
 ; BINR 01=COLOR 2 (VIOLETT)
 ; BINR 11=COLOR 3 (GRAU)

MeinSprite4:	; Lnge: 13 Zeilen
Vstart4:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart4:
	dc.b $60+(14*4) ; Horizontale Pos. (von $40 bis $d8)
Vstop4:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001001001111
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

MeinSprite5:	; Lnge: 8 Zeilen
Vstart5:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart5:
	dc.b $60+(14*5) ; Horizontale Pos. (von $40 bis $d8)
Vstop5:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

 ; fr die Sprite 6 und 7
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (HELLGRN)
 ; BINR 01=COLOR 2 (BRAUN)
 ; BINR 11=COLOR 3 (DUNKELROT)

MeinSprite6:	; Lnge: 8 Zeilen
Vstart6:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart6:
	dc.b $60+(14*6) ; Horizontale Pos. (von $40 bis $d8)
Vstop6:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000001001000001
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

MeinSprite7:	; Lnge: 8 Zeilen
Vstart7:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart7:
	dc.b $60+(14*7) ; Horizontale Pos. (von $40 bis $d8)
Vstop7:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite


	SECTION LEERESPLANE,BSS_C

PIC:
	incbin	"/Sources/prioritaet.raw"	; das Bild

	end

In diesem Listing  zeigen  wir,  wie  die  Prioritten  im  Gegensatz  zum
Playfiled  gendert  werden kann. Als Erstes bemerken wir, da die Sprites
immer ber dem COLOR0 erscheinen.  Fr  die  anderen  Farben  ist  in  der
Kontrolle  das Register BPLCON2 zustndig. Es ist mglich, die Prioritten
fr die geraden und die ungeraden Planes separat zu  setzen.  Das  ist  im
Dual-Playfield-Mode  sehr  wichtig.  Wenn  aber  mit "normalen" Playfields
gearbeitet wird, wie etwa in  diesem  Beispiel,  dann  werden  die  selben
Priritten  fr  die  geraden  und  die ungeraden Playfields verteilt. Um
zu sehen, wie die Prioritten verteilt sind, lest euch die Lektion durch.

Um die Prioritt mehrmals im selben Screen zu  ndern  verwenden  wir  den
Copper,  der es uns erlaubt, sie zu ndern, wenn sich die Sprites zwischen
einem Streifen und dem anderen befinden. Hier die Werte  fr  das  BPLCON2
($dff104):

;              543210
; ACH-  $0  = %000000 - alle Sprites darunter
; TUNG! $9  = %001001 - Sprites 0,1 darber      2,3,4,5,6,7 darunter
;       $12 = %010010 - Sprites 0,1,2,3 darber      4,5,6,7 darunter
;       $1b = %011011 - Sprites 0,1,2,3,4,5 darber      6,7 darunter
;       $24 = %100100 - alle Sprites darber

Ad: In der Grafik tauchen  folgende  Texte  auf,  die  ich  leider  nicht
bersetzen  konnte,  weil  sie  in  RAW vorliegen und ich recht wenig Zeit
hatte:

"Questa faccia appare sopra tutti gli Sprite"
           bedeutet soviel wie:
"Dieser Teil erscheint ber allen Sprites"


"Questa appare sotto gli Sprite xx e yy e sopra gli Sprites zz"
           bedeutet soviel wir:
"Dieser erscheint unter den Sprites xx und yy und ber den Sprites zz"


"Questa appare sotto tutti gli Sprites"
           bedeutet soviel wie:
"Diese erscheint unter allen Sprites"

Tut mit leid...
