
; Listing7g.s	EIN ATTACHED-SPRITE ZU 16 FARBEN WIRD MITTELS ZWEI TABELLEN
;				(X- und Y- Koordinaten) AM BILDSCHIRM BEWEGT

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Libname
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	
;	Pointen auf die Sprite 0 und 1, die zusammen einen einzigen Sprite
;	zu 16 Farben ergeben. Der Sprite 1, der ungerade ist, mu Bit 7 des zweiten
;	Word auf 1 haben.

	move.l	#MeinSprite0,d0	; Adresse des Sprite in d0
	lea	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite1,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	bset	#7,MeinSprite1+3	; Setzt das Bit fr Attached beim
							; Sprite 1. Ohne ihm sind die Sprites
							; nicht ATTACHED, sondern "normal"
	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106	; NO AGA!

Mouse:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	bne.s	Mouse
	
	bsr.w	BewegeSpriteX	; Bewege Sprite 0+1 in X-Richtung
	bsr.w	BewegeSpriteY	; Bewege Sprite 0+1 in Y-Richtung

Warte:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	beq.s	Warte

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse


	move.l	OldCop(pc),$dff080	; Pointen auf die alte SystemCOP
	move.w	d0,$dff088		; Starten die alte SystemCOP

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten
GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine bewegt den Sprite indem die auf das Byte Hstart, also
; dem Byte seiner X-Position,zugreift. Es werden die Werte einer vorausberechn.
; Tabelle (TabX) eingesetzt. Wenn wir nur auf Hstart agieren, dann bewegen wir
; den Sprite um jeweils 2 Pixel, und nicht nur einem, deswegen ist der Scroll
; etwas "ruckelig", vor allem wenn er langsamer wird.
; In den nchsten Listings werden wir dieses Manko beheben und mit einem Pixel
; scrollen.

BewegeSpriteX:
	addq.l	#1,TabXpoint		; Pointe auf das nchste Byte
	move.l	TabXpoint(pc),a0	; Adresse, die im Long TabXpoint enthalten ist
								; wird in a0 kopiert
	cmp.l	#EndeTabX-1,a0		; Sind wir beim letzten Long der TAB?
	bne.s	NobStartX			; noch nicht? dann mach weiter
	move.l	#TabX-1,TabXpoint	; Starte wieder beim ersten Long
NobStartX:
	move.b	(a0),MeinSprite0+1	; Kopie das Byte aus der Tabelle in Hstart0
	move.b	(a0),MeinSprite1+1	; Kopie das Byte aus der Tabelle in Hstart1
	rts

TabXpoint:
	dc.l	TabX-1

; Tabelle mit vorberechneten X-Koordinaten.

TabX:
	incbin	"/Sources/XCOORDINAT.TAB"	; 334 Werte
EndeTabX:

; Diese Routine bewegt den Sprite nach Oben und nach Unten, indem sie auf
; die Bytes Vstart und Vstop zugreift, also den Anfangs- und Endkoordinaten
; des Sprites. Es werden schon vordefinierte Koordinaten aus TabY eingesetzt.

BewegeSpriteY:
	addq.l	#1,TabYpoint		; Pointe auf das nchste Byte
	move.l	TabYpoint(pc),a0	; Adresse, die im Long TabXpoint enthalten ist
								; wird in a0 kopiert
	cmp.l	#EndeTabY-1,a0		; Sind wir beim letzten Long der TAB?
	bne.s	NobStartY			; noch nicht? dann mach weiter
	move.l	#TabY-1,TabYpoint	; Starte wieder beim ersten Long
NobStartY:
	moveq	#0,d0				; Lsche d0
	move.b	(a0),d0				; kopieren das Byte aus der Tabelle in d0
	move.b	d0,MeinSprite0		; kopieren das Byte in Vstart0
	move.b	d0,MeinSprite1		; kopieren das Byte in Vstart1
	add.b	#15,d0				; Zhle die Lnge eines Sprite dazu, um die
								; Endposition (Vstop) zu ermitteln
	move.b	d0,MeinSprite0+2	; Setze den richtigen Wert in Vstop0
	move.b	d0,MeinSprite1+2	; Setze den richtigen WErt in Vstop1
	rts

TabYpoint:
	dc.l	TabY-1				; Bemerke: die Werte der Tabelle sind Bytes

; Tabelle mit vorberechneten Y-Koordinaten.

TabY:
	incbin	"/Sources/YCOORDINAT.TAB"	; 200 Werte
EndeTabY:


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000	; Bit 12 an, 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

;	Palette der PIC

	dc.w	$180,$000		; Color0	; schwarzer Hintergrund
	dc.w	$182,$123		; Color1	; Color 1 des Bitplane, das
							; in diesem Fall leer ist,
							; also nicht erscheint

;	Palette der ATTACHED-SPRITE

	dc.w	$1a2,$ffc		; color17, Farbe 1 fr die Attached-Sprites transp.
	dc.w	$1a4,$eeb		; color18, Farbe 2 fr die Attached-Sprites
	dc.w	$1a6,$cd9		; color19, Farbe 3 fr die Attached-Sprites
	dc.w	$1a8,$ac8		; color20, Farbe 4 fr die Attached-Sprites
	dc.w	$1aa,$8b6		; color21, Farbe 5 fr die Attached-Sprites
	dc.w	$1ac,$6a5		; color22, Farbe 6 fr die Attached-Sprites
	dc.w	$1ae,$494		; color23, Farbe 7 fr die Attached-Sprites
	dc.w	$1b0,$384		; color24, Farbe 7 fr die Attached-Sprites
	dc.w	$1b2,$274		; color25, Farbe 9 fr die Attached-Sprites
	dc.w	$1b4,$164		; color26, Farbe 10 fr die Attached-Sprites
	dc.w	$1b6,$154		; color27, Farbe 11 fr die Attached-Sprites
	dc.w	$1b8,$044		; color28, Farbe 12 fr die Attached-Sprites
	dc.w	$1ba,$033		; color29, Farbe 13 fr die Attached-Sprites
	dc.w	$1bc,$012		; color30, Farbe 14 fr die Attached-Sprites
	dc.w	$1be,$001		; color31, Farbe 15 fr die Attached-Sprites

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier die Sprites: KLARERWEISE in CHIP RAM! **********

MeinSprite0:	; Lnge 15 Zeilen
Vstart0:
	dc.b $00	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart0:
	dc.b $00	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop0:
	dc.b $00	; Vertikale Endposition des Sprite
	dc.b $00

	dc.w $0380,$0650,$04e8,$07d0,$0534,$1868,$1e5c,$1636 ; Daten des
	dc.w $377e,$5514,$43a1,$1595,$0172,$1317,$6858,$5035 ; Sprite 0
	dc.w $318c,$0c65,$7453,$27c9,$5ece,$5298,$0bfe,$2c32
	dc.w $005c,$13c4,$0be8,$0c18,$03e0,$03e0

	dc.w	0,0	; 2 auf 0 gesetzte Word markieren das Ende des Sprite


MeinSprite1:	; Lnge 15 Zeilen
Vstart1:
	dc.b $00	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart1:
	dc.b $00	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop1:
	dc.b $00	; $50+13=$5d	; Vertikale Endposition des Sprite
	dc.b $00	; Bit 7 setzen, un die Sprites 0 und 1 zu vermhlen

	dc.w $0430,$07f0,$0fc8,$0838,$0fe4,$101c,$39f2,$200e ; Daten des
	dc.w $58f2,$600e,$5873,$600f,$5cf1,$600f,$1ff3,$600f ; Sprite 1
	dc.w $4fe3,$701f,$47c7,$783f,$6286,$7d7e,$300e,$3ffe
	dc.w $1c3c,$1ffc,$0ff8,$0ff8,$03e0,$03e0

	dc.w	0,0	; 2 auf 0 gesetzte Word markieren das Ende des Sprites

	SECTION LEERESPLANE,BSS_C ; Ein auf 0 gesetztes Bitplane, wir
							; mssen es verwenden, denn ohne Bitplane
							; ist es nicht mglich, die Sprites
							; zu aktivieren
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end

Auer der Neuigkeit des Attached-Bits, um einen Sprite in 16 Farben  statt
in 4 erscheinen zu lassen, gibts da noch einige Dinge:

1) Die Tabellen fr X und Y wurden mit dem Befehl "WB"  abgespeichert  und
werden  nun mit dem Incbin geladen, eingebunden. Somit knnen verschiedene
Programme auf die selbe Tabelle zugreifen, Hauptsache, sie  befindet  sich
auf der Disk!
2) Es werden nicht mehr die Label Vstart0, Vstart1,  Hstart0  und  Hstart1
etc.  verwendet, um den Sprite zu bewegen. Die angesprochenen Bytes werden
nun auf folgende Weise erreicht:


	MeinSprite				; Fr Vstart
	MeinSprite+1			; Fr Hstart
	MeinSprite+2			; Fr Vstop

Damit kann ein Sprite ganz einfach so begonnen werden:

MeinSprite:
	DC.W	0,0
	..Daten..

Ohne die zwei Words in einzelne Bytes zerlegen zu mssen,  und  jedem  ein
Label  zuzuteilen.  Das  Verlngert  das  Listing  nur.  Auch um Bit 7 des
zweiten  Word  von  Sprite  1  zu  setzen,  um  also den AttachedModus
einzuschalten, reicht folgende Operation:

	bset	#7,MeinSprite1+3

Ansonsten htten wir es "von Hand" in diesem vierten Byte setzen mssen:

MeinSprite1:
Vstart1:
	dc.b $00
Hstart1:
	dc.b $00
Vstop1:
	dc.b $00
	dc.b %10000000			; oder dc.b $80 ($80=%10000000)

Wenn alle 8 Sprite verwendet werden mssen, dann  spart  man  damit  einen
Haufen  Labels  und  sonstigen Platz. Noch besser wre es, die Adresse des
Sprites in ein Ax-Register  zu  geben  um  dann  mit  Offsets  dorthin  zu
gelangen, wohin man will:


	lea	MeinSprite,a0
	move.b	#yy,(a0)		; Fr Vstart
	move.b	#xx,1(a0)		; Fr Hstart
	move.b	#y2,2(a0)		; Fr Vstop

Sich in Binrform einen Sprite in 16 Farben zu definieren wird so  langsam
problematisch.	Deswegen  ist  es  besser,  man  verlt  sich  auf  ein
Malprogramm, man mu sich nur erinnern, da ein Screen  zu  16  Farben  zu
whlen ist und die Sprites nicht breiter als 16 Pixel werden drfen. Einmal
das Pic in 16 Farben  im  IFF-Format  abgespeichert  (oder  einen  Brush),
werden wir ihn mit dem IFF-Konverter genauso wie ein Bild konvertieren.

BEMERKUNG:  Unter  Brush versteht man ein Stck eines Bildes mit variabler
Gre.

Und so wird ein Sprite mit dem Kefcon konvertiert:

1) Ladet das IFF-File, das zu 16 Farben sein mu.
2) Ihr drft nur den Sprite auswhlen, um das zu  tun  drckt  die  rechte
Taste,  dann  positioniert  euch  in die linke, obere Ecke des zuknftigen
Sprite und drckt die linke Taste. Wenn ihr nun die Maus bewegt, erscheint
ein  Gittermuster,  das - wie es das Schicksal will - genau 16 Pixel breit
ist.  Ihr  knnt  natrlich  auch  die  Breite  und  Lnge	des	Sprites
kontrollieren. Um den Sprite richtig reinzukriegen mt ihr beachten, da
ihr  den  Rand  des  Sprite  mit	dem	"Auswahlstrich"	des	Quadrates
berschreiten  mt,  die  letzte noch beinhaltete Zeile des Quadrates ist
die, die auf der Grenze verluft, und nicht die innerhalb des Quadrates.


	<----- 16 pixel ----->

	|========####========| /\
	||     ########	    || ||
	||   ############   || ||
	|| ################ || ||
	||##################|| ||
	###################### ||
	###################### Lnge des Sprite, maximal 256 Pixel
	###################### ||
	||##################|| ||
	|| ################ || ||
	||   ############   || ||
	||     ########	    || ||
	|========####========| \/

Wenn der Sprite kleiner als 16 Pixel ist, dann mt ihr einen freien  Rand
lassen,  auf  beiden  Rndern  oder  nur auf einem, so, da die Breite des
Blocks immer 16 ist.

Einmal ausgewhlt, mu der Sprite  als  "SPRITE16"  abgespeichert  werden,
oder  als  "SPRITE4", wenn es sich um einen "normalen" Sprite handelt. Der
Sprite wird in dc.b abgespeichert, also in Textformat, das  ihr  dann  mit
"I" im Listing einbinden knnt. Oder in einen anderen Textbuffer laden und
dann mit Amiga+b+c+i hinberkopieren.

Und so speichert der KEFCON einen Attached-Sprite ab (16 Farben):

	dc.w $0000,$0000
	dc.w $0380,$0650,$04e8,$07d0,$0534,$1868,$1e5c,$1636
	dc.w $377e,$5514,$43a1,$1595,$0172,$1317,$6858,$5035
	dc.w $318c,$0c65,$7453,$27c9,$5ece,$5298,$0bfe,$2c32
	dc.w $005c,$13c4,$0be8,$0c18,$03e0,$03e0
	dc.w 0,0

	dc.w $0000,$0000
	dc.w $0430,$07f0,$0fc8,$0838,$0fe4,$101c,$39f2,$200e
	dc.w $58f2,$600e,$5873,$600f,$5cf1,$600f,$1ff3,$600f
	dc.w $4fe3,$701f,$47c7,$783f,$6286,$7d7e,$300e,$3ffe
	dc.w $1c3c,$1ffc,$0ff8,$0ff8,$03e0,$03e0
	dc.w 0,0

Wie ihr seht haben diese beiden Sprite die beiden Kontrollword  auf  NULL,
die  Daten  in Hexadezimal und die zwei auf 0 gesetzten Word, die das Ende
des Sprite markieren. Einfach die Label "Meinsprite0:" und  "Meinsprite1:"
am  Anfang  dieser  Sprites  geben,  und  dann  mit  Meinsprite+x  auf die
jeweiligen Bytes zugreifen, z.B. Koordinaten, Bit 7...  Das  Einzige,  das
noch  fehlt, ist ist das Setzen des Bit 7 fr den Attached-Modus, entweder
mit einem BSET #7,MeinSprite+3 oder direkt im Sprite:

MeinSprite1:
	dc.w $0000,$0080		; $80, oder %10000000 -> ATTACCHED!

	dc.w $0430,$07f0,$0fc8,$0838,$0fe4,$101c,$39f2,$200e
	...

Wenn ihr nur Sprites zu 4 Farben macht, dann erbrigt sich das Problem, da
das Bit nicht gesetzt werden mu!

Was  die  Palette  der Sprites angeht, so mssen sie mit der Option COPPER
abgespeichert werden, genauso wie bei einem Bild. Das Problem  dabei  ist,
da  alles  wie  ein  Bild  zu 16 Farben aufgefat wird, und nicht wie ein
Sprite:

	dc.w $0180,$0000,$0182,$0ffc,$0184,$0eeb,$0186,$0cd9
	dc.w $0188,$0ac8,$018a,$08b6,$018c,$06a5,$018e,$0494
	dc.w $0190,$0384,$0192,$0274,$0194,$0164,$0196,$0154
	dc.w $0198,$0044,$019a,$0033,$019c,$0012,$019e,$0001

Die Farben sind richtig, aber die Register beziehen sich auf die ersten 16
Farben, und nicht die letzten. Da mu man Hand  anlegen  und  sie  in  die
richtigen Register bringen:

	dc.w	$1a2,$ffc		; COLOR17, COLOR  1 fr die Attached-Sprites
	dc.w	$1a4,$eeb		; COLOR18, COLOR  2 fr die Attached-Sprites
	dc.w	$1a6,$cd9		; COLOR19, COLOR  3 fr die Attached-Sprites
	dc.w	$1a8,$ac8		; COLOR20, COLOR  4 fr die Attached-Sprites
	dc.w	$1aa,$8b6		; COLOR21, COLOR  5 fr die Attached-Sprites
	dc.w	$1ac,$6a5		; COLOR22, COLOR  6 fr die Attached-Sprites
	dc.w	$1ae,$494		; COLOR23, COLOR  7 fr die Attached-Sprites
	dc.w	$1b0,$384		; COLOR24, COLOR  7 fr die Attached-Sprites
	dc.w	$1b2,$274		; COLOR25, COLOR  9 fr die Attached-Sprites
	dc.w	$1b4,$164		; COLOR26, COLOR 10 fr die Attached-Sprites
	dc.w	$1b6,$154		; COLOR27, COLOR 11 fr die Attached-Sprites
	dc.w	$1b8,$044		; COLOR28, COLOR 12 fr die Attached-Sprites
	dc.w	$1bA,$033		; COLOR29, COLOR 13 fr die Attached-Sprites
	dc.w	$1bc,$012		; COLOR30, COLOR 14 fr die Attached-Sprites
	dc.w	$1be,$001		; COLOR31, COLOR 15 fr die Attached-Sprites

Man bemerke, da in $1a2 der Wert von $182 kopiert werden mu, in $1a4 der
von $184 und so weiter.

Versucht, den Sprite zu 16 Farben aus diesem Listing mit einem  eigenem zu
ersetzen,  mit  eurer  Palette,  und  auch einen zu 4 Farben aus den alten
Listings zu konvertieren. Es zu Tun wird  euch  helfen,  alles  besser  zu
verstehen!!!


