
; Listing7f.s	ANZEIGEN ALLER 8 SPRITE DES AMIGA

;	In diesem Listing wird gezeigt, da alle 8 Sprites ihre Palette
;	in Paaren gemeinsam haben, also Sprite 0 die gleiche wie Sprite1
;	hat, Sprite 2 die gleichen Farben wie Sprite 3 und so weiter.
;	Es wird auch gezeigt, wie die Prioritten bei berlagerungen
;	verteilt sind, also da der mit der kleineren Nummer ber dem
;	mit einer greren Vorrang hat, also ber diesem angezeigt wird.
;	Sprite 0 wird also ber allen anderen angezeigt, Sprite 7 hingegen
;	kann von allen anderen berdeckt werden. Sprite 3 z.B. berdeckt
;	die Sprites 4,5,6,7, wird aber selbst von 0,1 und 2 berdeckt.
;	Durch Drcken der linken Maustaste berlappen sich die Sprites
;	und die Prioritten sind gut erkennbar. Rechte Maustaste zum
;	Aussteigen.

	SECTION CipundCop,CODE
	
Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Libname
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Pointen auf die Sprite

	move.l	#MeinSprite0,d0	; Adresse des Sprite in d0
	lea	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite1,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite2,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite3,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite4,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite5,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite6,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite7,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106	; NO AGA!

Mouse:
	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse

	moveq	#$60,d0			; Anfangskoordinate Hstart
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
						    ; (zu Bemerken, da das Byte Hstart immer 2 Pixel
						    ; nimmt, wenn wir uns also um 10 Pixel verstellen
						    ; wollen mssen wir nur 5 zu Hstart dazuzhlen!)
	move.b	d0,Hstart1
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart2
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart3
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart4
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart5
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart6
	addq.b	#(10/2),d0		; Abstand zum nchsten Sprite
	move.b	d0,Hstart7

MouseRechts:
	btst	#2,$dff016
	bne.s	MouseRechts

	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088		; Starten die alte Cop

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; bit 12 an!! 1 bitplane lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste	bitplane

	dc.w	$180,$000		; Color0	; schwarzer Hintergrund
	dc.w	$182,$123		; Color1	; Color1 des Bitplane, das
							; hier leer ist, es erscheint
							; also nicht.

	dc.w	$1a2,$f00		; Color17, - Color1 der Sprite0/1 -ROT
	dc.w	$1a4,$0f0		; Color18, - Color2 der Sprite0/1 -GRN
	dc.w	$1a6,$ff0		; Color19, - Color3 der Sprite0/1 -GELB

	dc.w	$1aa,$fff		; Color21, - Color1 der Sprite2/3 -WEI
	dc.w	$1ac,$0bd		; Color22, - Color2 der Sprite2/3 -WASSER
	dc.w	$1ae,$d50		; Color23, - Color3 der Sprite2/3 -ORANGE

	dc.w	$1b2,$00f		; Color25, - Color1 der Sprite4/5 -BLAU
	dc.w	$1b4,$f0f		; Color26, - Color2 der Sprite4/5 -VIOLETT
	dc.w	$1b6,$bbb		; Color27, - Color3 der Sprite4/5 -GRAU

	dc.w	$1ba,$8e0		; Color29, - Color1 der Sprite6/7 -HELLGRN
	dc.w	$1bc,$a70		; Color30, - Color2 der Sprite6/7 -BRAUN
	dc.w	$1be,$d00		; Color31, - Color3 der Sprite6/7 -DUNKELROT

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier die Sprite: KLARERWEISE in CHIP RAM! ************

; Referenztabelle zur Definition der Farben:


; fr die Sprite 0 und 1
; BINR 00=COLOR 0 (TRANSPARENT)
; BINR 10=COLOR 1 (ROT)
; BINR 01=COLOR 2 (GRN)
; BINR 11=COLOR 3 (GELB)

MeinSprite0:				; Lnge: 8 Zeilen
Vstart0:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart0:
	dc.b $60				; Horizontale Pos. (von $40 bis $d8)
Vstop0:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite


MeinSprite1:				; Lnge: 8 Zeilen
Vstart1:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart1:
	dc.b $60+14				; Horizontale Pos. (von $40 bis $d8)
Vstop1:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000010001111
 dc.w	%0011111111111100,%1100000110000011
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0011111111111100,%1100000010000011
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

 ; fr die Sprite 2 und 3
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (WEI)
 ; BINR 01=COLOR 2 (WASSER)
 ; BINR 11=COLOR 3 (ORANGE)

MeinSprite2:				; Lnge: 8 Zeilen
Vstart2:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart2:
	dc.b $60+(14*2)			; Horizontale Pos. (von $40 bis $d8)
Vstop2:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0011111111111100,%1100001000100011
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0111111111111110,%1000000111000001
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MeinSprite3:				; Lnge: 8 Zeilen
Vstart3:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart3:
	dc.b $60+(14*3)			; Horizontale Pos. (von $40 bis $d8)
Vstop3:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0111111111111110,%1000000111100001
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0				; Ende des Sprite

 ; fr die Sprite 4 und 5
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (BLAU)
 ; BINR 01=COLOR 2 (VIOLETT)
 ; BINR 11=COLOR 3 (GRAU)

MeinSprite4:				; Lnge: 8 Zeilen
Vstart4:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart4:
	dc.b $60+(14*4)			; Horizontale Pos. (von $40 bis $d8)
Vstop4:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001001001111
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MeinSprite5:				; Lnge: 8 Zeilen
Vstart5:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart5:
	dc.b $60+(14*5)			; Horizontale Pos. (von $40 bis $d8)
Vstop5:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

 ; fr die Sprite 6 und 7
 ; BINR 00=COLOR 0 (TRANSPARENT)
 ; BINR 10=COLOR 1 (HELLGRN)
 ; BINR 01=COLOR 2 (BRAUN)
 ; BINR 11=COLOR 3 (DUNKELROT)

MeinSprite6:				; Lnge: 8 Zeilen
Vstart6:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart6:
	dc.b $60+(14*6)			; Horizontale Pos. (von $40 bis $d8)
Vstop6:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000001001000001
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

MeinSprite7:				; Lnge: 8 Zeilen
Vstart7:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart7:
	dc.b $60+(14*7)			; Horizontale Pos. (von $40 bis $d8)
Vstop7:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0					; Ende des Sprite

		SECTION LEERESPLANE,BSS_C
							; Ein auf 0 gesetztes Bitplane, wir
							; mssen es verwenden, denn ohne Bitplane
							; ist es nicht mglich, die Sprites
							; zu aktivieren
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end


In  diesem  Listing werden alle 8 Sprites "gepointet", jeder von ihnen hat
die Nummer gezeichnet. Wie schon  in  der  Theorie  erklrt  haben  die  8
Sprites 4 separate Paletten, deswegen teilen sich immer zwei nebenstehende
Sprites eine Palette:

	dc.w	$1a2,$f00		; Color17, - Color1 der Sprite0/1 -ROT
	dc.w	$1a4,$0f0		; Color18, - Color2 der Sprite0/1 -GRN
	dc.w	$1a6,$ff0		; Color19, - Color3 der Sprite0/1 -GELB

	dc.w	$1aa,$fff		; Color21, - Color1 der Sprite2/3 -WEI
	dc.w	$1ac,$0bd		; Color22, - Color2 der Sprite2/3 -WASSER
	dc.w	$1ae,$d50		; Color23, - Color3 der Sprite2/3 -ORANGE

	dc.w	$1b2,$00f		; Color25, - Color1 der Sprite4/5 -BLAU
	dc.w	$1b4,$f0f		; Color26, - Color2 der Sprite4/5 -VIOLETT
	dc.w	$1b6,$bbb		; Color27, - Color3 der Sprite4/5 -GRAU

	dc.w	$1ba,$8e0		; Color29, - Color1 der Sprite6/7 -HELLGRN
	dc.w	$1bc,$a70		; Color30, - Color2 der Sprite6/7 -BRAUN
	dc.w	$1be,$d00		; Color31, - Color3 der Sprite6/7 -DUNKELROT


Zu Bemerken ist, da die Farben 16, 20, 24 und 28 nicht  von  den  Sprites
verwendet  werden,  sie  werden bersprungen, da sie dem Color0 des Sprite
entsprechen wrden, also  dem  TRANSPARENT,  das  eben  keine  Farbe  ist,
sondern  eher  als  "LOCH"  aufgefasst werden kann. Er nimmt die Farbe des
darunterliegenden Bitplane (oder Sprite) an. Jeder Sprite hat sein Vstart,
Vstop und Hstart, sehen wir z.B. Sprite2:


MeinSprite2:				; Lnge: 8 Zeilen
Vstart2:
	dc.b $60				; Vertikale Pos. (von $2c bis $f2)
Hstart2:
	dc.b $60+(14*2)			; Horizontale Pos. (von $40 bis $d8)
Vstop2:
	dc.b $68				; $60+8=$68	; Ende Vertikal
	dc.b $00


Jeder  Sprite  ist  von  den  anderen distanziert, indem wir zu Hstart ein
(14*x) dazugezhlt haben. Nach dem linken  Mausdruck  werden  alle  Hstart
auer  dem ersten gendert, um sie alle zu berlagern. Das Veranschaulicht
dann die Priotitten.

