
; Listing6p.s	DRUCKEN EINEN BUCHSTABEN PRO FRAME AUF DEN BILDSCHIRM

	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Namen der Lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		;
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP
	
;	POINTEN AUF UNSERE BITPLANES

	move.l	#Bitplane,d0
	lea	Bplpointers,a1		; COP - Pointer
	move.w	d0,6(a1)
	swap	d0		
	move.w	d0,2(a1)	

	move.l	#Copperlist,$dff080	; COP1LC - unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

Mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	bne.s	Mouse

	bsr.w	PrintCharakter	; Drucken einen Buchstaben pro Frame

Warte:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	beq.s	Warte		

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse

	move.l	OldCop(pc),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	GfxBase(pc),a1
	jsr	-$19e(a6)			; Closelibrary 
	rts


; DATEN



GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0


; Diese Routine ist eine Art Mischling zwischen der normalen Print-Routine
; und der Tabellenroutine, denn wir verwenden einen Text auf dieselbe Art
; wie es bei der Tabelle der Fall war, einen Wert nach dem anderen, einen
; pro Fotogramm, und der kommt dann auf den Screen. Des Weiteren mssen wir
; auch die Adresse im Bitplane der letzten vom Print erreichten Position 
; abspeichern, um den nchsten genau nach ihn setzen zu knnen. Um zwischen
; einem Frame und dem anderen die Adresse im Text und im Bitplane zu merken,
; verwenden wir zwei Longword als Pointer:
;
; PointeText:
;	dc.l	Text
;
; PointeBitplane:
;	dc.l	Bitplane
;
; Jedesmal, wenn die Routine ausgefhrt wird, wird ein Buchstabe
; gedruckt, und es wird der Pointer auf Text "upgedatet" (mit einem
; addq.l #1, das ihn auf den nchsten Buchstaben bringt, da einer
; genau 1 Byte lang ist) und auch der Pointer auf das Bitplane, denn
; jeder Buchstaben hat seinen Platz im Bitplane.
; Das erste Problem besteht darin, da alle 40 Zeichen eine neue (Text-)
; Zeile genommen werden mu, also 40*7 Bytes zum Bitplanepointer dazugezhlt
; werden mu. Um dieses Problem zu lsen wurde einfach eine NULL am Ende
; einer jeden Textzeile angehngt, die uns mitteilt, da wir am Ende sind
; und wir 40*7 zum Bitplanepointer und 1 zum Textpointer dazuzhlen mssen.
; Das zweite Problem war, da wir aufhren mssen Buchstaben zu drucken,
; wenn wir am Ende des Textes angekommen sind. Per Konvention schlieen wir
; somit die Zeile statt mit $00 mit $ff ab, somit knnen wir die Routine
; verlassen, wenn wir dieses "Zeichen" erreichen. Einfach das gelesene Byte
; kontrollieren, und wenn es $ff ergibt, nichts mehr drucken, keine Pointer
; verstellen, nix mehr. Wenn wir nun beim nchsten Durchgang wieder auf $ff
; treffen (weil wir den Pointer nicht vorgestellt haben), wird wieder nichts 
; getan, usw.
; Ihr knnt euch mehrere solcher "Spezialzeichen" erfinden, Hauptsache,
; sie liegen nicht im Bereich zwischen $20 und $80, also den Buchstaben
; gewidmeten Bytes.


PrintCharakter:
	move.l	PointeText(pc),a0 ; Adresse des zu druckenden Textes in a0
	moveq	#0,d2			; Lsche d2
	move.b	(a0)+,d2		; Nchster Buchstaben in d2
	cmp.b	#$ff,d2			; Ende-Text Signal? ($ff)
	beq.s	EndeTEXT		; Wenn ja, raus, ohne was zu drucken
	tst.b	d2				; Ende-Zeile Signal? ($00)
	bne.s	NichtEndeZeile	; Wenn nicht, nimm keine neue (Text-)Zeile

	add.l	#40*7,PointeBitplane	; NEUE TEXTZEILE
	addq.l	#1,PointeText	; erster Buchstabe in der neuen Zeile
							; (berspringen die NULL)
	move.b	(a0)+,d2		; erster Buchstabe in der neuen Zeile
							; (berspringen die NULL)

NichtEndeZeile:
	sub.b	#$20,d2			; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG,
							; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
							; (Das $20 entspricht), IN $00, DAS
							; AUSRUFUNGSZEICHEN ($21) IN $01...
	mulu.w	#8,d2			; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
							; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#FONT,a2		; FINDE DEN GEWNSCHTEN BUCHSTEBEN IM FONT

	move.l	PointeBitplane(pc),a3 ; Adresse des Ziel-Bitplane in a3

							; DRUCKE DEN BUCHSTABEN ZEILE FR ZEILE
	move.b	(a2)+,(a3)		; Drucke Zeile 1 des Buchstaben
	move.b	(a2)+,40(a3)	; Drucke Zeile 2  "	"
	move.b	(a2)+,40*2(a3)	; Drucke Zeile 3  "	"
	move.b	(a2)+,40*3(a3)	; Drucke Zeile 4  "	"
	move.b	(a2)+,40*4(a3)	; Drucke Zeile 5  "	"
	move.b	(a2)+,40*5(a3)	; Drucke Zeile 6  "	"
	move.b	(a2)+,40*6(a3)	; Drucke Zeile 7  "	"
	move.b	(a2)+,40*7(a3)	; Drucke Zeile 8  "	"

	addq.l	#1,PointeBitplane ; 8 Bit weiter vor (NCHSTER BUCHSTABE)
	addq.l	#1,PointeText	; nchster zu druckende Buchstabe

EndeTEXT:
	rts


PointeText:
	dc.l	Text

PointeBitplane:
	dc.l	Bitplane

;	$00 fr "Ende Zeile" - $ff fr "Ende Text"

		; Anzahl Charakter pro Zeile: 40
Text:           ;         1111111111222222222233333333334
	dc.b	'   ERSTE ZEILE                          ',0 ; 1
	dc.b	'                ZWEITE ZEILE            ',0 ; 2
	dc.b	'     /\  /                              ',0 ; 3
	dc.b	'    /  \/                               ',0 ; 4
	dc.b	'                                        ',0 ; 5
	dc.b	'        SECHSTE ZEILE                   ',0 ; 6
	dc.b	'                                        ',0 ; 7
	dc.b	'                                        ',0 ; 8
	dc.b	'FABIO CIUCCI COMMUNICATION INTERNATIONAL',0 ; 9
	dc.b	'                                        ',0 ; 10
	dc.b	'   1234567890 !@#$%^&*()_+|\=-[]{}      ',0 ; 11
	dc.b	'                                        ',0 ; 12
	dc.b	'     ICH DENKE, ALSO BIN ICH...         ',0 ; 15
	dc.b	'                                        ',0 ; 16
	dc.b	'                                        ',0 ; 17
	dc.b	'  Das Fraeulein stand am Meere,         ',0 ; 18
	dc.b	'    Und seufzte lang und bang,          ',0 ; 19
	dc.b	'    Es ruehrte sie so sehre,            ',0 ; 20
	dc.b	'  Der Sonnenuntergang.   (...)          ',0 ; 21
	dc.b	'                                        ',0 ; 22
	dc.b	' Schon draufgekommen...? Noch nicht...? ',0 ; 23
	dc.b	' Es war: . . . . . . . Heinrich Heine ! ',$ff ; 24 Ende


	even


	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt (Register mit Normalwerten)
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

		    ; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an - 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000		; Color0 - Hintergrund
	dc.w	$0182,$19a		; Color1 - Schrift

	dc.w	$ffff,$fffe		; Ende der Copperlist

;	Der FONT, Charakter 8x8

FONT:
;	incbin	"/Sources/metal.fnt"	; Breiter Zeichensatz
;	incbin	"/Sources/normal.fnt"	; hnlich dem aus dem Kickstart 1.3
	incbin	"/Sources/nice.fnt"	; Schmaler Zeichensatz

	SECTION MEIPLANE,BSS_C	; Die SECTION BSS knnen nur aus NULLEN
							; bestehen!!! Man verwendet das DS.B um zu
							; definieren, wieviele Nullen die Section
							; enthalten soll

Bitplane:
	ds.b	40*256			; eine Bitplane, 320x256 LowRes

	end


