
; Listing5n.s	KOMBINATION VON 3 COPPER-EFFEKTEN + BILD IN 8 FARBEN MIT
;				$dff102 und Bitplanepointer-EFFEKTEN

	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName(PC),a1		; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes

;	POINTEN AUF UNSERE BITPLANES

	move.l	#Pic,d0			; in d0 kommt die Adresse von unserem Bild
	lea Bplpointers,a1		; in a1 kommt die Adresse der Bitplane-
							; Pointer der Copperlist
	moveq	#2,d1			; Anzahl der Bitplanes -1 (hier sind es 3)
							; fr den dbra - Zyklus
PointBp:
	move.w	d0,6(a1)		; kopiert das niederwertige Word der Plane-
							; Adresse ins richtige Word der Copperlist
	swap	d0				; vertauscht die 2 Word in d0 (1234 > 3412)

	move.w	d0,2(a1)		; kopiert das hochwertige Word der Adresse des 
							; Plane in das richtige Word in der Copperlist
	swap	d0				; vertauscht erneut die 2 Word von d0
	add.l	#40*256,d0		; Zhlen 10240 zu d0 dazu, -> nchstes Plane

	addq.w	#8,a1			; zu den nchsten Bplpointers in der Cop
	dbra	d1,PointBp		; Wiederhole d1 mal PointBp (d1=n. bitplanes)

	move.l	#Copperlist,$dff080	; COP1LC - "Zeiger" auf unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

	bsr.w	mt_init			; Initialisiert Musik-Routine

Mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	bne.s	Mouse			; Wenn nicht, geh nicht weiter

	bsr.w	BewegeCopper	; Roter Bylken unter $FF
	bsr.s	CopperLinkRech	; Routine fr links-rechts Scroll
	bsr.w	ScrollColors	; Zyklisches scrollen der Farben
	bsr.w	ScrollPlanes	; Rauf-und Runterscrollen des Bildes
	bsr.w	Wellen			; Wellen mit dem $dff102
	bsr.w	mt_music		; Spielt die Musik

Warte:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	beq.s	Warte			; Wenn nicht, geh nicht weiter

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	bsr.w	mt_end			; Beendet die Musikroutine

	move.l	OldCop(PC),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(PC),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts

; DATEN

GfxName:
	dc.b	"graphics.library",0,0	

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0	; Betriebssystemes

; **************************************************************************
; *		HORIZONTAL LAUFENDER BALKEN	(Listing3h.s)		   *
; **************************************************************************

CopperLinkRech:
	cmpi.w	#85,FlagRechts	; GehRechts 85 Mal ausgefhrt?
	bne.s	GehRechts		; wenn nicht, wiederhole nochmal
							; wenn es aber 85 Mal ausgefhrt wurde,
							; dann geh weiter

	cmpi.w	#85,FlagLinks	; GehLinks 85 Mal ausgefhrt?
	bne.s	GehLinks		; wenn nicht, wiederhole nochmal

	clr.w	FlagRechts		; Die Routine GehLinks wurde 85 Mal ausge-
	clr.w	FlagLinks		; fhrt, also ist zu diesem Zeitpunkt der
							; graue Balken zurckgekommen und der Rechts-
							; GehLinks 85 Mal, etcetera.
	rts						; ZURCK ZUM MOUSE-LOOP

GehRechts:					; Diese Routine bewegt den Balken nach RECHTS
	lea	CopBar+1,a0			; Wir geben in A0 die Adresse des ersten XX-
							; Wertes des ersten Wait, das sich genau 1 Byte
							; nach CopBar befindet

	move.w	#29-1,d2		; wir men 29 Wait verndern (verwenden ein dbra)
RechtsLoop:
	addq.b	#2,(a0)			; zhlen 2 zu der X-Koordinate des Wait dazu
	add.w	#16,a0			; gehen zum nchsten Wait, das zu ndern ist
	dbra	d2,RechtsLoop	; Zyklus wird d2-Mal durchlaufen
	addq.w	#1,FlagRechts	; vermerken, da wir ein weiteres Mal GehRechts
							; ausgefhrt haben
							; GehRechts: in FlagRechts steht die Anzahl,
							; wie oft wir GehRechts ausgefhrt haben
	rts						; Zurck zum Mouse-Loop


GehLinks:					; diese Routine bewegt den Balken nach LINKS
	lea	CopBar+1,a0
	move.w	#29-1,d2		; wir men 29 Wait verndern
LinksLoop:
	subq.b	#2,(a0)			; ziehen der X-Koordinate des Wait 2 ab
	add.w	#16,a0			; gehen zum nchsten Wait ber, das zu verndern ist
	dbra	d2,LinksLoop    ; Zyklus wird d2-Mal durchgefhrt
	addq.w	#1,FlagLinks	; Zhlen 1 zur Anzahl dazu, wie oft diese Routine
							; GehLinks ausgefhrt wurde
	rts						; Zurck zum Mouse-Loop

FlagRechts:					; In diesem Word wird die Anzahl festgehalten,
	dc.w	0				; wie oft GehRechts ausgefhrt wurde

FlagLinks:					; In diesem Word wird die Anzahl festgehalten,
	dc.w	0				; wie oft GehLinks ausgefhrt wurde

; **************************************************************************
; *		ROTER BALKEN UNTER Zeile $FF (LISTING3f.s)		   *
; **************************************************************************

BewegeCopper:
	lea	Balken,a0			; in a0 kommt die Adresse von Balken
	tst.b	RaufRunter		; Men wir steigen oder sinken? Wenn RaufRunter
							; auf 0 steht (wenn TST also BEQ liefert), dann
							; springen wir auf GEHRUNTER, wenn es hingegen
							; auf $FF ist (TST also nicht eintrifft), fahren
	beq.w	GehRunter		; wir fort und fhren somit den "steigenden" Teil
							; aus

	cmpi.b	#$0a,(a0)		; sind wir bei Zeile $0a+$ff angekommen?
	beq.s	SetzRunter		; wenn ja, sind wir oben angekommen und
	subq.b	#1,(a0)			; men runter
	subq.b	#1,8(a0)
	subq.b	#1,8*2(a0)		; nun ndern wir die anderen Wait: der
	subq.b	#1,8*3(a0)		; Abstand zwischen einem und dem anderen betrgt
	subq.b	#1,8*4(a0)		; 8 Byte
	subq.b	#1,8*5(a0)
	subq.b	#1,8*6(a0)
	subq.b	#1,8*7(a0)		; hier men wir alle 9 Wait des roten Balken
	subq.b	#1,8*8(a0)		; ndern, wenn wir ihn steigen und sinken lassen
	subq.b	#1,8*9(a0)		; wollen.
	rts


SetzRunter:
	clr.b	RaufRunter		; Setzt RaufRunter auf 0, beim tst.b RaufRunter
	rts						; wird das BEQ zu Routine GEHRUNTER verzweigen,
							; und der Balken wird sinken

GehRunter:
	cmpi.b	#$2c,8*9(a0)	; sind wir bei Zeile $2c angekommen?
	beq.s	SetzRauf		; wenn ja, sind wir untern und men wieder
	addq.b	#1,(a0)			; steigen
	addq.b	#1,8(a0)
	addq.b	#1,8*2(a0)		; nun ndern wir die anderen Wait: der
	addq.b	#1,8*3(a0)		; Abstand zwischen einem und dem anderen betrgt
	addq.b	#1,8*4(a0)		; 8 Byte
	addq.b	#1,8*5(a0)
	addq.b	#1,8*6(a0)
	addq.b	#1,8*7(a0)		; hier men wir alle 9 Wait des roten Balken
	addq.b	#1,8*8(a0)		; ndern, wenn wir ihn steigen und sinken lassen
	addq.b	#1,8*9(a0)		; wollen.
	rts

SetzRauf:
	move.b	#$ff,RaufRunter	; Wenn das Label nicht auf NULL ist,
	rts						; bedeutet es, da wir steigen men

RaufRunter:
	dc.b	0,0

; **************************************************************************
; *		ZYKLISCHES SCROLLEN DER FARBEN (LISTING3E.s)		   *
; **************************************************************************

ScrollColors:
	move.w	col2,col1		; col2 kommt in col1
	move.w	col3,col2		; col3 kommt in col2
	move.w	col4,col3		; col4 kommt in col3
	move.w	col5,col4		; col5 kommt in col4
	move.w	col6,col5		; col6 kommt in col5
	move.w	col7,col6		; col7 kommt in col6
	move.w	col8,col7		; col8 kommt in col7
	move.w	col9,col8		; col9 kommt in col8
	move.w	col10,col9		; col10 kommt in col9
	move.w	col11,col10		; col11 kommt in col10
	move.w	col12,col11		; col12 kommt in col11
	move.w	col13,col12		; col13 kommt in col12
	move.w	col14,col13		; col14 kommt in col13
	move.w	col1,col14		; col1 kommt in col14
	rts

; **************************************************************************
; *	SCROLL NACH OBEN UND UNTEN DES BILDEN	(aus Listing5g.s)	   *
; **************************************************************************

ScrollPlanes:
	lea Bplpointers,a1		; Mit diesen 4 Anweisungen holen wir aus der
	move.w	2(a1),d0		; Copperlist die Adresse, wohin das $dff0e0
	swap	d0				; gerade pointet und geben diesen Wert
	move.w	6(a1),d0		; in d0

	tst.b	RaufRunter2		; Men wir nach oben oder unten?

	beq.w	GehRunter2
	cmp.l	#Pic-(40*18),d0 ; sind wir weit genug OBEN?
	beq.s	SetzRunter2		; wenn ja, sind wir am Ende und men runter
	sub.l	#40,d0			; subtrahieren 40, also 1 Zeile, dadurch
							; wandert das Bild nach UNTEN
	bra.s	Ende3


SetzRunter2:
	clr.b	RaufRunter2		; Durch Lschen von RaufRunter wird das TST
	bra.s	Ende2

GehRunter2:
	cmpi.l	#Pic+(40*130),d0; sind wir weit genug UNTEN?
	beq.s	SetzRauf2		; wenn ja, sind wir am unteren Ende und
							; men wieder rauf			
	add.l	#40,d0			; Addieren 40, also 1 Zeile, somit scrollt
							; das Bild nach OBEN
	bra.s	Ende2

SetzRauf2:
	move.b	#$ff,RaufRunter2; Wenn das Label nicht auf NULL steht,
	rts						; bedeutet das, da wir rauf men
	
Ende2:						; POINTEN DIE BITPLANEPOINTER AN
	lea Bplpointers,a1		; POINTER in der Copperlist
	moveq	#2,d1			; Anzahl der Bitplanes -1 (hier: 3)

PointBp2:
	move.w	d0,6(a1)		; kopiert das niederw. Word der Adress des Pl.
	swap	d0				; vertauscht die 2 Word von d0 (1234 > 3412)
	move.w	d0,2(a1)		; kopiert das hherw. Word der Adresse des Pl.
	swap	d0				; vertauscht die 2 Word von d0 (3412 > 1234)
	add.l	#40*256,d0		; + Lnge Bitplane -> nchstes Bitplane
	addq.w	#8,a1			; zu den nchsten bplpointers in der Cop
	dbra	d1,PointBp2		; Wiederhole d1 Mal PointBp (d1=n. bitplanes)
	rts

RaufRunter2:
	dc.b	0,0

; **************************************************************************
; *	WELLENEFFEKT MITTELS MODULO $dff102 (LISTING5H.S)					   *
; **************************************************************************

Wellen:
	lea	Con1Effekt+8,a0		; Adresse Quellword in a0
	lea	Con1Effekt,a1		; Adresse Zielword in a1
	moveq	#19,d2			; 45 BPLCON1 sind in COPLIST zu ndern
Vertausche:
	move.w	(a0),(a1)		; kopiert zwei Word - scroll!
	addq.w	#8,a0			; nchstes Word-Paar
	addq.w	#8,a1			; nchstes Word-Paar
	dbra	d2,Vertausche	; wiederhole "Vertausche" die richtige Anzahl mal

	move.w	Con1Effekt,LetzterWert	; um den Zyklus unendlich fortlaufen zu
	rts						; lassen kopieren wir den ersten Wert

; **************************************************************************
; *		ROUTINE ZUM ABSPIELEN VON SOUNDTRACKER/PROTRACKER	               *
; **************************************************************************

	include "/Sources/musicE.s"		; Routine, die zu 100% auf allen Amigas funktioniert

; **************************************************************************
; *				SUPER Copperlist										   *
; **************************************************************************

	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt	Register mit Standartwerten)
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

; das BPLCON0 ($dff100) fr einen Bildschirm mit 3 Bitplanes: (8 Farben)

			    ; 5432109876543210
	dc.w	$100,%0011001000000000	; bits 13 und 12 an!! (3 = %011)

;	Wir lassen die Bitplanes direkt anpointen, indem wir die Register
;	$dff0e0 und folgende hier in der Copperlist einfgen. Die
;	Adressen der Bitplanes werden dann von der Routine PointBp
;	automatisch eingetragen

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane - BPL0PT
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane - BPL1PT
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane - BPL2PT

;	Die 8 Farben des Bildes werden hier definiert:

	dc.w	$0180,$000		; color0
	dc.w	$0182,$070		; color1
	dc.w	$0184,$0f0		; color2
	dc.w	$0186,$0c0		; color3
	dc.w	$0188,$090		; color4
	dc.w	$018a,$030		; color5
	dc.w	$018c,$070		; color6
	dc.w	$018e,$040		; color7

; Der Effekt aus Listing3e.s, weiter nach oben verschoben

	dc.w	$2c07,$fffe		; warten auf Zeile 154 ($9a in hexadezimal)
	dc.w	$180			; Register COLOR0
col1:
	dc.w	$0f0			; WERT DES COLOR 0 (wird verndert)
	dc.w	$2d07,$fffe		; warten auf Zeile 155 (wird nicht verndert)
	dc.w	$180			; Register COLOR0 (wird nicht verndert)
col2:
	dc.w	$0d0			; WERT DES COLOR 0 (will be modified)
	dc.w	$2e07,$fffe		; warten auf Zeile 156 (not modified, ecc.)
	dc.w	$180			; Register COLOR0
col3:
	dc.w	$0b0			; WERT DES COLOR 0
	dc.w	$2f07,$fffe		; warten auf Zeile 157
	dc.w	$180			; Register COLOR0
col4:
	dc.w	$090			; WERT DES COLOR 0
	dc.w	$3007,$fffe		; warten auf Zeile 158
	dc.w	$180			; Register COLOR0
col5:
	dc.w	$070			; WERT DES COLOR 0
	dc.w	$3107,$fffe		; warten auf Zeile 159
	dc.w	$180			; Register COLOR0
col6:
	dc.w	$050			; WERT DES COLOR 0
	dc.w	$3207,$fffe		; warten auf Zeile 160
	dc.w	$180			; Register COLOR0
col7:
	dc.w	$030			; WERT DES COLOR 0
	dc.w	$3307,$fffe		; warten auf Zeile 161
	dc.w	$180			; color0... (nun habt ihr schon verstanden,
col8:						; ab hier kann ichs mir sparen!)
	dc.w	$030
	dc.w	$3407,$fffe		; Zeile 162
	dc.w	$180
col9:
	dc.w	$050
	dc.w	$3507,$fffe		; Zeile 163
	dc.w	$180
col10:
	dc.w	$070
	dc.w	$3607,$fffe		; Zeile 164
	dc.w	$180
col11:
	dc.w	$090
	dc.w	$3707,$fffe		; Zeile 165
	dc.w	$180
col12:
	dc.w	$0b0
	dc.w	$3807,$fffe		; Zeile 166
	dc.w	$180
col13:
	dc.w	$0d0
	dc.w	$3907,$fffe		; Zeile 167
	dc.w	$180
col14:
	dc.w	$0f0
	dc.w	$3a07,$fffe		; Zeile 168

	dc.w	$0180,$000		; color0	; reale Farben des Bildes
	dc.w	$0182,$475		; color1
	dc.w	$0184,$fff		; color2
	dc.w	$0186,$ccc		; color3
	dc.w	$0188,$999		; color4
	dc.w	$018a,$232		; color5
	dc.w	$018c,$777		; color6
	dc.w	$018e,$444		; color7

;	Coppereffekt der Wellen mit dem $dff102 aus Listing5h.s, "geschmlert"

	dc.w	$102
Con1Effekt:
	dc.w	$000
	dc.w	$4007,$fffe,$102,$00
	dc.w	$4407,$fffe,$102,$11
	dc.w	$4807,$fffe,$102,$11
	dc.w	$4c07,$fffe,$102,$22
	dc.w	$5007,$fffe,$102,$33
	dc.w	$5407,$fffe,$102,$44
	dc.w	$5807,$fffe,$102,$66
	dc.w	$5c07,$fffe,$102,$66
	dc.w	$6007,$fffe,$102,$77
	dc.w	$6407,$fffe,$102,$77
	dc.w	$6807,$fffe,$102,$77
	dc.w	$6c07,$fffe,$102,$66
	dc.w	$7007,$fffe,$102,$66
	dc.w	$7407,$fffe,$102,$55
	dc.w	$7807,$fffe,$102,$33
	dc.w	$7c07,$fffe,$102,$22
	dc.w	$8007,$fffe,$102,$11
	dc.w	$8407,$fffe,$102,$11
	dc.w	$8807,$fffe,$102,$00
	dc.w	$8c07,$fffe,$102
LetzterWert:
	dc.w	$00

;	EFFEKT AUS Listing3h.s

	dc.w	$9007,$fffe		; warten auf Anfang der Zeile
	dc.w	$180,$000		; Grau auf Minimum, oder SCHWARZ!
CopBar:
	dc.w	$9031,$fffe		; Wait, das wir verndern ($9033,$9035,$9037..)
	dc.w	$180,$100		; Farbe Rot
	dc.w	$9107,$fffe		; Wait, das wir nicht verndern (Beginn Zeile)
	dc.w	$180,$111		; Farbe GRAU (Beginnt beim Anfang der Zeile und
	dc.w	$9131,$fffe		; geht bis zu diesem Wait, das wir nicht ndern
	dc.w	$180,$200		; danach beginnt das ROT

;	FIXE WAIT	(dann Grau)	- zu ndernde WAIT (gefolgt von Rot)

	dc.w	$9207,$fffe,$180,$120,$9231,$fffe,$180,$301 ; Zeile 3
	dc.w	$9307,$fffe,$180,$230,$9331,$fffe,$180,$401 ; Zeile 4
	dc.w	$9407,$fffe,$180,$240,$9431,$fffe,$180,$502 ; Zeile 5
	dc.w	$9507,$fffe,$180,$350,$9531,$fffe,$180,$603 ; ....
	dc.w	$9607,$fffe,$180,$360,$9631,$fffe,$180,$703
	dc.w	$9707,$fffe,$180,$470,$9731,$fffe,$180,$803
	dc.w	$9807,$fffe,$180,$580,$9831,$fffe,$180,$904
	dc.w	$9907,$fffe,$180,$690,$9931,$fffe,$180,$a04
	dc.w	$9a07,$fffe,$180,$7a0,$9a31,$fffe,$180,$b04
	dc.w	$9b07,$fffe,$180,$8b0,$9b31,$fffe,$180,$c05
	dc.w	$9c07,$fffe,$180,$9c0,$9c31,$fffe,$180,$d05
	dc.w	$9d07,$fffe,$180,$ad0,$9d31,$fffe,$180,$e05
	dc.w	$9e07,$fffe,$180,$be0,$9e31,$fffe,$180,$f05
	dc.w	$9f07,$fffe,$180,$cf0,$9f31,$fffe,$180,$e05
	dc.w	$a007,$fffe,$180,$be0,$a031,$fffe,$180,$d05
	dc.w	$a107,$fffe,$180,$ad0,$a131,$fffe,$180,$c05
	dc.w	$a207,$fffe,$180,$9c0,$a231,$fffe,$180,$b04
	dc.w	$a307,$fffe,$180,$8b0,$a331,$fffe,$180,$a04
	dc.w	$a407,$fffe,$180,$7a0,$a431,$fffe,$180,$904
	dc.w	$a507,$fffe,$180,$690,$a531,$fffe,$180,$803
	dc.w	$a607,$fffe,$180,$580,$a631,$fffe,$180,$703
	dc.w	$a707,$fffe,$180,$470,$a731,$fffe,$180,$603
	dc.w	$a807,$fffe,$180,$360,$a831,$fffe,$180,$502
	dc.w	$a907,$fffe,$180,$250,$a931,$fffe,$180,$402
	dc.w	$aa07,$fffe,$180,$140,$aa31,$fffe,$180,$301
	dc.w	$ab07,$fffe,$180,$130,$ab31,$fffe,$180,$202
	dc.w	$ac07,$fffe,$180,$120,$ac31,$fffe,$180,$103
	dc.w	$ad07,$fffe,$180,$111,$ad31,$fffe,$180,$004

	dc.w	$ae07,$fffe
	dc.w	$180,$002
	dc.w	$af07,$fffe
	dc.w	$180,$003

;	Zylinder-Spiegel-Effekt aus Listing3g.s (+neudefinition der Farben)

	dc.w	$0182,$235		; color1
	dc.w	$0184,$99e		; color2
	dc.w	$0186,$88c		; color3
	dc.w	$0188,$659		; color4
	dc.w	$018a,$122		; color5
	dc.w	$018c,$337		; color6
	dc.w	$018e,$224		; color7

	dc.w	$b007,$fffe
	dc.w	$180,$004		; Color0
	dc.w	$102,$011		; bplcon1
	dc.w	$108,-40*7		; Bpl1Mod - Spiegel 5 Mal halbiert
	dc.w	$10a,-40*7		; Bpl2Mod
	dc.w	$b307,$fffe

	dc.w	$180,$006		; Color0
	dc.w	$102,$022		; bplcon1
	dc.w	$108,-40*6		; Bpl1Mod - Spiegel 4 Mal halbiert
	dc.w	$10a,-40*6		; Bpl2Mod

	dc.w	$b607,$fffe

	dc.w	$0182,$245		; color1
	dc.w	$0184,$9cf		; color2
	dc.w	$0186,$89c		; color3
	dc.w	$0188,$669		; color4
	dc.w	$018a,$132		; color5
	dc.w	$018c,$347		; color6
	dc.w	$018e,$234		; color7

	dc.w	$180,$008		; Color0
	dc.w	$102,$033		; bplcon1
	dc.w	$108,-40*5		; Bpl1Mod - Spiegel 3 Mal halbiert
	dc.w	$10a,-40*5		; Bpl2Mod

	dc.w	$bb07,$fffe

	dc.w	$180,$00a		; Color0
	dc.w	$102,$044		; bplcon1
	dc.w	$108,-40*4		; Bpl1Mod - Spiegel 2 Mal halbiert
	dc.w	$10a,-40*4		; Bpl2Mod

	dc.w	$c307,$fffe

	dc.w	$0182,$355		; color1
	dc.w	$0184,$abf		; color2
	dc.w	$0186,$9ac		; color3
	dc.w	$0188,$779		; color4
	dc.w	$018a,$232		; color5
	dc.w	$018c,$457		; color6
	dc.w	$018e,$344		; color7
	dc.w	$180,$00c		; Color0
	dc.w	$102,$055		; bplcon1
	dc.w	$108,-40*3		; Bpl1Mod - Spiegel halbiert
	dc.w	$10a,-40*3		; Bpl2Mod

	dc.w	$d007,$fffe

	dc.w	$180,$00e		; Color0
	dc.w	$102,$066		; bplcon1
	dc.w	$108,-40*2		; Bpl1Mod - Spiegel normal
	dc.w	$10a,-40*2		; Bpl2Mod

	dc.w	$d607,$fffe
	dc.w	$0182,$465		; color1
	dc.w	$0184,$cdf		; color2
	dc.w	$0186,$bbc		; color3
	dc.w	$0188,$889		; color4
	dc.w	$018a,$232		; color5
	dc.w	$018c,$557		; color6
	dc.w	$018e,$444		; color7

	dc.w	$180,$00f		; Color0
	dc.w	$102,$077		; bplcon1
	dc.w	$108,-40		; Bpl1Mod - FLOOD, Zeilen wiederholt, fr
	dc.w	$10a,-40		; Bpl2Mod - Vergrerungseffekt in der Mitte

	dc.w	$da07,$fffe

	dc.w	$0182,$355		; color1
	dc.w	$0184,$abf		; color2
	dc.w	$0186,$9ac		; color3
	dc.w	$0188,$779		; color4
	dc.w	$018a,$232		; color5
	dc.w	$018c,$457		; color6
	dc.w	$018e,$344		; color7
	dc.w	$180,$00e		; Color0
	dc.w	$102,$066		; bplcon1
	dc.w	$108,-40*2		; Bpl1Mod - Spiegel normal
	dc.w	$10a,-40*2		; Bpl2Mod

	dc.w	$e007,$fffe

	dc.w	$0182,$245		; color1
	dc.w	$0184,$9cf		; color2
	dc.w	$0186,$89c		; color3
	dc.w	$0188,$669		; color4
	dc.w	$018a,$132		; color5
	dc.w	$018c,$347		; color6
	dc.w	$018e,$234		; color7
	dc.w	$180,$00c		; Color0
	dc.w	$102,$055		; bplcon1
	dc.w	$108,-40*3		; Bpl1Mod - Spiegel halbiert
	dc.w	$10a,-40*3		; Bpl2Mod

	dc.w	$ed07,$fffe

	dc.w	$180,$00a		; Color0
	dc.w	$102,$044		; bplcon1
	dc.w	$108,-40*4		; Bpl1Mod - Spiegel 2 Mal halbiert
	dc.w	$10a,-40*4		; Bpl2Mod

	dc.w	$f507,$fffe

	dc.w	$0182,$235		; color1
	dc.w	$0184,$99e		; color2
	dc.w	$0186,$88c		; color3
	dc.w	$0188,$659		; color4
	dc.w	$018a,$122		; color5
	dc.w	$018c,$337		; color6
	dc.w	$018e,$224		; color7
	dc.w	$180,$008		; Color0
	dc.w	$102,$033		; bplcon1
	dc.w	$108,-40*5		; Bpl1Mod - Spiegel 3 Mal halbiert
	dc.w	$10a,-40*5		; Bpl2Mod

	dc.w	$fa07,$fffe

	dc.w	$180,$006		; Color0
	dc.w	$102,$022		; bplcon1
	dc.w	$108,-40*6		; Bpl1Mod - Spiegel 4 Mal halbiert
	dc.w	$10a,-40*6		; Bpl2Mod

	dc.w	$fd07,$fffe

	dc.w	$180,$004		; Color0
	dc.w	$102,$011		; bplcon1
	dc.w	$108,-40*7		; Bpl1Mod - Spiegel 5 Mal halbiert
	dc.w	$10a,-40*7		; Bpl2Mod

	dc.w	$ff07,$fffe

	dc.w	$180,$002		; Color0
	dc.w	$102,$000		; bplcon1
	dc.w	$108,-40		; Stoppt das Bild um zu vermeiden, da Bytes
	dc.w	$10a,-40		; vor dem RAW angezeigt werden

;	Effekt aus Listing3f.s

	dc.w	$ffdf,$fffe		; ACHTUNG! WAIT am Ende der Zeile $FF!
							; die Wait nach dieser Zeile befinden sich
							; unter $FF, starten aber bei $00!!

	dc.w	$0107,$fffe		; ein fixer, grner Balken unter der Zeile $FF!
	dc.w	$180,$010
	dc.w	$0207,$fffe
	dc.w	$180,$020
	dc.w	$0307,$fffe
	dc.w	$180,$030
	dc.w	$0407,$fffe
	dc.w	$180,$040
	dc.w	$0507,$fffe
	dc.w	$180,$030
	dc.w	$0607,$fffe
	dc.w	$180,$020
	dc.w	$0707,$fffe
	dc.w	$180,$010
	dc.w	$0807,$fffe
	dc.w	$180,$000

Balken:
	dc.w	$0907,$fffe		; Warte auf Zeile $79
	dc.w	$180,$300		; Beginne die rote Zeile: Rot auf 3
	dc.w	$0a07,$fffe		; nchste Zeile
	dc.w	$180,$600		; Rot auf 6
	dc.w	$0b07,$fffe
	dc.w	$180,$900		; Rot auf 9
	dc.w	$0c07,$fffe
	dc.w	$180,$c00		; Rot auf 12
	dc.w	$0d07,$fffe
	dc.w	$180,$f00		; Rot auf 15 (Maximum)
	dc.w	$0e07,$fffe
	dc.w	$180,$c00		; Rot auf 12
	dc.w	$0f07,$fffe
	dc.w	$180,$900		; Rot auf 9
	dc.w	$1007,$fffe
	dc.w	$180,$600		; Rot auf 6
	dc.w	$1107,$fffe
	dc.w	$180,$300		; Rot auf 3
	dc.w	$1207,$fffe
	dc.w	$180,$000		; Farbe Schwarz

	dc.w	$ffff,$fffe		; Ende der Copperlist


; **************************************************************************
; *			BILD IN 8 FARBEN 320x256									   *
; **************************************************************************

	dcb.b	40*98,0			; leergefegter Raum

Pic:
	incbin	"/Sources/Amiga_320_256_3.raw"
							; hier laden wir das Bild im RAW-Format

	dcb.b	40*8,0			; wie oben

; **************************************************************************
; *				PROTRACKER-MUSIK			   *
; **************************************************************************

mt_data:
	;incbin	"/Sources/mod.purple-shades"
	incbin	"/Sources/mod.yellowcandy"

	end

; **************************************************************************
Dieses Listing ist nichts  anderes  als  ein  Zusammenschlu  von  einigen
Listings,  wie  ihr  gesehen habt. Die Unterschiede sind zwei:

1) Ich habe den Welleneffekt von 45 Wait auf 20 verkrzen  men,  um  ihn
zwischen  die  anderen  Effekte  zu  bekommen. 

2) Ich habe die Palette des Bildes oben verndert, so da es aussieht, als
ob das Bild in die ScrollColors eintreten wrde. Weiters habe ich hier und
da die Farben verndert, um die SUPERCOPPERLIST zu verschnern und ...  zu
verlngern!!

Die wirkliche Neuigkeit ist das Einfgen einer Musikroutine! Zuerst einmal
folgendes: ich habe das Einbinden dieser Routine mit "INCLUDE" dem  wahren
"Einsetzen" (abtippen, reinkopieren) vorgezogen. Dieses Include erlaubt es
mir, auenstehende Listings praktisch einzufgen. Schauen wir nun, wie wir
unsere Wunder noch mit einem bichen Musik auf die Sprnge helfen knnen.
Als erstes ist zu beachten, da das Musikstck in einem speziellen  Format
vorliegen  mu, dem PROTRACKER-Format. Und nicht etwa digitalisierte Musik
etc. Es gibt viele Programme, mit denen man Musik komponieren kann, das am
meisten  verwendete  ist  der  Protracker, kompatibel mit Soundtracker und
Noisetracker. Sie speichern das  Stck  im  MOD-Format  ab,  oft  beginnen
solche  Musikstcke auch mit dem Krzel MOD. Es ist aber nicht gesagt, da
unbedingt immer Protracker verwendet wurde: bei einigen Spielen, vor allem
lteren,   wurden   oft   MED,   OCTAMED,  FUTURE-COMPOSER,  SOUNDMONITOR,
OKTALYZER..., verwendet, aber in diesen Fllen mu eine eigene Routine fr
diese  Formate  das Abspielen bernehmen. Meistens erhlt man zusammen mit
dem Programm auch die REPLAY-Routine, die im Programm eingebaut werden
kann.
Heutzutage verwenden 99%  der  Amiga-Produktionen  Protracker-Format  oder
deren Untersorten, also einem Format, das nach eigenen Regeln und Gesetzen
die "Noten" speichert und komprimiert.
Ich habe diesem Kurs diese Routine mitgegeben, die  Protracker  problemlos
spielt, sie ist kompatibel zu Soundtracker und Noisetracker. Des  weiteren
habe  ich  sie modifiziert, da sie kompatibel zu 68020+ Prozessoren, auch
mit  eingeschalteter   Cache,   ist.   Im   Orginalzustand   hatte   diese
ReplayRoutine  einige  Probleme  bei schnelleren Prozessoren und so verlor
sie manchmal einige Noten... Aber  jetzt  singt  die  "music.s"  auch  auf
A4000ern ohne Schwierigkeiten.
Um sie einzufgen, knnt ihr entweder den "I"-Befehl verwenden,  oder  sie
in  einen  anderen  Buffer  laden  und  dann  ins  Listing  kopieren.  Ich
persnlich ziehe es aber vor, Platz zu sparen, deswegen verwende  ich  die
"Include"-Direktive des ASMONE. Somit wird das Listing assembliert, als ob
die Routine wirklich hndisch eingebaut worden wre, nur  sparen  wir  uns
die  Lnge  dieser  Routine  selbst,  ca  21 kB. Stellt euch z.B. vor, ihr
httet sieben Listings, denen ihr allen diese Routine unterjubeln wollt:

	Listing1.s	12234 bytes
	Listing2.s	23523 bytes
	Listing3.s	29382 bytes
	Listing4.s	78343 bytes
	Listing5.s	10482 bytes
	Listing6.s	14925 bytes
	Listing7.s	29482 bytes

Zusammen sind  sie  ca.  200k  gro,  nachdem  wir  aber  jeden  21kB  der
Replay-Routine  dazugezhlt haben, wrden sie insgesamt 300kB verbrauchen!
Aber wenn ich nur die Zeile

	include "music.s"

schreibe,  dann  ist  die Vergrerung des Listings nur ein paar Byte, das
Resultat aber das gleiche. Der einzige Schwachpunkt ist, da man sich, wie
beim  INCBIN,  in  der  selben  Directory befinden mu, wo sich auch diese
Routine befindet. Ansonsten mu man den vollstndigen Pfad schreiben:

	include "df0:sorgenti2/music.s"

Einmal  eingefgt,  sei  es  nun  mit  dem  Include  oder mittels direktem
Einfgen von Hand, braucht man sie nur  mehr  zum  Funktionieren  bringen.
GANZ  EINFACH!  Nur  mt_init  vor  dem Mouse-Loop aufrufen, damit wird sie
initialisiert, dann "mt_music" bei JEDEM FRAME ausfhren, und dann  mt_end
am  Ende  vor  dem Aussteigen aufrufen. Damit wird die Routine beendet und
sie gibt die Audio-Kanle wieder frei.

	bsr.w	mt_init			; Inizialisiert Musik-Routine

Mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	bne.s	Mouse			; Wenn nicht, geh nicht weiter

	bsr.w	MeineGrafikRoutine
	bsr.w	mt_music		; Spielt die Musik
 
	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	bsr.s	mt_end			; Beendet die Musikroutine
 
Das Musikstck mu natrlich geladen werden, einfach mit dem INCBIN unter
dem Label "mt_data":

mt_data:
	incbin	"mod.purple-shades"

Die im Kurs enthaltene Musik ist von HI-LITE der VISION FACTORY, ein
Stck, das schon  einige Jahre auf dem Buckel hat, ich habe sie gewhlt,
weil sie nur 13 kB lang ist. Wenn ihr etwas Eigenes spielen lassen wollt,
dann einfach mit dem Incbin reinholen:

mt_data:
	incbin	"df1:modules/mod.MyMusic"	; zum Beispiel!

