
; Listing2d.s

Anfang:
	lea	Nilpferd,a0			; gib in a0 die Adresse von Nilpferd
	move.l	(a0),d0			; gib in d0 den .L-Wert, den wir
							; an der Adresse in a0 finden, also
							; das erste Longword, das bei Nilpferd steht
	move.l	Nilpferd,d1		; in d1 geben wir den Inhalt des ersten
							; longword (4 bytes=4 Adressen) von Nilpferd
	move.l	a0,d2			; in d2 geben wir die in a0 enthaltene Zahl,
							; also die Adresse von Nilpferd, das zuerst
							; mit dem lea Nilpferd,a0 geladen wurde
	move.l	#Nilpferd,d3	; in d3 geben wir die Adresse von Nilpferd
	rts

Nilpferd:
	dc.l	$123

	end


Bei  diesem  Beispiel  erkennt  man  den  Unterschied  zwischen  direkter,
indirekter und absoluter Adressierung: einmal  assembliert,  macht  ein  D
Anfang,  um  die  Ausgangssituation anzusehen, und nach einem J werdet ihr
den Unterschied in  den  Registern  bemerken:  in  d0  und  d1  wird  $123
enthalten sein, also der Inhalt
von NILPFERD:

	lea	Nilpferd,a0			; gib in a0 die Adresse von Nilpferd
	move.l	(a0),d0			; gib in d0 den .L-Wert, den wir
							; an der Adresse in a0 finden, also
							; das erste longword, das nach Nilpferd steht
							; (Mit dem move.l kopiert man das Byte an
							; der Adresse in a0 selbst und die drei
							; folgenden, denn ein Long ist ja 4 Byte lang).


Das ist identisch mit:

	move.l	Nilpferd,d1		; in d1 geben wir den .L-Inhalt von Nilpferd

In beiden Fllen wird der .L-Inhalt (d.h. 4 Bytes ab der angegebenen Adresse)
von NILPFERD ins Datenregister kopiert.

In d2, d3 und a0 hingegen werdet ihr die Adresse von NILPFERD bemerken, denn:


	lea	Nilpferd,a0			; in a0 geben wir die Adresse von Nilpferd
	move.l	a0,d2			; in d2 geben wir den Wert, der in a0 enthalten
							; ist, also der Adresse von Nilpferd, die mit dem
							; lea geladen wurde

ist identisch mit:

	move.l	#Nilpferd,d3	; in d3 geben wir die Adresse von Nilpferd
	


Diese Differenzen in der Adressierung men klar  sein,  denn  wenn  diese
einmal  sitzen, dann reicht es, sich an die Befehle und deren Bedeutung zu
erinnern, denn sie verwenden alle die gleichen Adressierungsarten.

Beispiele von bisher gelernten Adressierungen:

Direkt:
	move.l	a0,a1

Indirekt:
	clr.l	 (a0)
	move.l	(a3),(a4)

Absolut:
	move.l	#Label,d0
	move.l	#10,d4

