
ASSEMBLERKURS - LEKTION 28: Serial Communication (Version 1: Stand: 06/2025)
(unvollendet)

Autor: Gran Strack


*******************************************************************************
* 1. die beteiligten Register												  *	
*******************************************************************************

INTENA  09A W P Interrupt enable bits (clear or set bits)	Bit: RBF, TBE
INTENAR 01C R P Interrupt enable bits (read)				Bit: RBF, TBE

SERPER	032 W P Serial port period and control
SERDAT	030 W P Serial port data and stop bits write
SERDATR 018 R P Serial port data and status read

$dff010	ADKCONR	Audio, disk control register read
$dff09e	ADKCON	Audio, disk and UART control

;------------------------------------------------------------------------------
$dff01c	INTENAR	Interrupt enable bits read
$dff01e	INTREQR	Interrupt request bits read
$dff09a	INTENA	Interrupt enable bits (clear or set bits)
$dff09c	INTREQ	Interrupt request bits (clear or set bits)

Bit	Function	Description
15	SET/CLR	0=clear, 1=set bits that are set to 1 below
14	INTEN	Enable interrupts below (master toggle)
13	EXTER	Level 6 External interrupt
12	DSKSYN	Level 5 Disk Sync value found
11	RBF		Level 5 Receive Buffer Full (serial port)
10	AUD3	Level 4 Audio Interrupt channel 3
09	AUD2	Level 4 Audio Interrupt channel 2
08	AUD1	Level 4 Audio Interrupt channel 1
07	AUD0	Level 4 Audio Interrupt channel 0
06	BLIT	Level 3 Blitter Interrupt
05	VERTB	Level 3 Vertical Blank Interrupt
04	COPER	Level 3 Copper Interrupt
03	PORTS	Level 2 CIA Interrupt (I/O ports and timers)
02	SOFT	Level 1 Software Interrupt
01	DSKBLK	Level 1 Disk Block Finished Interrupt
00	TBE		Level 1 Transmit Buffer Empty Interrupt (serial port)
;------------------------------------------------------------------------------

$dff032	SERPER	Serial port period and control
 This register contains the control bit LONG reffered to
          above, and a 15 bit number defining the serial port
          Baud rate. If this number is N,then the baud rate is
          1 bit every (N+1)*.2794 microseconds.


   +-------+----------+---------------------------------------------------+
   | BIT#  | FUNCTION | DESCRIPTION                                       |
   +-------+----------+---------------------------------------------------+
   | 15    | LONG     | Defines serial receive as 9 bit word.             |
   | 14-00 | PERIOD   | Defines baud rate [=1/((N+1)*.2794 microseconds)] |
   +-------+----------+---------------------------------------------------+


          If you know the Baud Rate, you may calculate period
          for it with following formula:


                             3579546
                 PERIOD = ------------- - 1
                            BAUD RATE


          Periods for some most common baud rates are:

		           +-----------+--------+
                   | Baud Rate | Period |
                   +-----------+--------+
                   |    300    | 11931  |
                   |    600    |  5965  |
                   |   1200    |  2982  |
                   |   2400    |  1490  |
                   |   4800    |   745  |
                   |   9600    |   372  |
                   |  14400    |   248  |
                   |  28800    |   123  |
                   +-----------+--------+

;------------------------------------------------------------------------------

$dff030	SERDAT	Serial port data and stop bits write


SERDAT
         SERDAT address writes data to a transmit data
         buffer.  Data from this buffer is moved into a
         serial shift register for output transmission
         whenever it is empty. This sets the interrupt request
         TBE (transmit buffer empty). A stop bit must be
         provided as part of the data word. The length of
         the data word is set by the position of the stop bit.
		 
  BIT#  15 14 13 12 11 10 09 08   07 06 05 04 03 02 01 00
  USE    0  0  0  0  0  0  S D8   D7 D6 D5 D4 D3 D2 D1 D0


         Note :  S = Stop bit = 1, D = Data bits
;------------------------------------------------------------------------------

$dff018	SERDATR	Serial port data and status read

SERDATR
         This address reads data from a recive data buffer.
         Data in this buffer is loaded from a receiving shift
         register whenever it is full. Several interrupt request
         bits are also read at this address, along with the data as
         shown below.


         +------+----------+--------------------------------------------+
         | BIT# | FUNCTION | DESCRIPTION                                |
         +------+----------+--------------------------------------------+
         | 15   | OVRUN    | Serial port receiver overrun               |
         | 14   | RBF      | Serial port receive buffer full (mirror)   |
         | 13   | TBE      | Serial port transmit buffer empty (mirror) |
         | 12   | TSRE     | Serial port transmit shift reg. empty      |
         | 11   | RXD      | RXD pin receives UART serial data for      |
         |      |          | direct bit test by the micro.              |
         | 10   | X        | Not used.                                  |
         | 09   | STP      | Stop bit                                   |
         | 08   | STP-DB8  | Stop bit if LONG, data bit if not.         |
         | 07   | DB7      | Data bit.                                  |
         | 06   | DB6      | Data bit.                                  |
         | 05   | DB5      | Data bit.                                  |
         | 04   | DB4      | Data bit.                                  |
         | 03   | DB3      | Data bit.                                  |
         | 02   | DB2      | Data bit.                                  |
         | 01   | DB1      | Data bit.                                  |
         | 00   | DB0      | Data bit.                                  |
         +------+----------+--------------------------------------------+
;------------------------------------------------------------------------------

ADKCON
         +-------+-------------+-------------------------------------------+
         | BITS  | USE         | DESCRIPTION                               |
         +-------+-------------+-------------------------------------------+
         | 15    | SET/CLEAR   | Set/clear control bit.determines if bits  |
         |       |             | written with a 1 get set or cleared.bits  |
         |       |             | written with a zero are always unchanged. |
         |       |             |                                           |
         |       |             | +------+---------------+                  |
         | 14-13 | PRECOMP 1-0 | | CODE | PRECOMP VALUE |                  |
         |       |             | +------+---------------+                  |
         |       |             | | 00   | none          |                  |
         |       |             | | 01   | 140 ns        |                  |
         |       |             | | 10   | 280 ns        |                  |
         |       |             | | 11   | 560 ns        |                  |
         |       |             | +------+---------------+                  |
         |       |             |                                           |
         | 12    | MFMPREC     | (1 = MFM precomp / 0 = GCR precomp)       |
         | 11    | UARTBRK     | Forces a UART break (clears TXD) if true  |
         | 10    | WORDSYNC    | Enables disk read synchronizing on a word |
         |       |             | equal to DISK SYNC CODE, Located in       |
         |       |             | address DSKSYNC (7E).                    |
         | 09    | MSBSYNC     | Enables disk read synchrinizing on the    |
         |       |             | MSB (most signif bit) appl type GCR       |
         | 08    | FAST        | Disk data clock rate control 1=fast(2us)  |
         |       |             | 0=slow(4us)                               |
         |       |             | (Fast for MFM or 2us,slow for 4us GCR)    |
         | 07    | USE3PN      | Use audio channel 3 to modulate nothing   |
         | 06    | USE2P3      | Use audio channel 2 to modulate period    |
         |       |             | of channel 3                              |
         | 05    | USE1P2      | Use audio channel 1 to modulate period    |
         |       |             | of channel 2                              |
         | 04    | USE0P1      | Use audio channel 0 to modulate period    |
         |       |             | of channel 1                              |
         | 03    | USE3VN      | Use audio channel 3 to modulate nothing   |
         |       |             |                                           |
         | 02    | USE2V3      | Use audio channel 2 to modulate volume    |
         |       |             | of channel 3                              |
         | 01    | USE1V2      | Use audio channel 1 to modulate volume    |
         |       |             | of channel 2                              |
         | 00    | USE0V1      | Use audio channel 0 to modulate volume    |
         |       |             | of channel 1                              |
         +-------+-------------+-------------------------------------------+


   Note: If both period and volume are modulated on the same channel,
         the period and volume will be alternated. First AUDxDAT word
         is used for V6-V0 of AUDxVOL. Second AUDxDAT word is used for
         P15-P0 of AUDxPER. This alternating sequence is repeated.

*******************************************************************************
* 2. Serial I/0 Interface (HRM)												  *	
*******************************************************************************

A 25-pin connector on the back panel of the computer serves as the general
purpose serial interface. This connector can drive a wide range of different
peripherals, including an external modem or a serial printer.

For pin connections, see Appendix E.

INTRODUCTION TO SERIAL CIRCUITRY

The Paula custom chip contains a Universal Asynchronous Receiver Transmitter,
or UART. This UART is programmable for any rate from 110 to over 1,000,000 bits
per second. It can receive or send data with a programmable length of eight or
nine bits.
The UART implementation provides a high degree of software control. The UART is
capable of detecting overrun errors, which occur when some other system sends
in data faster than you remove it from the data-receive register. There are 
also status bits and interrupts for the conditions of receive buffer full and 
transmit buffer empty. An additional status bit is provided that indicates 
''all bits have been shifted out''. All of these topics are discussed below.

SETTING THE BAUD RATE

The rate of transmission (the baud rate) is controlled by the contents of the
register named SERPER. Bits 14-0 of SERPER are the baud-rate divider bits. 
All timing is done on the basis of a "color clock," which is 279.36ns long on
NTSC machines and 281.94ns on PAL machines. If the SERPER divisor is set to the
number N, then N+l color clocks occur between samples of the state of the input
pin (for receive) or between transmissions of output bits (for transmit). Thus
SERPER=(3,579,545/baud)-1. On a PAL machine, SERPER=(3,546,895/baud)-1. For
example, the proper SERPER value for 9600 baud on an NTSC machine is 
(3,579,545f]600)-1=371.

With a cable of a reasonable length, the maximum reliable rate is on the order
of 150,000-250,000 bits per second. Maximum rates will vary between machines.
At these high rate it is not possible to handle the overhead of interrupts. The
receiving end will need to be in a tight read loop.
Through the use of low speed control information and high-speed bursts, a very 
inexpensive communication network can be built.

SETTING THE RECEIVE MODE

The number of bits that are to be received before the system tells you that the
receive register is full may be defined either as eight or nine (this allows
for 8 bit transmission with parity). In either case, the receive circuitry 
expects to see one start bit, eight or nine data bits, and at least one stop 
bit.

Receive mode is set by bit 15 of the write-only SERPER register. Bit 15 is a 1
if you chose nine data bits for the receive-register full signal, and a 0 if
you chose eight data bits. The normal state of this bit for most receive 
applications is a 0.

CONTENTS OF THE RECEIVE DATA REGISTER

The serial input data-receive register is 16 bits wide. It contains the 8 or 9
bit input data and status bits.
The data is received, one bit at a time, into an internal serial-to-parallel 
shift register. When the proper number of bit times have elapsed, the contents
of this register are transferred to the serial data read register (SERDATR) 
shown in Table 8-10, and you are signaled that there is data ready for you.

Immediately after the transfer of data takes place, the receive shift register
again becomes ready to accept new data. After receiving the receiver-full 
interrupt, you will have up to one full character-receive time (8 to 10 bit 
times) to accept the data and clear the interrupt. If the interrupt is not
cleared in time, the OVERRUN bit is set.

Table 8-9 shows the definitions of the various bit positions within SERDATR.

BitNumber	Name		Function
15			OVRUN		OVERRUN
				(Mirror-also appears in the interrupt request register.)
				Indicates that another byte of data was received before the
				previous byte was picked up by the processor. To prevent this
				condition, it is necessary to reset INTF _RBF (bit 11,
				receive-buffer-full) in INTREQ.

14			RBF			READ BUFFER FULL
				(Mirror-also appears in the interrupt request register.)
				When this bit is 1, there is data ready to be picked
				up by the processor. After reading the contents of this data
				register, you must reset the INTF RBF bit in INTREQ to prevent
				an overrun.

13			TBE			TRANSMIT BUFFER EMPTY
				(Not a mirror-interrupt occurs when the buffer
				becomes empty.) When bit 14 is a 1, the data in the output
				data register (SERDAT) has been transferred to the serial
				output shift register, so SERDAT is ready to accept another
				output word. This is also true when the buffer is empty.
				This bit is normally used for full-duplex operation.

12			TSRE		TRANSMIT SHIFf REGISTER EMPTY
				When this bit is a 1, the output shift register has completed
				its task, all data has been transmitted, and the register is
				now idle. If you stop writing data into the output register
				(SERDAT), then this bit will become a 1 after both the word
				currently in the shift register and the word placed
				into SERDA T have been transmitted.
				This bit is normally used for half-duplex operation.

11			RXD			Direct read of RXD pin on Paula chip.
10					Not used at this time.
9			STP		Stop bit if 9 data bits are specified for receive.
8			STP		Stop bit if 8 data bits are specified for receive.
			OR
					DB8 9th data bit if 9 bits are specified for receive.
7-0			DB7-DBO Low 8 data bits of received data. Data is TRUE (data you
					read is the same polarity as the data expected).


ADKCON
15		SET/CLR		Allows setting or clearing individual bits.
					If bit 15 is a 1 specified bits arc set.
					If bit 15 is a 0 specified bits are cleared.
11		UARTBRK		Force the transmit pin to zero.


HOW OUTPUT DATA IS TRANSMITTED

You send data out on the transmit lines by writing into the serial data output
register (SERDAT). This register is write-only.
Data will be sent out at the same rate as you have established for the read. 
Immediately after you write the data into this register, the system will begin
the transmission at the baud rate you selected.

At the start of the operation, this data is transferred from SERDAT into an
internal serial shift register. When the transfer to the serial shift register
has been completed, SERDAT can accept new data; the TBE interrupt signals this
fact.

*******************************************************************************

