
ASSEMBLERKURS - LEKTION 22 Teil B: make (Version 1: Stand: 09/2024)

Autor: Gran Strack

Noch ein paar Ergnzungen zum allgemeinen Einsatz von make-Dateien im 
Zusammenhang mit WinUAE:

*******************************************************************************
*		GNU-Make - Allgemein										    	  *
*******************************************************************************

Make wird zum 'Bauen' (Build) von vasm und vlink bentigt und zum bersetzen
eigener Projekte im Build-Prozess.

Aber Makefiles sind nur ein Hilfsmittel fr groe Projekte. Es ist vllig dem
Entwickler berlassen wann, oder ob berhaupt, diese zum Einsatz kommen. Bei
kleinen Testprogrammen, mit nur einem einzigen Quelltext, reicht es vllig aus
vasm direkt aufzurufen:
  vasmm68k_mot -Fhunkexe -o test test.asm


Kommandozeile cmd / (Batch-File) oder Makefile? - Vergleich
===============================================================================
cmd:
vasmm68k_mot -Fhunkexe -o test -nosym test.s

Makefile 1:
test: test.s
	vasmm68k_mot -Fhunkexe -o test -nosym test.s

;------------------------------------------------------------------------------	
cmd:
vasmm68k_mot -Fhunk -nocase -o startup.o  startup.s 
vasmm68k_mot -Fhunk -nocase -o init.o  init.s
vlink -bamigahunk -o test init.o  startup.o 
;------------------------------------------------------------------------------
Makefile 2a:
test: startup.o init.o
	vlink -bamigahunk -o test init.o  startup.o 
startup.o: startup.s 
	vasmm68k_mot -Fhunk -nocase -o	startup.o startup.s 
init.o: init.s
	vasmm68k_mot -Fhunk -nocase -o	init.o init.s
;------------------------------------------------------------------------------
Makefile 2b:
AS = vasmm68k_mot				; der verwendete Assembler Motorola 68k
ASOPT = -Fhunk -nocase -quiet	; die Assembler Optionen

LD = vlink						; der Linker
LDOPT = -bamigahunk				; die Linker Optionen

OBJS = startup.o init.o			; die Objektdateien

all: test						; die Ergebnisdatei	(Executable)

test: $(OBJS)
	$(LD) $(LDOPT) -o $@ $(OBJS) ; vlink -bamigahunk -o test startup.o init.o 

%.o: %.asm
	$(AS) $(ASOPT) -o $@ $<	; vasmm68k_mot -Fhunk -nocase -o startup.o startup.asm
							; vasmm68k_mot -Fhunk -nocase -o init.o init.asm

Selbst bei aufwndigeren Projekten knnte man genau so gut eine Batch-Datei
nutzen, die vasm fr jeden Quelltext aufruft. Der Vorteil des Makefiles ist da
es wei welche Quelltexte sich verndert haben, und nur diese neu bersetzt.
Ein Batchfile wrde immer alles neu bauen, was bei der Leistung heutiger 
Rechner aber meistens auch egal ist.

*******************************************************************************
*		GNU-Make - Installation										    	  *
*******************************************************************************

Wir machen hier weiter, falls GNU-make auf dem Windows Rechner noch nicht 
installiert ist.

H:\>make
Der Befehl "make" ist entweder falsch geschrieben oder konnte nicht
gefunden werden.

Falls nicht vorhanden, dann schnell nachholen. z.B.

> GNU Make:
> make-3.81.exe     https://sourceforge.net/projects/gnuwin32/

Nach der Installation von GNU Make, mssen wir den Pfad der Ausfhrungsdatei
make.exe noch in den Umgebungsvariablen hinzufgen, damit der Aufruf von make
auch aus jedem beliebigen Verzeichnis ausgefhrt wird.

So gehts. (bzw. so siehts bei mir aus)

Nach der Installation liegt make.exe unter: C:\Program Files (x86)\GnuWin32\bin

- rechte Maustaste auf das Windows Logo (Start) links unten
- dann auf System klicken
- rechts auf "Erweiterte Systemeinstellungen"
- es ffnet sich ein Fenster mit den Systemeigenschaften
  unten steht "Umgebungsvariablen"
- oben unter Benutzervariablen auf Path klicken und Button "Neu" klicken
- nun den Pfad C:\Program Files (x86)\GnuWin32\bin als neuen Eintrag hinkopieren
  (Ihr msst natrlich den Pfad eintragen wo GnuWin32 bei Euch liegt)

Und nun testen ob make vorhanden ist:
G:\Amiga\vasm\test02>make
make: *** Keine Targets angegeben und keine make-Steuerdatei gefunden. 
 Schluss.
OK, make ist vorhanden. 


*******************************************************************************
*		Makefile - grundstzlicher Aufbau							    	  *
*******************************************************************************

Ein Makefile hat eigentlich nur drei Arten von Zeilen:

Variablendefinitionen
===============================================================================
z.B.: CC = gcc

Variablen kann man berall als $(VARIABLENNAME) benutzen, und der
zugewiesene Inhalt wird an dieser Stelle eingesetzt.

Regeln
===============================================================================
Diese haben immer die Form: <Ziel> : <Liste von Abhngigkeiten>

Dabei hat man im Normalfall auf beiden Seiten immer Dateinamen. Die rechte
Seite vom Doppelpunkt listet die Dateien auf die eine Aktivierung der Regel
bewirken, sobald mindestens eine von ihnen neuer als die Zieldatei auf der
linken Seite ist. Existiert die Zieldatei nicht, so gilt sie auch als
lter. Existiert eine der Dateien auf der rechten Seite nicht, so wird nach
einer Regel gesucht wie man diese erzeugt, und dann die Anweisungen dieser
Regel *vorher* ausgefhrt. Das Ganze kann sich rekursiv fortsetzen.
Zugehrig zu einer Regel ist alles innerhalb einer Zeile. Wird diese zu lang
kann man, wie beim C-Prprozessor, mehere Makefile-Zeilen mit '\' am Ende
verknpfen.

In der Shell auszufhrende Anweisungen.
===============================================================================
Das ist alles was unter einer Regel steht. Ganz wichtig: Anweisungen beginnen
*immer* mit einem Tabulator-Zeichen (ASCII-Code 9). Es drfen da aber beliebig
viele Zeilen mit Anweisungen zu einer Regel stehen. Beispiel:

<tab>$(CC) -c mysource.c

Beim Aufruf von "make" knnen sie sagen welche Regel sie bauen wollen. Z.B.
  make tools/bmptoraw
Dann macht er auch nur das. Wenn sie nichts sagen, dann versucht "make" die
erste Regel auszufhren, die er findet. Als Standard hat sich durchgesetzt 
diese "all" zu nennen. Mu aber nicht sein.

Desweiteren kann man auch Variablen bergeben. Z.B.:
  make CC=vbccm68k DEBUG=1

Das $@ ist eines von vielen internen Spezial-Variablen, die meist fr einen
bestimmten Teil einer Regel stehen. Hier fr den Zieldateinamen, auf der
linken Seite der Regel. Weiteres Beispiel: $< steht fr den ersten
Dateinamen von der rechten Seite der Regel. Oder $+ steht fr alle 
Dateinamen auf der rechten Seite.

Damit kann man allgemeingltige Kommandos schreiben wie:
<tab>$(CC) -o $@ $<

Das Makefile von Solid Gold ist brigens extrem gut fr Anfnger geeignet, da
es wirklich nur die elementarsten Dinge enthlt. Man kann vieles eleganter und
krzer machen. 

https://aminet.net/package/game/jump/SolidGold_Source
http://server.owl.de/%7Efrank/TrapRunner1_2.lha


Zusammenfassung
===============================================================================
$@ left side of : (is a symbol for the output file.)
$< (is the first item of the list right side of :)	is a symbol for the source
   file.
or
$^ right side of : (is a symbol for the source file.)

%.o is like a wildcard, meaning any .o file.
%.s is like a wildcard, meaning any .s file.

Wildcard-Pattern
%.o:%.c
	$(CC) -c $(CFLAGS) $< -o $*.o

Suffix-Regel: (Kurzschreibweise von %.o:%.c)
.c.o:
	$(CC) -c $(CFLAGS) $< -o $*.o


Beispiele:
===============================================================================

AS = vasmm68k_mot				; der verwendete Assembler Motorola 68k
ASOPT = -Fhunk -nocase -quiet	; die Assembler Optionen

LD = vlink						; der Linker
LDOPT = -bamigahunk				; die Linker Optionen

OBJS = startup.o init.o			; die Objektdateien

all: test						; die Ergebnisdatei	(Executable)

test: $(OBJS)
	$(LD) $(LDOPT) -o $@ $(OBJS) ; vlink -bamigahunk -o test startup.o init.o 

%.o: %.asm
	$(AS) $(ASOPT) -o $@ $<	; vasmm68k_mot -Fhunk -nocase -o startup.o startup.asm
							; vasmm68k_mot -Fhunk -nocase -o init.o init.asm

;------------------------------------------------------------------------------
oder:

ASM_FLAGS = -Fhunk -nocase -quiet	; die Assembler Optionen
ASM = vasmm68k_mot					; der verwendete Assembler Motorolla 68k
.SUFFIXES : .o .s
PROGRAMS = test

all: $(PROGRAMS)					; die Ergebnisdatei	(hier nur eine)

%.o: %.s
	$(ASM) $(ASM_FLAGS) -o $@ $<

clean:
	rm -f $(PROGRAMS) *.o

test: startup.o init.o
	vlink -bamigahunk -o $@ -s $< $<	; -s

