﻿
ASSEMBLERKURS - LEKTION 22: vasm, vlink, vbcc (Version 1: Stand: 09/2024)

Autor: Göran Strack

*******************************************************************************
*		vasm, vlink	- Vorstellung und Überblick								  *
*******************************************************************************

Im Kurs wurde bisher immer der Assembler AsmOne (Trash'm One) verwendet, der
eine Weiterentwicklung des Programms K-Seka ist. Es gibt noch andere Assembler
u.a. Devpac, ASM-Pro, OMA usw. Dabei war der populärste im Hobbybereich der
K-Seka, der später durch AsmOne abgelöst wurde. Im eher professionellen Bereich
wurde Devpac 2 bzw. 3 bei den Entwicklern der damaligen Zeit verwendet.

Grob können die Assembler in Entwicklungsumgebungen (IDE) und in 
Kommandozeilenbassierte eingeteilt werden.

In dieser Lektion soll der Assembler "vasm" vorgestellt werden. 
Und die ersten Frage, die sich stellen sind: 
- Was ist "vasm" eingentlich?
- Woher bekomme ich "vasm"?
- Welches "vasm" brauche ich?

Die Kurzantworten sind:

1. "vasm" ist ein portabler Assembler für unterschiedlichste CPUs, Syntax-
   Varianten und Output-Formate. Es kann heruntergeladen werden von: 
   http://sun.hasenbraten.de/vasm/

2. Je nach Bedarf lädt man das Quelltext-Archiv zum selbst übersetzen, oder das
   fertige Binary herunter. Binaries gibt es für AmigaOS3, OS4, MorphOS, TOS,
   MiNT und Windows64.

3. Wir wollen hier für das Amiga-System mit einer Motorola CPU 68000+ Programme
   entwickeln und wählen daher das fertige Binarie: "vasmm68k_mot" für m68k 
   Assembler mit Motorola Syntax. 

Wenn die ersten Fragen geklärt sind, stellen sich vielleicht weitere:
- Was sind die Hauptvorteile von "vasm" gegenüber anderen Assemblern?
- sind ggf. Nachtteile zu anderen Assemblern zu nennen?

4. Vorteile:
-  Der Assembler ist frei und völlig portabel (ANSI-C). Es gibt wirklich 
   keinerlei Abhängigkeiten, außer einem funktionierenden C Compiler. Damit 
   läuft vasm theoretisch auf jedem existierendem Computer (ab ca. 1MB 
   Speicher). Crossassemblierung ist ein logischer Nebeneffekt.

- Der Funktionsumfang ist schon größer als bei den meisten anderen Assemblern.
  Insbesondere verglichen mit den klassischen. Kein anderer 68k Assembler hat 
  so viele Optimierungsmöglichkeiten, Wahl zwischen verschiedenen Syntax-
  Modulen, und Output-Modulen für alles mögliche (von Amiga Hunk-Format, über
  Atari-TOS, X68000, a.out, ELF, bis zu rohen Binärdateien und S-Records).

- Recht gute Kompatibilität zu "Standard" Assemblern wie Devpac, und somit zum
  originalen Motorola-Standard, bei Benutzung des "mot" Syntax-Moduls. Man muß
  keine ungewohnte Syntax schreiben, wie z.B. beim GNU-Assembler.

- Aktiv gepflegt und supportet.

  weitere Vorteile sind:
- vasm nimmt bei der Erstellung des Executables (Programms) Optimierungen vor
  (kann durch Optionen eingestellt werden)

- vasm ist geeignet für große Programmprojekte, wo andere Assembler an ihre
  Grenzen kommen

- dynamische Speicherverwaltung. Bei AsmOne muss zu Beginn die Größe des
  "Workspace" und die Art des RAMs (Chip-, Fast-RAM) definiert werden.	

- geeignet für großen Bereich von Prozessoren

5. Nachteile:
  Der einzige Nachteil von vasm (aus meiner Sicht) ist sein, für Amiga-
  Verhältnisse, hoher Ressourcenbedarf. Er ist schon deutlich langsamer als
  klassische Amiga-Assembler und braucht eine Ecke mehr Speicher. Darum ist der
  Fokus sicherlich auf Cross-Assemblierung, wo das keine Rolle spielt. Unter
  AmigaOS denke ich, daß man mindestens einen 68030 mit 4MB haben sollte, um
  ihn sinnvoll nutzen zu können.

Neben den allgemeinen Nachteilen gibt es für den Neueinsteiger einige 
Anfangshürden zu nehmen. Vor allem dann, wenn man es nicht gewohnt ist über
Kommandozeilenbefehle bzw. Batchdateien ausführbare Programme (Executables) zu
erstellen, weil man es eher gewohnt ist über eine Entwicklungsumgebung (IDE) zu
entwickeln die einen vom eigentlichen Übersetzungsvorgang weitestgehend 
abschirmt. Das Gleiche gilt auch für Entwicklungsarbeiten über makefiles und
C-Compiler.

  Deswegen kommen folgende Anfangshürden bzw. "Schwierigkeiten" hinzu:
- vasm und vlink haben viele Optionen
- ausführbare Datei erstellen über Kommandozeile oder Batch-Datei
- ausführbare Datei erstellen über makefile
  d.h. Wissen über Bedeutung und Funktionsweise der Optionen bzw.
  Grundlagenwissen über DOS bzw. makefiles muss vorhanden sein

- wenn sich der Programmname ändert (wie in diesem Kurs), dann ist vasm nicht
  so flexibel, weil jedesmal der Programmname im makefile bzw. in der 
  Batchdatei teilweise an mehreren Stellen geändert werden muss

Auch ist die Ausführung der erstellten Programme etwas anders:
- bei AsmOne gewöhnlich über >j aus der IDE nach der Assemblierung
- bei vasm direkt über die Shell über >progname
- alternativ kann das ausführbare Programm auch über die Kommandozeile 
  gestartet werden: (siehe Lektion: command line) bzw. bei WinUAE direkt 
  über Floppy Drives (Programm.exe wie eine Diskette einlegen)
  
Es gibt eine gute Dokumentation über vasm, vlink und vbcc. Die von hier
heruntergeladen werden kann: (vbcc wird später erklärt.)
vasm	- http://sun.hasenbraten.de/vasm/release/vasm.pdf
vlink	- http://sun.hasenbraten.de/vlink/ 
vbcc	- http://phoenix.owl.de/vbcc/docs/vbcc.pdf

Jedoch, ohne einen ersten praktischen Ablauf, wirkt die Anleitung für den
Einsteiger erschlagend und sehr kryptisch. Die Dokumentation wird erst zu einer
Hilfe, wenn sich die ersten Erfolge bei der Programmerstellung eingestellt
haben. Diese Lektion soll daher so eine Art Starthilfe sein, für diejenigen die
Probleme im Einstieg haben, obwohl alles dokumentiert ist.


vasm - Überblick über die wichtigsten Optionen
===============================================================================

Bevor wir mit den Praxisbeispielen starten noch ein kurzer Überblick der
wichtigsten Optionen: Ansonsten in der Dokumentation nachschlagen. 

-F<outputformat> um das Dateiformat zu wählen. Bei AmigaOS/68k wählt man
entweder "hunkexe" wenn man direkt ein ausführbares Executable erzeugen
will, oder "hunk", wenn man ein Object File erzeugen will, welches
anschließend dem Linker übergeben wird.

also:
-Fhunkexe	; erstellt Executable (ausführbare Datei)
-Fhunk		; erstellt Objektdatei (muss noch mit vlink "verlinkt" werden)

-o <name> (hier im Gegensatz zu -F ein Leerzeichen hinter der Option) um den
Namen der Zieldatei zu setzen. Default ist "a.out".

-o			; Output
-nocase		; nicht auf Groß- und Kleinschreibung achten
-nosym		; Symbole entfernen

Weitere Optionen kann man bei Bedarf nachschlagen. z.B. wenn man für größere
CPUs übersetzen will - 68020 wäre "-m68020" (alternativ eine Direktive im
Source), oder wenn man sicherstellen will, dass das Executable nicht nur
unter OS2/3 sondern auch unter Kickstart 1.x läuft: -kick1hunks (nur
sinnvoll zusammen mit -Fhunkexe).

vlink - Überblick über die wichtigsten Optionen
===============================================================================

-s			; Symbole entfernen


*******************************************************************************
*		vasm, vlink - im Test (Windows)									      *
*******************************************************************************

Für die schnelle Methode wird empfohlen die folgende zip-Datei herunterzu-
laden.

> vbcc_win_x64.zip from http://www.compilers.de/vbcc.html
> (Download multi-target Windows (x64) binaries of vbcc/vasm/vlink
> (29/04/2022).)

Das Verzeichnis enthält alles was Sie brauchen. Alle vasm-Varianten und vlink
sind als Windows Executables enthalten. Aus den vielen Dateien interessieren
uns aber nur zwei: vasmm68k_mot.exe und vlink.exe

Wie wir vasm und vlink selbst übersetzen wird später erklärt. 


1. Test von vasm
===============================================================================

Die Dateien test.s und vasmm68k_mot.exe befinden sich in einem Verzeichnis
test01. Wir wechseln über die Eingabeaufforderung in das Verzeichnis.
z.B. unten neben Start "cmd" eingeben für die Eingabeaufforderung und in das
test-Verzeichnis wechseln. z.B.

C:\Users\Administrator>G:		; entsprechendes Laufwerk
G: cd G:\Amiga\vasm\test01		; euren Pfad natürlich...
G:\Amiga\vasm\test01>dir		; sind wir richtig? 
G:\Amiga\vasm\test01>vasmm68k_mot -Fhunkexe -o test -nosym test.s

Die vasm-exe-Datei wird ausgeführt und es wird eine ausführbare Datei "test"
erstellt, welche in WinUAE über die shell gestartet werden kann.

in WinUAE/shell:
>test 

Dieses Verfahren gilt wenn eine Exe-Datei erstellt wird. Es können mehrere
Assemblerdateien vorhanden sein, die dabei über include eingebunden werden.

(Alternative Methode über die Power-Shell)
- in das Verzeichnis test01 wechseln
- dort Shift-Taste drücken und rechte Maustaste
- im Kontextmeü PowerShell-Fenster hier öffnen 
PS C:....>dir
test01> .\vasmm68k_mot -Fhunkexe -o test1 -nosym test.s
vasm 1.9a (c) in 2002-2022 Volker Barthelmann
vasm M68k/CPU32/ColdFire cpu backend 2.5a (c) 2002-2022 Frank Wille
vasm motorola syntax module 3.15d (c) 2002-2022 Frank Wille
vasm hunk format output module 2.13a (c) 2002-2021 Frank Wille

(You can run .exe files in PowerShell using three different methods:
Typing ".\" followed by the name of the file.)

Alternativ kann dieser Weg auch über eine Batch-Datei erfolgen. Dabei werden
die entsprechende Anweisungszeilen mit Optionen und Programmnamen in eine 
Batch-Datei geschrieben und z.B. über den Doppelklick gestartet.
(siehe Lektion 20: batchfile)

Die dritte Möglichkeit ist die Programmerstellung über einen Makefile.
(siehe Lektion 22: makefile)


2. Test vasm und vlink
===============================================================================

Sobald eine ausführbare Datei (executable) aus mehreren Objektdateien mit
Referenzierung erstellt werden soll wird ein AmigaOS linker wie vlink benötigt. 

Die Dateien startup.s, init.s vasmm68k_mot.exe, vlink.exe befinden sich in
einem Verzeichnis test02. Über die Eingabeaufforderung wechseln wir in das
Verzeichnis test02.

G: cd G:\Amiga\vasm\test02
G:\Amiga\vasm\test02>dir		; alle Dateien da?

Wir müssen jetzt beide Sourcedateien in Objektdateien übersetzen und 
anschließend linken.

G:\Amiga\vasm\test02>vasmm68k_mot -Fhunk -nocase -o startup.o startup.s 
G:\Amiga\vasm\test02>vasmm68k_mot -Fhunk -o init.o init.asm
G:\Amiga\vasm\test02>vlink -bamigahunk -o test startup.o init.o 
Nach jeder Zeile natürlich Enter drücken:

Anschließend können wir das Ergebnis wieder in WinUAE testen:
>test 

;------------------------------------------------------------------------------
Power-Shell:

PS G:\Amiga\vasm\test02>dir

Mode                 LastWriteTime         Length Name
----                 -------------         ------ ----
-a----        19.03.2021     04:45         262144 vlink.exe
-a----        19.03.2021     04:45         386560 vasmm68k_mot.exe
-a----        25.10.2021     21:41            543 startup.s
-a----        25.10.2021     21:41            131 init.s
-a----        29.10.2021     22:17            124 startup.o
-a----        29.10.2021     22:17             92 init.o
-a----        29.10.2021     22:17            100 test

Unter Amiga/WinUAE gibt es die Möglichkeit sich das Hex-Ergebnis anzusehen
>Ram Disk:test/vasm> type test opt h

unter der Power-Shell wäre der Befehl >Format-Hex test

PS G:\Amiga\vasm\test02>Format-Hex test

           00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F

00000000   00 00 03 F3 00 00 00 00 00 00 00 01 00 00 00 00  ...ó............
00000010   00 00 00 00 00 00 00 07 00 00 03 E9 00 00 00 07  ...........é....
00000020   61 00 00 0E 08 39 00 06 00 BF E0 01 66 F2 4E 75  a....9...¿à.fòNu
00000030   33 F9 00 DF F0 06 00 DF F1 80 4E 75 00 00 03 F0  3ù.ßð..ßñNu...ð
00000040   00 00 00 02 73 74 61 72 74 75 70 00 00 00 00 00  ....startup.....
00000050   00 00 00 01 69 6E 69 74 00 00 00 10 00 00 00 00  ....init........
00000060   00 00 03 F2                                      ...ò

;------------------------------------------------------------------------------

Die Symbole sind noch drin, falls man sie debuggen möchte. Ansonsten kann man
sie mit der vlink-Option -s (strip) entfernen. (siehe Lektion19 - Debugger 
uaedbg)

PS G:\Amiga\vasm\test02>vlink -bamigahunk -o test startup.o init.o -s

PS G:\Amiga\vasm\test02>Format-Hex test

           00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F

00000000   00 00 03 F3 00 00 00 00 00 00 00 01 00 00 00 00  ...ó............
00000010   00 00 00 00 00 00 00 07 00 00 03 E9 00 00 00 07  ...........é....
00000020   61 00 00 0E 08 39 00 06 00 BF E0 01 66 F2 4E 75  a....9...¿à.fòNu
00000030   33 F9 00 DF F0 06 00 DF F1 80 4E 75 00 00 03 F2  3ù.ßð..ßñNu...ò


3. xdef/xref oder include
===============================================================================

Im Ordner test03 wird ein Beispiel gezeigt wie include durch xdef/xref 
ersetzt werden kann.
- main.s	- Originalbeispiel
- main1.s	- include einer Assemblerzeile (color1.s)
- main2.s	- include einer Assemblerroutine (color2.s)
- main3.s	- xdef, xref einer Assemblerroutine (hier vlink erforderlich)

Der Ordner test04 wird verwendet um die Listings main3.s und color3.s mit dem
asmone Befehl write linkfile zu übersetzen und anschließend mit vlink zu
"linken".


4. vasm und vlink mit batchfile oder makefile
===============================================================================

Es wäre eine umständliche Methode immer diese kryptischen Zeilen zum Übersetzen
neu einzugeben. Deswegen wird entweder eine Batch-Datei erstellt oder die 
ausführbare Datei wird über den Aufruf eines makefiles durchgeführt. 
				
siehe Lektion 20: batchfile
siehe Lektion 22: makefile				
			
				
*******************************************************************************
*		vasm und vlink an einem festen Ort (Windows)					      *
*******************************************************************************

Damit die Executables vasm und vlink nicht jedesmal mit in den Testordner 
eingefügt werden müssen, werden sie an einen festen Ort abgelegt und über die
Batchdatei gefunden und aufgerufen. Alternativ wäre auch ein kurzzeitiges 
kopieren und löschen möglich.

Eine mögliche Variante dafür wäre unter Windows im Laufwerk C: im Ordner 
Programm einen Unterordner vasm anzulegen und hier die Exe-Dateien
vasmm68k_mot.exe und vlink.exe hineinzulegen.

also hier: C:\Program Files (x86)\vasm

Damit nun vasm und vlink aus jedem Verzeichnis aufgerufen werden können muss
der Pfad der Ausführungsdateien in den Umgebungsvariablen hinzugefügt werden.

So gehts. (bzw. so siehts bei mir aus)

vasmm68k_mot.exe und vlink.exe liegen unter: C:\Program Files (x86)\vasm

- rechte Maustaste auf das Windows Logo (Start) links unten
- dann auf System klicken
- rechts auf "Erweiterte Systemeinstellungen"
- es öffnet sich ein Fenster mit den Systemeigenschaften
  unten steht "Umgebungsvariablen"
- oben unter Benutzervariablen auf Path klicken und Button "Neu" klicken
- nun den Pfad C:\Program Files (x86)\vasm als neuen Eintrag hinkopieren
  (Ihr müsst natürlich den Pfad eintragen wo GnuWin32 bei Euch liegt)

Und nun testen ob vasm und vlink vorhanden sind:
G:\Amiga\vasm\test02>vasmm68k_mot.exe -v
vasm 1.9f (c) in 2002-2023 Volker Barthelmann
vasm M68k/CPU32/ColdFire cpu backend 2.6c (c) 2002-2023 Frank Wille
vasm motorola syntax module 3.18 (c) 2002-2023 Frank Wille
vasm test output module 1.0 (c) 2002 Volker Barthelmann

G:\Amiga\vasm\test02>vlink.exe -v
vlink V0.17a (c)1997-2022 by Frank Wille
build date: May 25 2024, 18:21:29

Ok, das sieht gut aus!
===============================================================================

*******************************************************************************
*		vasm, vlink - Zusammenfassung    								      *
*******************************************************************************

Wenn man diese "Lernstufe" erreicht hat, liest sich die kurze Anleitung auf: 
http://sun.hasenbraten.de/vasm/index.php?view=tutorial
wie eine Selbstverständlichkeit.

A small tutorial for AmigaOS/68k
This small tutorial is for all those who are used to integrated development
environments like DevPac or AsmOne and want to create Amiga 68k executables
from a single source without reading and understanding all of the vasm
documentation.

Basically you will need two programs:

A text editor of your choice to write and save the source text.
The vasm M68k assembler with Motorola syntax, vasmm68k_mot.
Assemble the source text test.asm, and create an executable file test in
AmigaDos hunk format without debug symbols:

  vasmm68k_mot -Fhunkexe -o test -nosym test.asm

Building an executable from several modules
When building an executable from several assembler sources, you need an
AmigaOS linker like vlink to link the object modules into the final
executable.

Assemble your sources:

  vasmm68k_mot -Fhunk -o test1.o test1.asm
  vasmm68k_mot -Fhunk -o test2.o test2.asm

Link the objects into the final executable test while stripping all symbol
information from it:

  vlink -bamigahunk -o test -s test1.o test2.o

Devpac compatibility

The vasmm68k_mot assembler is quite Devpac compatible in its default setting,
but in some cases you may need even stricter compatibility. Specify the
-devpac option for:

Automatic alignment of all data definitions with a size greater than a byte.
Do not use NOP instructions when aligning code.
No code optimizations are done by default. You have to enable those you need
with the appropriate Devpac OPT directives.
Accept up to 36 macro arguments (including \a .. \z) instead of only 10.
Shift-right operations in an expression are unsigned (32 bits).
Predefine the offset symbols __RS, __SO and __FO with 0.
Define the symbols __G2 and __LK.
Allow dots within identifiers.
Warn about any optimization being done.
Do not warn about a size extension for an unsized opcode.
Do not write any symbol information into the output file.


*******************************************************************************
*		vasm, vlink - "selber bauen" Windows    							  *
*******************************************************************************

Wie oben beschrieben, um die vasmm68k_mot.exe zu haben, reicht es aus das
fertige Executable aus dem Zip-File zu nehmen. Wer jedoch wissen will, wie
man die vasmm68k_mot.exe selbst erstellt, sollte hier weiter lesen: 

Die schnelle Antwort ist:

Normalerweise recht simpel. Um vasmm68k_mot zu bauen, sofern ein C Compiler
und ein Make Programm vorhanden ist:
  make CPU=m68k SYNTAX=mot

Und beschrieben ist die Erstellung u.a. in den Compilation Notes auf der vasm
Home Page, oder in der sehr umfangreichen Dokumentation. 

Die ausführliche Erklärung kommt jetzt: 

Um die Executables selbst zu erstellen benötigen sie:
- die Quelltext-Archive (vasm, vlink)
- einen lauffähigen Windows-Compiler
- und GNU-make

GNU-Make sollte eingerichtet sein, ansonsten siehe nochmal: Lektion 22 make
Die Quelltext-Archive finden sie hier:
http://sun.hasenbraten.de/vasm/index.php?view=relsrc	; vasm.tar.gz
http://sun.hasenbraten.de/vlink/index.php?view=relsrc	; vlink.tar.gz

Nun zum Windows-Compiler, der zum Übersetzen der Tools benötigt wird. Unter
Windows würde ich zum GCC raten. Es gibt unter Windows zwei bekannte 
Distributionen: MinGW und Cygwin.

https://sourceforge.net/projects/mingw/files/Installer/mingw-get-setup.exe/download
http://cygwin.com/

Ich habe MinGW installiert, da Cygwin zu viele GNU-Tools enthält die nicht
benötigt werden. 
Denken Sie auch an das Setzen der PATH-Variablen für den Compiler, sodass gcc
aus jedem Ordner aufgerufen werden kann. (Das Setzen der Umgebungsvariablen
erfolgt wie für GNU make beschrieben)

>gcc -v		; in der Eingabeauffoderung zum Testen eingeben

Wenn der C-Compiler und GNU-Make installiert sind und die Archive 
heruntergeladen und entzipt sind können vasm.exe und vlink erstellt werden.

Genau genommen erstellen wir den m68k Assembler mit Motorola Syntax.
>make CPU=m68k SYNTAX=mot	
erstellt: vasmm68k_mot.exe

Wie gesagt, dies ist der lange Weg um "vasm" zu erhalten.

Für vlink gilt das gleiche. Hier
>cd vlink	; Ordner mit den vlink Sourcedateien
>make		; erstellt vlink.exe

Im Augenblick haben wir gcc. Zu vbcc kommen wir später.	(siehe Kapiel VBCC)

*******************************************************************************
*		vasm, vlink - "selber bauen" Linux/ Raspberry Pi					  *
*******************************************************************************

Die Raspberry Pi OS Versionen enthalten bereits einen C-Compiler und auch 
GNU-Make. (GNU Make is the standard Linux utility to do this, and it comes
preinstalled with Raspbian.)

Download vasm
$ curl -O http://sun.hasenbraten.de/vasm/release/vasm.tar.gz

Detailierter Ablauf (Zeilen mit '-' sind Kommentare, Zeilen mit '$' geben sie
direkt in der Shell ein):

1. vasm bauen (install vasm)
- vasm.tar.gz entpacken
$ tar xzf vasm.tar.gz
- und den m68k Assembler mit Motorola Syntax bauen:
$ cd vasm
$ make CPU=m68k SYNTAX=mot
- vasmm68k_mot in den Pfad kopieren

2. vlink bauen
- vlink.tar.gz entpacken
$ tar xzf vlink.tar.gz
- und übersetzen
$ cd vlink
$ make
- vlink in den Pfad kopieren

In den Pfad kopieren meint, die binary vasm und vlink an eine vom Benutzer
erreichbare Stelle z.B. example ~/bin/ zu kopieren.


*******************************************************************************
*		VBCC	- Installation unter Windows								  *
*******************************************************************************

So, nun möchte ich unter Windows mit vbcc Amiga C-Code compilieren und in
WinUAE starten. Was muss ich machen?

Die kurze Antwort wäre:
Den Compiler so einrichten daß er Assembler, Linker und Header Files findet,
sowie den Output in einen Pfad kopieren den WinUAE sehen kann. Soweit, so gut.

Vorbereitung:
===============================================================================

Folgende Dateien werden benötigt:

> vbcc_bin_win64.zip Windows 64-bit binaries von:
http://sun.hasenbraten.de/vbcc/index.php?view=binaries
(enthält auch die Dokumentation zu vbcc)

Die beiden Amiga targets: 
> vbcc_target_m68k-kick13.lha Compiler target Amiga Kickstart 1.2/1.3 M680x0 
> vbcc_target_m68k-amigaos.lha Compiler target AmigaOS 2.x/3.x M680x0 von:
http://sun.hasenbraten.de/vbcc/index.php?view=vbcc0_9h
herunterladen.

Dann werden für das Ziel Betriebssystem z.B. Amiga OS2/3 oder kickstart 1.3 die
entsprechenden Include-Files benötigt. Die 1.3 header-File sind z.B. auf der
Amiga Developer CD zu finden. 
https://archive.org/details/amigadevelopercdv1.2

Das NDK39 findet man bei Haage & Partner. Es enthält die Include Dateien für
Amiga OS2/3.
http://www.haage-partner.net/download/AmigaOS/?C=N;O=D

oder das NDK 3.2 von:
https://www.hyperion-entertainment.com/index.php/downloads


Zum Schluss wird noch ein C-Quelltext benötigt, der mit einem normalen Editor 
erstellt werden kann.

test.c	(Quelltext C-Code)

//#include <dos/dos.h>
#include <libraries/dos.h>
#include <clib/dos_protos.h>
#include <stdlib.h>
#include <stdio.h>

int main(int argc, char* argv[])
{
    static char hello[] = "Hello Amiga!\n";
    Write(Output(), hello, sizeof(hello) - 1);
    printf("Hello C!\n");
    exit(RETURN_OK);
}

Das ganze wird so eingerichtet, dass später aus einem beliebigem Verzeichnis
der Compiler aufgerufen werden kann und der Output dort zunächst erstellt wird. 

Wir entscheiden uns z.B. alles unter C:vbcc zu packen und legen zunächst
folgende Ordner an. Unter C: den Ordner vbcc erstellen. 
Dann erstellen wir folgende Ordner und packen die Archive da rein: 
C:vbcc\01_Sources (Inhalt:	- vbcc_bin_win64.zip, 
							- vbcc_target_m68k-kick13.lha
							- vbcc_target_m68k-amigaos.lha)	
C:vbcc\02_NDK	  (Inhalt:	- NDK3.2R4.lha	  	
C:vbcc\03_Test	  (Inhalt:	- test.c, test.bat)	
Die Ordner bin, config, doc, targets werden beim Entpacken der Archive erstellt.

Nach der Vorbereitung erfolgt die Installation von vbcc.

Installation von vbcc:
===============================================================================

Wir wollen wie gesagt auf dem Windows PC für den Amiga als Zielsystem 
Sourcecode compilieren und brauchen daher den: 
- Compiler: vbcc_bin_win64.zip
(Auf dem Amiga wäre es: vbcc_bin_amigaos68k.lha) 
- Target: vbcc_target_m68k-kick13.lha	(Kickstart 1.3)
	oder: vbcc_target_m68k-amigaos.lha  (Kickstart 2.0, 3.0)

Die zip/lha-Archive enthalten:

vbcc_bin_win64.zip:
	- bin		(vasmm68k_mot.exe,..., vc.exe, vlink.exe,...)
	- config	(aos68k,..,kick13,...,warpos)
	- doc		(vasm.pdf, vbcc.pdf, vlink.pdf)

vbcc_target_m68k-kick13.lha:
	- vbcc_target_m68k-kick13 - config (kick13, kick13m, ..., kick13sr)
							  - targets - m68k-kick13 - include (u.a. stdio.h)
													  - lib (amiga.lib,...)
							  Install
							  Install.info
	- vbcc_target_m68k-kick13.info 	

vbcc_target_m68k-amigaos.lha:
	- vbcc_target_m68k-amigaos	- config (aos68k, aos68km, aos68kr)
								- targets - m68k-amigaos - include (u.a. stdio.h)
														 - lib (amiga.lib,...)
							  Install
							  Install.info
	- vbcc_target_m68k-amigaos.info

Es geht los:
	1)
Unter Vorbereitung haben wir bereits einen Ordner mit dem Namen vbcc unter C:
angelegt. Nun entpacken wir das Archiv vbcc_bin_win64.zip nach C:\vbcc, so daß 
anschließend: "bin" unter C:\vbcc\bin und "config" unter C:\vbcc\config zu 
finden ist.
	2a)
Weiterhin entpacken wir das Target-Archiv vbcc_target_m68k-kick13.lha, so daß
es anschließend unter C:\vbcc\targets\m68k-kick13\ zu finden ist. Den Ordner
C:\vbcc\targets\m68k-kick13\config benötigen wir nicht, da wir die config-Datei
"kick13" aus dem Ordner C:\vbcc\config nehmen. Gut.
	2b)
Gleiches gilt für vbcc_target_m68k-amigaos.lha:
Wir entpacken wir das Target-Archiv vbcc_target_m68k-amigaos.lha, so daß
es anschließend unter C:\vbcc\targets\m68k-amigaos\ zu finden ist. Den Ordner
C:\vbcc\targets\m68k-amigaos\config benötigen wir nicht, da wir die config-Datei
"aos68k" aus dem Ordner C:\vbcc\config nehmen.
	3)
Die C-Quelldatei "test.c" legen wir der Einfachheit halber in den Ordner
03_Test ab.
	4a)
Die speziellen Amiga OS C-Bibliotheken für Kickstart 1.3 kopieren wir von der 
Developer CD aus dem Ordner Inc&AD1.3/Includes nach C:\vbcc\INC13. (und richten
mit der Option -I später den Verweis dorthin entsprechend ein.)
	4b)

Wenn wir dies gemacht haben, haben wir folgende Struktur:

c:\vbcc\bin			; die Executables z.b. vc.exe	
       \config		; z.B. kick13
	   \doc			; vasm.pdf, vbcc.pdf, vlink.pdf
	   \targets		; hier Ordner m68k-kick13 mit includes und lib 
	   \INC13		; hier kommt der Ordner Includes rein von z.B. Inc&AD1.3 
	   \INC32		; hier kommt der Ordner Includes rein von NDK3.2
	   \01_Sources	; u.a. vbcc_bin_win64.zip 
	   \02_NDK		; u.a. NDK3.2R4.lha
	   \03_Test		; unsere C-Quelldatei

Später erfolgt der Compilierungsaufruf über die Windows-Eingabeaufforderung
"cmd" oder einer batch-Datei über den Befehl z.B.: 

 C:\vbcc\test:>vc +kick13 test.c -o test -lamiga

Umgebungsvariable und Verzeichnispfade
===============================================================================

Damit diese Befehlszeile aus allen Ordner ausgeführt werden kann müssen
folgende Dinge eingestellt werden.

Es muss dafür gesorgt werden, daß das Frontend vc über die "VBCC"
Environment Variable die Pfade zu den Binaries und Header Files findet.
Siehe auch vbcc.pdf, Kapitel 1.3.2 (Installing for DOS/Windows).
--> Umgebungsvariablen, Pfadvariablen

(set VBCC=C:\vbcc , set PATH=C:\vbcc\bin;%PATH%)

Also muss die Environment Variable VBCC auf das Installationsverzeichnis
gesetzt werden: D.h. wir tragen VBCC=C:\vbcc ein, da wir wie oben beschrieben,
"bin" unter C:\vbcc\bin und "config" unter C:\vbcc\config liegen. Das 
ermöglicht dem Befehl, vc, alle zugehörigen Dateien zu finden, egal wo man
sich gerade befindet. 

Das Setzen der Umgebungsvariablen und Pfadvariablen über den Weg der 
Eingabeauffoderung ist jedoch nicht statisch (permanent), sondern nur nach
deren Eingabe: Getestet werden kann das auch durch eine Ausgabe des Wertes von
VBCC in der Eingabeaufforderung.

>set			; gibt alle Umgebungsvariablen aus
>echo %VBCC%	; gibt nur den Inhalt von der Variablen VBCC aus

Das +kick13 in der Befehlszeile sagt uns, das die Config-Datei kick13 geladen
wird. 
Nun zum Config File "kick13" welchen wir unter C:\vbcc\config finden. Im Config
File "kick13" sieht man die Suchpfade für die Libraries und Header die bereits
über %VBCC% gehen. Also die Standard C-Bibliotheken, also nichts Amiga
spezifisches.

Die ersten beiden Zeilen des "kick13" Config Files sind:
-cc=vbccm68k -quiet %s -o= %s %s -O=%ld -no-cpp-warn -I%%VBCC%%/targets/m68k-kick13/include
-ccv=vbccm68k		%s -o= %s %s -O=%ld -no-cpp-warn -I%%VBCC%%/targets/m68k-kick13/include

Diese ersten beiden Zeilen müssen um die Include Pfade für kickstart 1.3 
-cc=vbccm68k -quiet %s -o= %s %s -O=%ld -no-cpp-warn -I%%VBCC%%/targets/m68k-kick13/include	-I%%VBCC%%/INC13/Includes
-ccv=vbccm68k		%s -o= %s %s -O=%ld -no-cpp-warn -I%%VBCC%%/targets/m68k-kick13/include -I%%VBCC%%/INC13/Includes

bzw. für Amiga OS2/3 erweitert werden. Dies erfolgt durch die -I option 

Also, -I ist die Option zum Einbinden weiterer Includepfade und %%VBCC%%/ ist
die Umgebungsvariable die jetzt den Wert C:\vbcc hat. 

Kurz die anderen Optionen der Zeile:
- quiet			; keine Ausgabe der Copyright Information
- O				; Optimierung
- no-cpp-warn	; alle Präprozessor Warnungen ausschalten

Wenn alle Einstellungen vorgenommen wurden bzw. unsere "zu Fuss" Installation 
abgeschlossen ist, kann getestet werden.

Test
===============================================================================

Test durch Eingabe in der Eingabeaufforderung oder durch Anlegen und Ausführen
einer Batch-Datei: vbcc.bat
>set VBCC=C:\vbcc
>set PATH=C:\vbcc\bin;%PATH%
>vc +kick13 test.c -o test -lamiga

Hat alles funktionioniert? Wurde eine Datei test erzeugt? Sehr gut. Nun kann
diese Datei aus WinUAE über die shell getetestet werden.
Also Amiga starten, richtigen Pfad einstellen und in der shell >test aufrufen.

Für den Fall, das es nicht geklappt an, prüfen Sie nochmal:
1. Sind die Environment Variablen richtig gesetzt?
2. Ist das Target-Archiv richtig entpackt?
3. Ist das NDK an einen passenden Pfad entpackt? Zur Not kann es auch nach 
   targets/m68k-kick13/include entpackt werden, aber empfehlen würde ich einen
   eigenen Pfad, und diesen dann als -I Option in den ersten beiden Zeilen der
   "kick13" Config hinzufügen.
   

*******************************************************************************
*		VBCC - Installation unter AmigaOS   							      *
*******************************************************************************

Um den Compiler für Amiga-Projekte auf dem Amiga direkt zu nutzen sind 
mindestens drei Pakete notwendig:

Der Compiler selbst von:
- http://sun.hasenbraten.de/vbcc/: vbcc_bin_amigaos68k.lha
Das AmigaOS target-Archiv, ebenfalls von:
- http://sun.hasenbraten.de/vbcc/: vbcc_target_m68k-amigaos.lha
Das NDK 3.2 von:
- https://www.hyperion-entertainment.com/index.php/downloads

Damit vbcc auch Binaries erstellt, die mit der Workbench 1.2 kompatibel sind,
ist ein eigenes Target vorhanden. vbcc_target_m68k-kick13.lha 
Dieses kann man einfach zusätzlich zu m68k-amigaos (OS2/OS3) installieren.
(Die offiziellen 1.3 Includes, z.B. von der Developer CD, nicht vergessen)

Zuerst entpackt man sich das NDK 3.2 an eine geeignete Stelle auf der 
Festplatte, z.B. Work:Coding. Dann entpackt man vbcc_bin_amigaos68k.lha nach
RAM: und startet den darin enthaltenen Installer. Nach der erfolgreichen 
Installation am besten Rebooten. Nun entpackt man vbcc_target_m68k-amigaos.lha 
ebenfalls nach RAM: und startet dessen Installer. Auf die Frage nach den 
System-headern gibt man den Pfad zum entpackten NDK 3.2, Include/include_h an,
also z.B. Work:Coding/NDK_3.2/Include/include_h

