
******************************************************************************
*		FMODE (Lektion 15 - Ergnzung)		 								 *
******************************************************************************

Ich habe eine sehr hohe Bewunderung ber Randys Leistung, wenn man bedenkt, 
dass er die AGA Lektion 15 und die Listings um 1994 als er noch ein Teenager
war geschrieben hat. Die Listings wurden daher auch nicht verbessert, sondern
entsprechen dem Originalen aus dieser Zeit.

Aber wenn man etwas heute besser wei, dann sollten die Dinge auch genannt 
werden. Eine Sache ist dabei die richtige Kalkulation der DDFSTOP Werte bei
Verwendung des FMODE mit Werten grer 0.

Wir zitieren direkt aus der Lektion: "Es ist jedoch eine SEHR WICHTIGE
Klarstellung erforderlich: Das ndern des FETCH beinhaltet auch eine MODULO-
Korrektur aufgrund von Hardware-Umstnden. usw."

Dies ist jedoch nicht der Fall.

*******************************************************************************
*		FMODE und DDFSTOP bzw. BPLMOD bei LOWRES							  *	
*******************************************************************************

Im Listings15c.s wird ein Lowres Screen mit 320x256 und einem FMODE=3
folgendermaen eingerichtet:

	Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$108,-8				; BPL1MOD (burst 64bit, modulo=modulo-8)
	dc.w	$10a,-8				; BPL2MOD (wie oben)

D.h. es wird eine Modulo-Korrektur von -8 vorgenommen, anstatt den richtigen
DDFSTOP Wert zu verwenden. Das bedeutet, dass anstatt z.B. 40 Bytes werden 
48 Bytes abgerufen und am Ende muss man 8 Bytes zurckgehen (korrigieren). 
Es entspricht einem Abruf von 64 Bit zuviel. Es werden also 384 Pixel anstatt
320 Pixel abgerufen.

320 px/8=40 Bytes
320 px/64=5 Gruppen mit je 64px
64 Bit/8=8 Bytes
 
Eine richtige Formel zur Berechnung des DDFSTOP-Wertes bei Lowres ist:

DDFSTOP=DDFSTRT+(px_Breite-DMA_Breite)/2
DDFSTOP=DDFSTRT+(px_Breite-Fetch*16px)/2

Beispiel: 320 px, DDFSTRT=$38, FMODE=4x ->
DDFSTOP= $38+(320-4*16)/2= $b8
DDFSTOP= $38+(320-64)/2= $b8

oder fr FMODE 1x, 2x, 4x
>?$38+(320-1*16)/2 = $D0
>?$38+(320-2*16)/2 = $C8
>?$38+(320-4*16)/2 = $B8

Hintergrund:
Nach der bereinstimmung von DDFSTOP gibt es immer noch einen vollstndigen 
Bitplane-DMA-Block (alle aktivierten Ebenen werden abgerufen), bevor der DMA 
stoppt. D.h. erfolgt DDSTOP bei >$b8 (wie $c0), wrde es einen weiteren Abruf
geben (also 320+64), Sie knnen also einen "Bereich" verwenden.

Diese zustzlichen 64Bit entsprechen 8 Byte, die durch die Modulo-Korrektur
BPLxMOD -8 zurckgegangen werden mssen. 

Ein negatives Modulo ist also eine schlechte Methode, um fetch > 0 zu 
verarbeiten, da dadurch mehr Bitplane DMA Abrufe erfolgen als ntig. 
Stattdessen ist es besser, DDFSTOP zu reduzieren, um das Abrufen frher zu
beenden.

Das Endergebnis kann auch bei technisch falschem Wert dasselbe sein, da es 
8/16/32 mgliche DDFSTOP-Werte mit demselben Ergebnis gibt. Das heit:
Bei FMODE=4x, DDFSTRT=$38 funktioniert auch ein DDFSTOP von $9a bis $b8.

Es ist aber sicherlich einfacher es mit einer einfachen Formel zu berechnen.

Mit dem neuen Wissen knnen wir die Einstellungen also wie folgt in der 
Copperliste ndern:

	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00b8			; DDFSTOP
	...	
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

Dies gilt auch fr die LORES 320x256 Listings: Listing15f.s bis Listing15g2.s

*******************************************************************************

Eine andere Formel nach HRM wre:	DDFSTOP=DDFSTART+(8*(word_count-1))
oder allgemein:						DDFSTOP=DDFSTART+(8*(word_count-fetchmode))

D.h. mit FMODE 1x, 2x, 4x mit DDFSTRT=$38 und 320px/16px=20 
>?$38+8*(20-1) => DDFSTOP=$d0 
$000000D0 = %00000000`00000000`00000000`11010000 = 208 = 208
>?$38+8*(20-2) => DDFSTOP=$c8 
$000000C8 = %00000000`00000000`00000000`11001000 = 200 = 200
>?$38+8*(20-4) => DDFSTOP=$b8 
$000000B8 = %00000000`00000000`00000000`10111000 = 184 = 184
>

*******************************************************************************

MEMORYFETCHMODE equ 0 ;0 (OCS),1 or 3
	ifeq MEMORYFETCHMODE
DDF_INCREMENT equ 1
	else
DDF_INCREMENT equ (MEMORYFETCHMODE+1)&$fffe
	endif

*******************************************************************************
DDF_START set $38
DDF_WORDWIDTH set 20
DDF_STOP set DDF_START+((DDF_WORDWIDTH-DDF_INCREMENT)*8)

zum Beispiel:

DDF_STOP= DDF_START+((DDF_WORDWIDTH-DDF_INCREMENT)*8)
DDF_STOP= $38+(20-4)*8

Das entspricht der Formel, die oben aufgelistet ist:
DDF_WORDWIDTH*16=px, DDF_INCREMENT*16=DMA_width

*******************************************************************************
*		FMODE und DDFSTOP bzw. BPLMOD bei HIRES								  *	
*******************************************************************************

Im Listing15d.s wird ein Hires Screen mit: 640x256 (8 Bitplanes) wie folgt
eingerichtet:

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP

; Hinweis: Die DDFSTRT/stop HIRES wren $003c und $00d4, aber mit dem Burst aktiv
; der gleiche Wert wie bei LOWRES ist in Ordnung, dh $0038 und $00d0.

	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,-8				; BPL1MOD (burst 64bit, modulo=modulo-8)
	dc.w	$10a,-8				; BPL2MOD (wie oben)

Die richtige Formel zur Berechnung des DDFSTOP-Wertes fr Hires ist jedoch:

Die Formel nach HRM fr wre:	DDFSTOP=DDFSTART+(4*(word_count-2))
aber richtiger erscheint:		DDFSTOP=DDFSTART+(4*(word_count-1))
oder allgemein:					DDFSTOP=DDFSTART+(4*(word_count-fetchmode))

D.h. mit FMODE 1x, 2x, 4x mit DDFSTRT=$38 und 620px/16px=40 
>?$38+4*(40-1)	 => DDFSTOP=$d4
$000000D4 = %00000000`00000000`00000000`11010100 = 212 = 212
>?$38+4*(40-2)	 => DDFSTOP=$d0
$000000D0 = %00000000`00000000`00000000`11010000 = 208 = 208
>?$38+4*(40-4)	 => DDFSTOP=$c8
$000000C8 = %00000000`00000000`00000000`11001000 = 200 = 200

Mit dem neuen Wissen knnen wir die Einstellungen also wie folgt ndern:

	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00c4			; DDFSTOP
	...	
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

Dies gilt auch fr die Hires 640x256 Listings: Listing15g3.s und Listing15g4.s.
Und fr die HAM8 Beispiele Listing15e.s und Listing15e2.s

*******************************************************************************
*		FMODE und DDFSTOP bzw. BPLMOD bei SuperHires						  *	
*******************************************************************************

Gemss diesem Schemas wre die Berechnung fr Superhires wahrscheinlich:
allgemein:					DDFSTOP=DDFSTART+(2*(word_count-fetchmode))

>?$38+2*(80-1)
$000000D6 = %00000000`00000000`00000000`11010110 = 214 = 214
>?$38+2*(80-2)
$000000D4 = %00000000`00000000`00000000`11010100 = 212 = 212
>?$38+2*(80-4)
$000000D0 = %00000000`00000000`00000000`11010000 = 208 = 208
>

*******************************************************************************
*		FMODE und BPLMOD 													  *	
*******************************************************************************

Wenn die Breite des Bildes allerdings kein Vielfaches von 32Bit/64Bit ist muss
es auf ein Ganzzahliges Vielfaches von 32Bit/64Bit erweitert werden und spter
durch das Modulo auf die wirkliche Breite angepasst werden.

Wollte man bspw. 42 Bytes (336px) anzeigen wrden mit FMODE=3 zunchst 48 Bytes
(384px) abgerufen werden und anschlieend msste man durch ein Modulo = -6 die
zuviel abgerufenen Bytes wieder zurckgehen. 

*******************************************************************************
*		FMODE - Grundlagen													  *	
*******************************************************************************

Nachdem wir nun die richtigen DDFSTOP Werte berechnen knnen um ein negatives
Modulo zu vermeiden, ist es nochmal angebracht den FMODE etwas zu erklren.

Also mit dem FMODE ist es mglich die Datenbertragung aus dem Speicher zur
Videoausgabe zu beschleunigen. Dies wird auch als Burst oder Bandbreite 
bezeichnet und kann 16Bit/32Bit/64Bit betragen. Wobei der FMODE dann als 0,1,3
eingestellt wird und die Beschleunigung auch als 1x, 2x oder 4x gennant wird.

1x -> 16-Bit-DMA-Basisbreite, 2x -> 32 Bit, 4x -> 64 Bit.

Sprite und Bitplanes mssen dabei im Speicher auf Adressen mit Vielfachen von
16Bit/32Bit/64Bit entsprechend dem FMODE 1x,2x,4x ausgerichtet sein: 
1x	16Bit	cnop 0,2 -> Bitmap-Daten Vielfaches von 16Bit, und Modulo = 0
2x  32Bit	cnop 0,4 -> Bitmap-Daten Vielfaches von 32Bit, und Modulo = 0
4x  64Bit	cnop 0,8 -> Bitmap-Daten Vielfaches von 64Bit, und Modulo = 0

Bsp:
	cnop	0,8			; auf 64 Bit ausrichten
Picture:
	incbin	"/Sources/Pic640x100x256.raw"

Nur die Sprites und Bitplane knnen die Vorteile von FMODE 32Bit/64Bit voll 
ausschpfen und dies auch nur bei AGA.

Und nur die Datenleitungen von Alice (Agnus AGA) zu Lisa (Denise AGA) verfgen
ber einen optionalen 64-Bit-Bus (doppeltgetakteter 32-Bit-Bus) mit FMODE=3.
Alle anderen Chipsatzbusse sind weiterhin 32-Bit oder 16-Bit.

Register: $dff1fc

FMODE
         This register controls the fetch mechanism for different
         types of Chip RAM accesses:
		 
         +-------+----------+-------------------------------------------+
         | BIT#  | FUNCTION | DESCRIPTION                               |
         +-------+----------+-------------------------------------------+
         | 15    | SSCAN2   | Global enable for sprite scan-doubling.   |
         | 14    | BSCAN2   | Enables the use of 2nd P/F modulus on an  |
         |       |          | alternate line basis to support bitplane  |
         |       |          | scan-doubling.                            |
         | 13-04 | Unused   |                                           |
         | 03    | SPAGEM   | Sprite page mode (double CAS)             |
         | 02    | SPR32    | Sprite 32 bit wide mode                   |
         | 01    | BPAGEM   | Bitplane Page Mode (double CAS)           |
         | 00    | BLP32    | Bitplane 32 bit wide mode                 |
         +-------+----------+-------------------------------------------+
		 
         +------+-----+---------------+-----------+--------------+---------+
         |BPAGEM|BPL32| Bitplane Fetch|Increment  | Memory Cycle |Bus Width|
         +------+-----+---------------+-----------+--------------+---------+
         | 0    |  0  | By 2 bytes    |(as before)|normal CAS    |16       |
         | 0    |  1  | By 4 bytes    |           |normal CAS    |32       |
         | 1    |  0  | By 4 bytes    |           |double CAS    |16       |
         | 1    |  1  | By 8 bytes    |           |double CAS    |32       |
         +------+-----+---------------+-----------+--------------+---------+
		 
         +------+-----+------------+-----------+-------------+---------+
         |SPAGEM|SPR32|Sprite Fetch|Increment  |Memory Cycle |Bus Width|
         +------+-----+------------+-----------+-------------+---------+
         |  0   |  0  | By 2 bytes |(as before)| normal CAS  |   16    |
         |  0   |  1  | By 4 bytes |           | normal CAS  |   32    |
         |  1   |  0  | By 4 bytes |           | double CAS  |   16    |
         |  1   |  1  | By 8 bytes |           | double CAS  |   32    |
         +------+-----+------------+-----------+-------------+---------+

Beispiel - Auszug Copperliste:
	dc.w	$1fc,0		; Burst mode gelscht
	dc.w	$1fc,3		; Burst mode 64 bit
	dc.w	$1fc,%0111	; Burst mode 64 bit, Sprite Gre 32 pixel
	dc.w	$1fc,%1111	; Burst mode 64 bit, Sprite Gre 64 pixel
	
Und der groe Vorteil vom FMODE >0 ist:
- es wird DMA-Zeit eingespart, mit FMODE=3 sind deutlich mehr DMA-Slots frei
- bei Hires sind mehr als 4 Bitebenen mglich
- es macht SuperHires erst mglich
- es sind Sprites mit 32px bzw. 64px mglich

Das liegt an der Funktionsweise des erweiterten AGA-Fetch-Modus. Man kann es 
sich gut mit dem visuellen DMA-Debugger ansehen. Die Bitplane-DMA-Slots sind
nicht gleichmig ber die Zeit verteilt, sondern "gepackt".

Lores: 1 bis 256 pixel, d.h. von 1 bis 8 Bitplanes:

8-Bitplane-DMA Schema:
x1: $38     $40      $48      $50      $58
    xxxxxxxx|xxxxxxxx|xxxxxxxx|xxxxxxxx|
x2: $38     $40      $48      $50      $58
    xxxxxxxx|        |xxxxxxxx|        |
x4: $38     $40      $48      $50      $58
    xxxxxxxx|        |        |        |

;------------------------------------------------------------------------------
1x
>v $30 $38
Line: 30  48 HPOS 38  56:
 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
 0                                                         FFFF         8140         FFFF         7FCA
                                                       000AC8C0     000A28C0     000A78C0     0009D8C0
         2    RA0   00FC           6            8            0            2    RA0   00FC           6
                                                      258   2C0    244   2C0    24E   2C0    23A   2C0

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
       FFFF         FFFF         FEBF         7EBF         FFFF         6B34         FFFF         BEFD
   000AA0C0     000A00C0     000A50C0     0009B0C0     000AC8C2     000A28C2     000A78C2     0009D8C2
         8            0            2    RA0   00FC           6            8            0            2
  254   0C0    240   0C0    24A   0C0    236   0C0    258   2C2    244   2C2    24E   2C2    23A   2C2

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
       FFFF         FBCB         D5FF         90FF         FFFF         DD5D         FFFF         FFDD
   000AA0C2     000A00C2     000A50C2     0009B0C2     000AC8C4     000A28C4     000A78C4     0009D8C4
 RA0   00FC           6            8            0            2    RA0   00FC           6            8
  254   0C2    240   0C2    24A   0C2    236   0C2    258   2C4    244   2C4    24E   2C4    23A   2C4

 [50 098 -]   [51 09A -]   [52 09C -]   [53 09E -]   [54 0A0 -]   [55 0A2 -]   [56 0A4 -]   [57 0A6 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
       FFFF         03A2         FEFF         FEFF         FFFF         200F         FFFF         E08E
   000AA0C4     000A00C4     000A50C4     0009B0C4     000AC8C6     000A28C6     000A78C6     0009D8C6
         0            2    RA0   00FC           6            8            0            2    RA0   00FC
  254   0C4    240   0C4    24A   0C4    236   0C4    258   2C6    244   2C6    24E   2C6    23A   2C6

 [58 0A8 -]   [59 0AA -]   [5A 0AC -]   [5B 0AE -]   [5C 0B0 -]   [5D 0B2 -]   [5E 0B4 -]   [5F 0B6 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
       FFFF         DF71         FFFE         FFFF         FFFF         E400         FFFF         0000
   000AA0C6     000A00C6     000A50C6     0009B0C6     000AC8C8     000A28C8     000A78C8     0009D8C8
         6            8            -            -            -            -            -            0
  254   0C6    240   0C6    24A   0C6    236   0C6    258   2C8    244   2C8    24E   2C8    23A   2C8

;------------------------------------------------------------------------------
2x
>v $30 $38
Line: 30  48 HPOS 38  56:
 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
 0                                                     FFFFFFFF     81406B34     FFFFFFFF     7FCABEFD
                                                       000AC8C0     000A28C0     000A78C0     0009D8C0
         6            8            -            -            -            -            -            0
                                                      258   2C0    244   2C0    24E   2C0    23A   2C0

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110
   FFFFFFFF     FFFFFBCB     FEBFD5FF     7EBF90FF
   000AA0C0     000A00C0     000A50C0     0009B0C0
         2    RA0   00FC           6            8            -            -            -            -
  254   0C0    240   0C0    24A   0C0    236   0C0

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
                                                       FFFFFFFF     DD5D200F     FFFFFFFF     FFDDE08E
                                                       000AC8C4     000A28C4     000A78C4     0009D8C4
         -            0            2    RA0   00FC           6            8            -            -
                                                      258   2C4    244   2C4    24E   2C4    23A   2C4

 [50 098 -]   [51 09A -]   [52 09C -]   [53 09E -]   [54 0A0 -]   [55 0A2 -]   [56 0A4 -]   [57 0A6 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110
   FFFFFFFF     03A2DF71     FEFFFFFE     FEFFFFFF
   000AA0C4     000A00C4     000A50C4     0009B0C4
         -            -            -            0            2    RA0   00FC           6            8
  254   0C4    240   0C4    24A   0C4    236   0C4

 [58 0A8 -]   [59 0AA -]   [5A 0AC -]   [5B 0AE -]   [5C 0B0 -]   [5D 0B2 -]   [5E 0B4 -]   [5F 0B6 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
                                                       FFFFFFFF     E400FF81     FFFF0079     00000000
                                                       000AC8C8     000A28C8     000A78C8     0009D8C8
                      -            -            -            -            0            2    RA0   00FC
                                                      258   2C8    244   2C8    24E   2C8    23A   2C8

;------------------------------------------------------------------------------
4x
>v $30 $38
Line: 30  48 HPOS 38  56:
 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
 0                                                     FFFFFFFF     81406B34     FFFFFFFF     7FCABEFD
                                                       FFFFFFFF     DD5D200F     FFFFFFFF     FFDDE08E
         -            0            2    RA0   00FC           6            8            0            2
                                                       000AC8C0     000A28C0     000A78C0     0009D8C0

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110
   FFFFFFFF     FFFFFBCB     FEBFD5FF     7EBF90FF
   FFFFFFFF     03A2DF71     FEFFFFFE     FEFFFFFF
 RA0   00FC           6            8            0            2    RA0   00FC           6            8
   000AA0C0     000A00C0     000A50C0     0009B0C0

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]



         0            2    RA0   00FC           6            8            0            2    RA0   00FC


 [50 098 -]   [51 09A -]   [52 09C -]   [53 09E -]   [54 0A0 -]   [55 0A2 -]   [56 0A4 -]   [57 0A6 -]



         6            8            0            2    RA0   00FC           6            8            0


 [58 0A8 -]   [59 0AA -]   [5A 0AC -]   [5B 0AE -]   [5C 0B0 -]   [5D 0B2 -]   [5E 0B4 -]   [5F 0B6 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
                                                       FFFFFFFF     E400FF81     FFFF0079     00000000
                                                       FFFFFFFF     DFF83A0B     FFFFFC74     0007C1FF
         2    RA0   00FC           6            8            0            2    RA0   00FC           6
                                                       000AC8C8     000A28C8     000A78C8     0009D8C8
;------------------------------------------------------------------------------

Hires: 32 bis 256 pixel, d.h. von 5 bis 8 Bitplanes:
ab 32 Farben ist mindestens Fetch: 2x = 32 Bit erforderlich

8-Bitplane-DMA Schema:
x1: --- nicht mglich
x2: $38     $40      $48      $50      $58
    xxxxxxxx|xxxxxxxx|xxxxxxxx|xxxxxxxx|
x4: $38     $40      $48      $50      $58
    xxxxxxxx|        |xxxxxxxx|        |

;------------------------------------------------------------------------------
>v $30 $38
Line: 30  48 HPOS 38  56:
 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
 0                                                     00000000     00000000     00000000     00000000
                                                       000A93E0     000A16E0     000A5560     0009D860
         8            -            -            -            -            -            0            2
                                                      353   0E0    243   1E0    34A   160    23A   260

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
   00000000     00000000     00000000     00000000     00000000     00000000     00000000     00000000
   000A74A0     0009F7A0     000A3620     0009B920     000A93E4     000A16E4     000A5564     0009D864
 RA0   00FC           6            8            -            -            -            -            -
  24E   1A0    33F   1A0    247   120    336   220    353   0E4    243   1E4    34A   164    23A   264

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
   00000000     00000000     00000000     00000000     00000000     00000000     00000000     00000000
   000A74A4     0009F7A4     000A3624     0009B924     000A93E8     000A16E8     000A5568     0009D868
         0            2    RA0   00FC           6            8            -            -            -
  24E   1A4    33F   1A4    247   124    336   224    353   0E8    243   1E8    34A   168    23A   268

 [50 098 -]   [51 09A -]   [52 09C -]   [53 09E -]   [54 0A0 -]   [55 0A2 -]   [56 0A4 -]   [57 0A6 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
   00000000     00000000     00000000     00000000     00000000     00000000     00000000     00000000
   000A74A8     0009F7A8     000A3628     0009B928     000A93EC     000A16EC     000A556C     0009D86C
         -            -            0            2    RA0   00FC           6            8            -
  24E   1A8    33F   1A8    247   128    336   228    353   0EC    243   1EC    34A   16C    23A   26C

 [58 0A8 -]   [59 0AA -]   [5A 0AC -]   [5B 0AE -]   [5C 0B0 -]   [5D 0B2 -]   [5E 0B4 -]   [5F 0B6 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110   BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
   00000000     00000000     00000000     00000000     00000000     00000000     00000000     00000000
   000A74AC     0009F7AC     000A362C     0009B92C     000A93F0     000A16F0     000A5570     0009D870
         -            -            -            -            0            2    RA0   00FC           6
  24E   1AC    33F   1AC    247   12C    336   22C    353   0F0    243   1F0    34A   170    23A   270

;------------------------------------------------------------------------------
4x

>v $30 $38
Line: 30  48 HPOS 38  56:
 [38 068 -]   [39 06A -]   [3A 06C -]   [3B 06E -]   [3C 070 -]   [3D 072 -]   [3E 074 -]   [3F 076 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
 0                                                     00000000     00000000     00000000     00000000
                                                       00000000     00000000     00000000     00000000
         2    RA0   00FC           6            8            0            2    RA0   00FC           6
                                                       000A93E0     000A16E0     000A5560     0009D860

 [40 078 -]   [41 07A -]   [42 07C -]   [43 07E -]   [44 080 -]   [45 082 -]   [46 084 -]   [47 086 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110
   00000000     00000000     00000000     00000000
   00000000     00000000     00000000     00000000
         8            0            2    RA0   00FC           6            8            -            -
   000A74A0     0009F7A0     000A3620     0009B920

 [48 088 -]   [49 08A -]   [4A 08C -]   [4B 08E -]   [4C 090 -]   [4D 092 -]   [4E 094 -]   [4F 096 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
                                                       00000000     00000000     00000000     00000000
                                                       00000000     00000000     00000000     00000000
         -            -            -            0            2    RA0   00FC           6            8
                                                       000A93E8     000A16E8     000A5568     0009D868

 [50 098 -]   [51 09A -]   [52 09C -]   [53 09E -]   [54 0A0 -]   [55 0A2 -]   [56 0A4 -]   [57 0A6 -]
 BPL7   11C   BPL3   114   BPL5   118   BPL1   110
   00000000     00000000     00000000     00000000
   00000000     00000000     00000000     00000000
         -            -            -            -            -            0            2    RA0   00FC
   000A74A8     0009F7A8     000A3628     0009B928

 [58 0A8 -]   [59 0AA -]   [5A 0AC -]   [5B 0AE -]   [5C 0B0 -]   [5D 0B2 -]   [5E 0B4 -]   [5F 0B6 -]
                                                     BPL8   11E   BPL4   116   BPL6   11A   BPL2   112
                                                       00000000     00000000     00000000     00000000
                                                       00000000     00000000     00000000     00000000
         6            8            -            -            -            -            -            0
                                                       000A93F0     000A16F0     000A5570     0009D870

;------------------------------------------------------------------------------

SuperHires: fr 32 bis 256 pixel, d.h. von 5 bis 8 Bitplanes:
ab 32 Farben ist mindestens Fetch: 3x = 64 Bit erfoderlich

SUPERHIRES (1280x200)	fr 2, 4 Farben reichen 16 Bit aus
						fr 8, 16 Farben werden 32 Bit bentigt
						fr 32, 64, 128, 256, HAM8 bentigen Sie 64 Bit


8-Bitplane-DMA Schema:
x1: --- nicht mglich
x2: --- nicht mglich
x4: $38     $40      $48      $50      $58
    xxxxxxxx|xxxxxxxx|xxxxxxxx|xxxxxxxx|
	
Beispiel ergnzen.

*******************************************************************************
*		FMODE=2																  *		
*******************************************************************************

https://eab.abime.net/showthread.php?t=86883

FMODE=2 ist nutzlos?

Ich habe endlich Emulationsuntersttzung fr nicht ausgerichtete FMODE>0-
Bitebenen und Sprites implementiert. (nicht ausgerichtet = keine durch 4 und/
oder 8 teilbare Adresse, es ist keine einfache Adressmaskierung) und habe etwas
Interessantes bemerkt:

FMODE=2 funktioniert unerwartet, aber ich habe niemanden gefunden, der das 
jemals erwhnt hat. berall wurde immer gesagt, dass 1 und 2 gleich sind. Ja,
sie haben dieselbe Zyklusnutzung, aber was Sie sehen, ist ziemlich anders.

Wenn FMODE=2, betrgt die logische Abrufbreite 32 Bit (auf Hardwareebene ist
sie 2x16), aber das obere oder untere 16-Bit-Wort wird immer dupliziert. 
Obere 16 Bit, wenn ausgerichtet, untere 16 Bit, wenn nicht ausgerichtet, zum 
Beispiel wird $12345678 zu $12341234.

Handelt es sich hierbei also um eine teilweise nicht implementierte 
Hardwarefunktion oder ist sie nur fr die Untersttzung von FMODE=3 gedacht
(ermglicht doppelte 32-Bit-Abrufe) und FMODE=2 ist nur ein Nebeneffekt, der
nie verwendet werden sollte?

(Eine vollstndige Beschreibung des nicht ausgerichteten Verhaltens wird
 spter dem nicht dokumentierten Hardware-Thread hinzugefgt.)
 
Das habe ich versucht, und es funktioniert einwandfrei fr fmode 0, 1 und 3,
aber nicht fr fmode 2?
Vielleicht liegt es an einem Winuae-Fehler, da in diesem Modus jedes 
angezeigte Wortpaar vertauscht wird.
Nachtrag: Es vertauscht sie nicht, aber es scheint, als wre das zweite Wort
eine Kopie des ersten oder so hnlich.

Sie haben es wahrscheinlich nicht erwartet, aber es ist das korrekte
Verhalten :)
FMODE=2 ist nutzlos. (BEARBEITEN: Es hat die gleiche Zyklussequenz wie
FMODE=1, daher ging nichts Ntzliches verloren.)

Hallo Toni, als ich noch produktiv war (Mitte der 90er), ist mir dieses
unterschiedliche Verhalten zwischen Fetch-Modus 1 und 2 aufgefallen.

FMODE=2 unaligned schien interessant, aber ich konnte nichts Ntzliches daraus
machen ... vielleicht jetzt :)
Gut, dass diese Funktion implementiert ist!

Jetzt in 3410b7 untersttzt. Ich habe Bitebenen nur mit einigen ziemlich 
abstrakten Tests getestet,dann habe ich dasselbe fr Sprites gespiegelt, die
berhaupt nicht getestet werden.

FMODE=1 und FMODE=2
32-Bit-Wert laden (Adresse UND ~3)
Falls Adresse nicht durch 4 teilbar ist: 
						- untere 16-Bit werden in obere 16-Bit kopiert.
Falls FMODE=2 und Adresse durch 4 teilbar ist: 
						- obere 16-Bit werden in untere 16-Bit kopiert

FMODE=3:
64-Bit-Wert laden (Adresse UND ~7)
Falls Adresse nicht durch 8 teilbar ist:
						- untere 32-Bit werden in obere 32-Bit kopiert
Falls Adresse nicht durch 4 teilbar ist: 
							dasselbe mit beiden 32-Bit-Hlften machen: 
						- untere 16-Bit in obere 16-Bit kopieren.

BEARBEITEN: Dies passiert einfach, weil das Mainboard 4 x 256kx16 
Speicherchips hat


*******************************************************************************
*		FMODE und Scrollen (BPLCON1)										  *	
*******************************************************************************

BPLCON1
 +------+---------+---------------------------------------------------------+
 | BIT# | BPLCON1 | DESCRIPTION                                             |
 +------+---------+---------------------------------------------------------+
 | 15   | PF2H7=0 | (PF2Hx =) Playfield 2 horizontal scroll code, x=0-7     |
 | 14   | PF2H6=0 |                                                         |
 | 13   | PF2H1=0 |                                                         |
 | 12   | PF2H0=0 |                                                         |
 | 11   | PF1H7=0 | (PF1Hx =) Playfield 1 horizontal scroll code, x=0-7     |
 | 10   | PF1H6=0 | where PFyH0=LSB=35ns SHRES pixel (bits have been        |
 | 09   | PF1H1=0 | renamed, old PFyH0 now PFyH2, ect). Now that the scroll |
 | 08   | PF1H0=0 | range has been quadrupled to allow for wider (32 or     |
 |      |         | 64 bits) bitplanes.                                     |
 | 07   | PF2H5   |                                                         |
 | 06   | PF2H4   |                                                         |
 | 05   | PF2H3   |                                                         |
 | 04   | PF2H2   |                                                         |
 | 03   | PF1H5   |                                                         |
 | 02   | PF1H4   |                                                         |
 | 01   | PF1H3   |                                                         |
 | 00   | PF1H2   |                                                         |
 +------+---------+---------------------------------------------------------+
 
