;======================================================================================================================
; Wait For Raster the proper way
; This makes sure that the code is not execute twice between 0 - $38 and $100 - $138
;
; VHPOSR
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; V7	V6	V5	V4	V3	V2	V1	V0	H8	H7	H6	H5	H4	H3	H2	H1
;
; VPOSR
; 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; LOF	I6	I5	I4	I3	I2	I1	I0	LOL	xx	xx	xx	xx	V10	V9	V8
;======================================================================================================================
; VPOSR + VHPOSR 
; A "Y" Below means we want the value
; 31	30	29	28	27	26	25	24	23	22	21	20	19	18	17	16 15	14	13	12	11	10	09	08	07	06	05	04	03	02	01	00
; LOF	I6	I5	I4	I3	I2	I1	I0	LOL	xx	xx	xx	xx	V10	V9	V8 V7	V6	V5	V4	V3	V2	V1	V0	H8	H7	H6	H5	H4	H3	H2	H1
;                                                           	Y	Y	Y	Y	Y	Y	Y	Y	Y 
;======================================================================================================================

WaitForRaster:
		move.l	#$1ff00,d1		; Set D1 = $0001ff00
		move.l	#$12c00,d2		; Set D2 = $00012c00
	.Waity1:
		move.l	4(a5),d0		; Read both $DFF004 & $DFF006 - VPOSR + VHPOSR
		and.l	d1,d0			; And with $0001ff00
		cmp.l	d2,d0			; $00012c00 = 300 Raster at position 300?
		bne.s	.Waity1			; Loop

	;------------------------------------------------------------------------------------------------------------------
	; Make sure We are still not on the same Raster line
	.Waity2:
		move.l	4(a5),d0		; Read both $DFF004 & $DFF006 - VPOSR + VHPOSR
		and.l	d1,d0			; And with $0001ff00
		cmp.l	d2,d0			; $00012c00 = 300 Raster at position 300?
		beq.s	.Waity2			; Loop

		rts