  $    
8  [                        ;=================================================================
;=== Glenz Vector Routive V1.0 === (C)1999 by Vlastimil Knotek ===
;=================================================================
MAXPOINTS1	=	18
MAXPOINTS2	=	24
RESOLUTION	=	320
INTERLACE	=	256
DEPTH		=	5
;---------------------------------------------------------

Start:	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	MakeMulsList

	lea	Scene1(pc),a1
	bsr	InitAnim
	bsr	StartCopper
	bsr	MainLoop

	bsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts

;--- Take system -----------------------------------------

SaveAll:
	move.l	$4.w,a6
	lea.l	GfxName(pc),a1
	moveq	#0,D0
	jsr	-408(a6)	;OldOpenLibrary
	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$32(a1),(a0)
	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$64.w,(a0)
	rts

;--- Restore System --------------------------------------

RestoreAll:
	move.l	chipbase(pc),a6
raw:	btst	#6,$dff002
	bne.s	raw
	move.l	OldCopper1(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.l	OldSOFT(pc),$64.w
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts

GfxName		DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldSOFT:	DC.L	0

;--- Star Copper & Interrupts ----------------------------

StartCopper:
	cmp.b	#-1,$6(a6)
	bne.s	StartCopper
	move.w	#$7fff,$96(a6)
	move.w	#$7fff,$9a(a6)
	move.l	#CopperList,$80(a6)
	tst.w	$88(a6)
	move.w	#$83c0,$96(a6)
	;move.w	OldINTENA(pc),d0
	;or.w	#$c004,d0
	move.w	#$c004,$9a(a6)
	rts

;=========================================================
;--- Startup actions -------------------------------------

InitAll:
	move.l	TMapAddress(pc),a5
	move.l	#((RESOLUTION/8)*INTERLACE)/2-1,d0
.clrbuf	move.w	#0,(a5)+
	dbf	d0,.clrbuf
	
	lea	Interrupt(pc),a0
	move.l	a0,$64.w
	rts

;---------------------------------------------------------
MakeMulsList:
	move.l	MulsPtr(pc),a0
	moveq	#0,d0
	move.l	#INTERLACE-1,d1
mmloop:	move.w	d0,(a0)+
	addi.w	Width(pc),d0
	dbf	d1,mmloop
	rts

;---------------------------------------------------------
InitAnim:
	bsr	ClearBig
	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	bsr	ClearBig	

	move.l	a1,ScenePtr
	move.l	RootPtr(pc),a2
	move.w	(a1)+,d0	; number of objects
	subq.w	#1,d0
IA_01:
	move.l	(a1)+,a0	; address of object
	move.l	4(a0),a3	; areas
	bsr	PMuls	
	move.l	8(a0),a3	; anim
	lea	-14(a3),a3
	move.l	a3,4(a2)	; address of anim table
	move.w	#0,8(a2)
	move.w	#0,10(a2)
	lea	12(a2),a2
	dbf	d0,IA_01

	bsr	Move
	move.w	#0,ends
	rts

;---------------------------------------------------------
PMuls:	move.l	d0,-(a7)
	move.w	(a3)+,d1
	subq.w	#1,d1
.loop1:	moveq	#0,d0
	move.b	1(a3),d0
	addq.l	#4,a3
.loop2:	move.w	(a3),d2
	add.w	d2,d2
	add.w	d2,d2
	move.w	d2,(a3)+
	dbf	d0,.loop2
	dbf	d1,.loop1
	move.l	(a7)+,d0
	rts
;=========================================================
;--- Interrupts ------------------------------------------

Interrupt:
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	chipbase(pc),a6
	bsr	Move
InterEnd:
	move.w	#$4,$09c(a6)
	movem.l	(a7)+,d0-d7/a0-a6
	rte

;=========================================================
;--- MAIN LOOP -------------------------------------------

MainLoop:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop
.ml	cmp.b	#$18,$6(a6)
	bne.s	.ml

	bsr	Show
	bsr	ClearBig	;ClearBig
	bsr	DoAnim

	move.w	ends(pc),d0
	tst.w	d0
	bne.s	mlend

	btst	#6,$bfe001
	bne.s	MainLoop

mlend	rts

;=========================================================
;--- Routines --------------------------------------------

Show:	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	lea	BitMaps+$2(pc),a0
	moveq.l	#DEPTH-1,d1
;	addi.l	#$618,d0
.clp:	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	add.l	#(RESOLUTION/8)*INTERLACE,d0
	addq.l	#8,a0
	dbf	d1,.clp
	rts
;---------------------------------------------------------
;ClearNorm:
;	move.l	chipbase(pc),a6
;
;w1	btst	#6,$dff002
;	bne.s	w1
;         
;	moveq	#-1,d0
;	move.l	d0,$44(a6)
;	move.w	#0,$66(a6)
;	move.l	#$1000000,$40(a6)
;	move.l	PlaneH(pc),$54(a6)
;	move.w	#DEPTH*INTERLACE*64+RESOLUTION/16,$58(a6)
;	rts
;---------------------------------------------------------
ClearBig:
	move.l	chipbase(pc),a6

w2	btst	#6,$dff002
	bne.s	w2
  
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#14,$66(a6)  
	move.l	#$1000000,$40(a6)
	move.l	PlaneH(pc),d0
	addi.l	#40*75,d0
	move.l	d0,$54(a6)
	move.w	#DEPTH*INTERLACE-100,$5c(a6)
	move.w	#RESOLUTION/16-7,$5e(a6)
	rts
;---------------------------------------------------------
Move:	movem.l	d2-d3/a2-a3,-(a7)
	move.l	ScenePtr(pc),a2		; scene struct
	move.l	RootPtr(pc),a3
	move.w	(a2)+,d2		; number of objects
	subq.w	#1,d2
.lab
	move.l	(a2)+,a1	; address of object
	tst.w	10(a3)
	bne.w	.end
	move.l	4(a3),a0
	subq.w	#1,8(a3)
	bge.s	.ok
	lea	14(a0),a0
.ok3:
	cmp.w	#-1,(a0)	; koniec tabulky cinnosti ?
	bgt.s	.ok2
	move.w	#1,10(a3)
	movem.l	(a7)+,d2-d3/a2-a3
	rts
.ok2:
	move.w	(a0),8(a3)
	subq.w	#1,8(a3)
	move.l	a0,4(a3)
.ok:
	addq.l	#2,a0
	move.w	(a0)+,d0
	add.w	d0,12(a1)	; addx
	move.w	(a0)+,d0
	add.w	d0,14(a1)	; addy
	move.w	(a0)+,d0
	add.w	d0,16(a1)	; addz
	move.w	#360,d1
	move.w	d1,d3
	neg.w	d3
	move.w	(a0)+,d0
	add.w	d0,18(a1)	; add alfa
	cmp.w	18(a1),d3	; menej nez -360 ?
	blt.s	.okx
	add.w	d1,18(a1)
.okx:
	cmp.w	18(a1),d1	; viac ako 360 ?
	bgt.s	.ok1x
	sub.w	d1,18(a1)
.ok1x:
	move.w	(a0)+,d0
	add.w	d0,20(a1)	; add beta
	cmp.w	20(a1),d3
	blt.s	.oky
	add.w	d1,20(a1)
.oky:
	cmp.w	20(a1),d1
	bgt.s	.ok1y
	sub.w	d1,20(a1)
.ok1y:
	move.w	(a0)+,d0	; add gama
	add.w	d0,22(a1)
	cmp.w	22(a1),d3
	blt.s	.okz
	add.w	d1,22(a1)
.okz:
	cmp.w	22(a1),d1
	bgt.s	.end
	sub.w	d1,22(a1)
.end:
	lea	12(a3),a3
	dbf	d2,.lab
	movem.l	(a7)+,d2-d3/a2-a3
	rts
;---------------------------------------------------------
DoAnim:
	move.l	RootPtr(pc),a2
	move.l	(a2),tmom
	move.l	ScenePtr(pc),a1
	move.w	(a1)+,d0		; numbers of objects
	subq.w	#1,d0
.ok:
	move.l	(a1)+,a0		; address of object
	movem.l	d0/a1-a2,-(a7)
	move.l	(a0)+,pdptr		; pointer to points
	move.l	(a0)+,atabptr		; pointer to areas
	lea	addx(pc),a1
	addq.l	#4,a0			; set ptr to start coords (x,y,z)
	movem.w	(a0),d0-d5		; x,y,z,alfa,beta,gama
	add.w	d3,d3			; alfa*2
	bge.s	.ok1
	add.w	#720,d3			; angle correction
.ok1:
	add.w	d4,d4
	bge.s	.ok2
	add.w	#720,d4
.ok2:
	add.w	d5,d5
	bge.s	.ok3
	add.w	#720,d5
.ok3:
	ext.l	d0
	asl.l	#4,d0		;start x*16
	ext.l	d1
	asl.l	#4,d1		;start y*16
	ext.l	d2
	asl.l	#4,d2		;start z*16
	movem.l	d0-d2,(a1)	;addx,addy,addz
	lea	12(a1),a1	;rx addrress
	movem.w	d3-d5,(a1)	;write angles to rx,ry,rz

	bsr.w	transform
	bsr	backs
	bsr.w	vector

	movem.l	(a7)+,d0/a1-a2
.nocalc:
	lea	12(a2),a2
	move.l	(a2),tmom
	dbf	d0,.ok

	move.l	ScenePtr(pc),a1
	move.w	(a1),d2		;pocet objectov
	subq.w	#1,d2
	move.l	RootPtr(pc),a3
endlp:
	tst.w	10(a3)
	beq.w	.end
	lea	12(a3),a3
	dbf	d2,endlp
	move.w	#1,ends
.end	rts
;---------------------------------------------------------
transform:
	move.l	pdptr(pc),a2	; address of points tab
	move.l	tmom(pc),a3	; address of new 2D coords
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.w	(a2)+,d5	; number of points
	subq.w	#1,d5
lp7:
	movem.w	(a2)+,d0-d2	; read x,y,z
	moveq	#4,d4
	asl.w	d4,d0
	asl.w	d4,d1
	asl.w	d4,d2
	move.w	rx(pc),d3	; rotate x [x angle(alfa)]
	move.w	d1,d4
	move.w	d2,d7
	muls	(a1,d3.w),d1	; ny=y*cos(al)
	muls	(a0,d3.w),d2	; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	(a0,d3.w),d4	; ny=y*sin(al)
	muls	(a1,d3.w),d7	; nz=z*cos(al)
	add.l	d7,d4		; fz=ny-nz
	add.l	d4,d4
	swap	d4
	move.w	d4,d2		; d2=z

	move.w	ry(pc),d3
	move.w	d0,d4
	move.w	d2,d7
	muls	(a1,d3.w),d0	; nx=x*cos(be)
	muls	(a0,d3.w),d2	; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d4		; d4=-x
	muls	(a0,d3.w),d4	; nx=-x*sin(be)
	muls	(a1,d3.w),d7	; ny=y*cos(be)
	add.l	d7,d4		; fz=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d2

	move.w	rz(pc),d3
	move.w	d0,d4
	move.w	d1,d7
	muls	(a1,d3.w),d0	; nx=x*cos(ga)
	muls	(a0,d3.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d3.w),d4	; nx=x*sin(ga)
	muls	(a1,d3.w),d7	; ny=y*cos(ga)
	add.l	d7,d4		; fy=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d1

;PERSPECTIVE
	ext.l	d0
	ext.l	d1
	ext.l	d2
	add.l	addx(pc),d0
	add.l	addy(pc),d1
	add.l	addz(pc),d2
	moveq	#10,d3
	asl.l	d3,d0
	asl.l	d3,d1
	asr.l	#3,d2
	beq.s	.pjtend
	divs	d2,d0
	divs	d2,d1
	neg.w	d0
	add.w	Midx(pc),d0
	add.w	Midy(pc),d1
.pjtend:
	movem.w	d0-d1,(a3)
	addq.l	#4,a3
	dbf	d5,lp7
	rts
;---------------------------------------------------------
backs:	move.l	atabptr(pc),a2	; PLOCHY
	move.l	tmom(pc),a3	; 2D SUR
	move.w	(a2)+,d7	; number of areas
	subq.w	#1,d7
lpb:
	move.w	4(a2),d5
	movem.w	(a3,d5.w),d0-d1
	move.w	6(a2),d5
	movem.w	(a3,d5.w),d2-d3
	move.w	8(a2),d5
	movem.w	(a3,d5.w),d4-d5
	sub.w	d0,d2		;=-
	sub.w	d1,d3		;  \
	sub.w	d0,d4		;   \
	sub.w	d1,d5		;   |=- z-coord of normal vector
	muls	d2,d5		;   /
	muls	d3,d4		;  /
	sub.l	d4,d5		;=-
	bmi.s	notvisib
	move.w	(a2)+,d1
	move.w	(a2),d0
	bclr	#15,d0
	move.w	d0,(a2)+
	add.w	d1,d1
	add.w	#2,d1
	lea	(a2,d1.w),a2
	dbf	d7,lpb
	rts
notvisib:
	move.w	(a2)+,d1
	move.w	(a2),d0
	bset	#15,d0
	move.w	d0,(a2)+
	add.w	d1,d1
	add.w	#2,d1
	lea	(a2,d1.w),a2
	dbf	d7,lpb
	rts
;--------------------------------------------------------
vector:
	move.l	atabptr(pc),a3
	move.w	(a3),d7
	subq.w	#1,d7
	move.l	tmom(pc),a2
lp:
	addq.l	#2,a3
	move.l	linrout(pc),liner
	moveq	#0,d5
	move.w	(a3)+,d5	; pocet bodov v ploche
	subq.w	#1,d5
	move.w	(a3)+,-(a7)	; farba plochy
	moveq	#-1,d0
	lea	hix(pc),a1
	move.w	#320,2(a1)	; reset oblasti na kopirovanie,filovanie,...
	move.w	d0,(a1)
	move.w	#320,6(a1)
	move.w	d0,4(a1)
	move.w	#0,line
	lea	scx1(pc),a4
	move.l	d0,(a4)
	move.l	d0,4(a4)
.lnlp:
	move.w	(a3)+,d6	; cislo vrcholu * 4
	movem.w	(a2,d6),d0-d1	; x,y coords of points
	move.w	(a3),d6		; next point * 4
	movem.w	(a2,d6),d2-d3	; x,y,cords of point
	asr.w	#4,d0
	asr.w	#4,d1
	asr.w	#4,d2
	asr.w	#4,d3
	bsr.w	drawl
	dbf	d5,.lnlp
	cmp.l	#FLine,liner
	bne.s	nodr
	tst.w	scx1
	blt.s	noclip
	tst.w	scx2
	blt.s	noclip
	lea	scx1(pc),a4
	movem.w	(a4),d0-d3
	bsr.w	drawl		;uzatvara pravy okraj ak treba
noclip:
	tst.w	line
	beq.s	nodr
	bsr.w	CSize		; spocitaj velkost oblasti pre Copy/Fill
	move.w	(a7),d4		; farba
	bsr.w	Copy		; Fill, Copy, Buffer clear
nodr:
	addq.l	#2,a7		; zanechanie farby
vok:
	dbf	d7,lp		; vsetky plochy ?
end
	move.l	chipbase(pc),a6
	rts
;---------------------------------------------------------
drawl:
	movem.l	d4-d7/a5-a6,-(a7)
	cmp.w	d1,d3
	bge.s	.ec
	exg.l	d0,d2
	exg.l	d1,d3
.ec
	cmp.w	6(a1),d1	; loy
	bge.s	.lyk
	move.w	d1,6(a1)
.lyk:
	cmp.w	4(a1),d3	; hiy
	ble.s	.hyk
	move.w	d3,4(a1)
.hyk:
	move.w	d0,d4
	move.w	d2,d5
	cmp.w	d4,d5
	bge.s	.ok
	exg.l	d4,d5
.ok
	cmp.w	2(a1),d4	; lox
	bge.s	.lxk0
	move.w	d4,2(a1)
.lxk0:
	cmp.w	(a1),d5		; hix
	ble.s	chky
	move.w	d5,(a1)
chky:				;clipping
;	move.w	PWidth(pc),d6
;	cmp.w	d6,d0		; point1 napravo za okrajom ?
;	bgt.s	ctx21
;	cmp.w	d6,d2		; point2 napravo za okrajom ?
;	bgt.s	ctx22
;	moveq	#0,d6
;	tst.w	d1
;	bmi.s	cty11		; point1 nad hornym okrajom ?
;	tst.w	d3
;	bmi.s	cty12		; point2 nad hornym okrajom ?
;	move.w	HeightM1(pc),d6
;	cmp.w	d6,d1		; point1 pod spodnym okrajom ?
;	bgt.s	cty21
;	cmp.w	d6,d3		; point2 pod spodnym okrajom ?
;	bgt.s	cty22
;chkx:
;	moveq	#0,d6
;	tst.w	d0		; point1 nalavo za okrajom ?
;	bmi.s	ctx11
;	tst.w	d2		; point2 nalavo za okrajom  ?
;	bmi.s	ctx12
	move.l	liner(pc),a0
	jmp	(a0)
;cty11:				; Clip nad okrajom
;	tst.w	d3		; point2 ber Oberkante (-> ciaru
;	bmi.s	clpend		; nevidno) ?
;	bsr.s	clipy
;	move.w	d4,d0		; berechnete x-Koordinate
;	moveq	#0,d1		; y logischerweise = 0
;	bra.s	chky
;cty12:
;	bsr.s	clipy		; s.o.
;	move.w	d4,d2
;	moveq	#0,d3
;	bra.s	chky
;cty21:				; Clip Unterkante
;	cmp.w	d6,d3		; auch p2 unter Unterkante ?
;	bgt.s	clpend
;	bsr.s	clipy
;	move.w	d4,d0		; berechnete x-Koordinate
;	move.w	d6,d1		; y=255
;	bra.s	chky
;cty22:
;	bsr.s	clipy		; s.o.
;	move.w	d4,d2
;	move.w	d6,d3
;	bra.s	chky
;ctx11:				; Clip linke Kante
;	tst.w	d2		; auch p2 links von
;	bmi.s	clpend		; linker Kante ?
;	bsr.s	clipx
;	move.w	d4,d1		; berechnete y-Koordinate
;	moveq	#0,d0		; x logischerweise = 0
;	bra.s	chky		; noch einmal berprfen
;ctx12:				; s.o.
;	bsr.s	clipx
;	move.w	d4,d3
;	moveq	#0,d2
;	bra.s	chky		; noch einmal berprfen
;ctx21:				; Clip rechte Kante
;	cmp.w	d6,d2		; auch p2 rechts davon ?
;	bgt.s	clpend
;	bsr.s	clipx
;	move.w	d4,d1		; berechnete y-Koordinate
;	move.w	d6,d0		; x=319
;	cmp.l	#endsc,a4
;	beq.s	.ok
;	movem.w	d0-d1,(a4)
;	addq.l	#4,a4
;.ok:
;	bra.w	chky		; noch einmal berprfen
;ctx22:				; s.o.
;	bsr.s	clipx
;	move.w	d4,d3
;	move.w	d6,d2
;	cmp.l	#endsc,a4
;	beq.s	.ok
;	movem.w	d2-d3,(a4)
;	addq.l	#4,a4
;.ok:
;	bra.w	chky		; noch einmal berprfen
;clpend:
;	movem.l	(a7)+,d4-d7/a5-a6
;	rts
;clipy:				; y-Koord. bekannt, x berechnen
;	move.w	d0,d4
;	sub.w	d2,d4
;	move.w	d3,d5
;	move.w	d3,d7
;	sub.w	d6,d7
;	muls	d7,d4		; d4=(x2-x1) * (y bek. - y2)
;	sub.w	d1,d5
;	divs	d5,d4		; d4=d4 / (y2-y1)
;	add.w	d2,d4		; d4=d4 + y2
;	rts
;clipx:				; x-Koordinate bek., y berechnen
;	move.w	d1,d4
;	sub.w	d3,d4
;	move.w	d2,d5
;	move.w	d2,d7
;	sub.w	d6,d7
;	muls	d7,d4		; d4=(y2-y1) * (x bek. -x2)
;	sub.w	d0,d5
;	divs	d5,d4		; d4=d4 / (x2-x1)
;	add.w	d3,d4		; d4=d4 + y2
;	rts
;---------------------------------------------------------
FLine:
	cmp.w	d1,d3
	beq.w	drawend
	move.w	d1,d5
	move.l	MulsPtr(pc),a5
	add.w	d5,d5
	move.w	(a5,d5.w),d5
	ext.l	d5
	move.l	TMapAddress(pc),a5
	add.l	d5,a5
	move.w	d0,d4
	asr.w	#4,d4
	add.w	d4,d4
	lea	(a5,d4.w),a5
	sub.w	d0,d2
	sub.w	d1,d3
	moveq	#15,d5
	and.l	d5,d0
	move.w	d0,d4
	ror.l	#4,d0
	eor.w	d5,d4
	moveq	#0,d5
	bset	d4,d5
	move.w	#4,d0
	tst.w	d2
	bpl.s	.l1
	addq.w	#1,d0
	neg.w	d2
.l1:
	cmp.w	d2,d3
	ble.s	.l2
	exg.l	d2,d3
	subq.w	#4,d0
	add.w	d0,d0
.l2:
	move.w	d3,d4
	sub.w	d2,d4
	add.w	d4,d4
	add.w	d4,d4
	add.w	d3,d3
	moveq	#0,d6
	move.w	d3,d6
	sub.w	d2,d6
	bpl.s	.l3
	or.w	#16,d0
.l3:
	add.w	d3,d3
	add.w	d0,d0
	add.w	d0,d0
	addq.w	#1,d2
	asl.w	#6,d2
	addq.w	#2,d2
	swap	d3
	move.w	d4,d3
	or.l	#$b4a0003,d0
	move.w	Width(pc),d1

	move.l	chipbase(pc),a6

w5	btst	#6,$dff002
	bne.s	w5

	move.w	d1,$60(a6)
	move.w	d1,$66(a6)
	moveq	#-1,d1
	move.l	d1,$44(a6)
	move.w	d1,$72(a6)
	move.w	#$8000,$74(a6)
	move.l	d3,$62(a6)
	eor.w	d5,(a5)
	move.l	a5,$48(a6)
	move.l	a5,$54(a6)
	move.w	d6,$52(a6)
	move.l	d0,$40(a6)
	move.w	d2,$58(a6)
	addq.w	#1,line
drawend:
	movem.l	(a7)+,d4-d7/a5-a6
	rts
;---------------------------------------------------------
WLine:
	move.w	d1,d5
	move.l	MulsPtr(pc),a5
	add.w	d5,d5
	move.w	(a5,d5.w),d5
	ext.l	d5
	move.l	PlaneH(pc),a5
	add.l	d5,a5
	move.w	d0,d4
	asr.w	#4,d4
	add.w	d4,d4
	lea	(a5,d4.w),a5
	sub.w	d0,d2
	sub.w	d1,d3
	moveq	#15,d5
	and.l	d5,d0
	ror.l	#4,d0
	move.w	#4,d0
	tst.w	d2
	bpl.s	.l1
	addq.w	#1,d0
	neg.w	d2
.l1:
	cmp.w	d2,d3
	ble.s	.l2
	exg.l	d2,d3
	subq.w	#4,d0
	add.w	d0,d0
.l2:
	move.w	d3,d4
	sub.w	d2,d4
	add.w	d4,d4
	add.w	d4,d4
	add.w	d3,d3
	moveq	#0,d6
	move.w	d3,d6
	sub.w	d2,d6
	bpl.s	.l3
	or.w	#16,d0
.l3:
	add.w	d3,d3
	add.w	d0,d0
	add.w	d0,d0
	addq.w	#1,d2
	asl.w	#6,d2
	addq.w	#2,d2
	swap	d3
	move.w	d4,d3
	or.l	#$bca0001,d0
	move.w	Width(pc),d1

	move.l	chipbase(pc),a6

w6	btst	#6,$dff002
	bne.s	w6

	move.w	d1,$60(a6)
	move.w	d1,$66(a6)
	moveq	#-1,d1
	move.l	d1,$44(a6)
	move.w	d1,$72(a6)
	move.w	#$8000,$74(a6)
	move.l	d3,$62(a6)
	move.w	28(a7),d1
	moveq	#0,d3
lp6:
	btst	d3,d1
	bne.s	.ok
	and.l	#$ff0fffff,d0
.ok:

w7	btst	#6,$dff002
	bne.s	w7

	move.l	a5,$48(a6)
	move.l	a5,$54(a6)
	move.w	d6,$52(a6)
	move.l	d0,$40(a6)
	move.w	d2,$58(a6)
	or.l	#$00c00000,d0
	add.l	#(RESOLUTION/8)*INTERLACE,a5
	addq.w	#1,d3
	cmp.w	#DEPTH,d3
	blt.s	lp6
	addq.w	#1,line
	movem.l	(a7)+,d4-d7/a5-a6
	rts
;---------------------------------------------------------
CSize:
	move.w	PWidth(pc),d0
	cmp.w	(a1),d0
	bge.s	.ok1
	move.w	d0,(a1)
.ok1:
	tst.w	2(a1)
	bge.s	.ok2
	move.w	#0,2(a1)
.ok2:
	move.w	HeightM1(pc),d0
	cmp.w	4(a1),d0
	bge.s	.ok3
	move.w	d0,4(a1)
.ok3:
	tst.w	6(a1)
	bge.s	.ok4
	move.w	#0,6(a1)
.ok4:
	move.w	(a1),d0
	asr.w	#4,d0
	asl.w	#1,d0
	move.w	d0,woffx
	asr.w	#1,d0
	move.w	2(a1),d1
	asr.w	#4,d1
	sub.w	d1,d0
	addq.w	#1,d0
	move.w	d0,wsizex
	asl.w	#1,d0
	move.w	Width(pc),d1
	sub.w	d0,d1
	move.w	d1,tmpmod
	move.w	4(a1),d0
	sub.w	6(a1),d0
	addq.w	#1,d0
	move.w	d0,wsizey
	move.w	4(a1),d0
	mulu	Width(pc),d0
	move.w	d0,woffy
	rts
;---------------------------------------------------------
Copy:
	move.l	chipbase(pc),a6
	move.l	TMapAddress(pc),a0
	move.l	PlaneH(pc),a1
	moveq	#0,d2
	move.w	woffx(pc),d2
	add.w	woffy(pc),d2
	add.l	d2,a0
	add.l	d2,a1
	move.w	wsizey(pc),d2
	asl.w	#6,d2
	add.w	wsizex(pc),d2
	move.w	tmpmod(pc),d0
	moveq	#-1,d1

w8	btst	#6,$dff002
	bne.s	w8

	move.w	d0,$62(a6)		; BMOD
	move.w	d0,$64(a6)		; AMOD
	move.w	d0,$66(a6)		; DMOD
	move.l	d1,$44(a6)		; AFWM
	move.l	a0,$50(a6)		; APTH
	move.l	a0,$54(a6)		; DPTH
	move.l	#$9f00012,$40(a6)	; CON0	
	move.w	d2,$58(a6)		; SIZE	; Fill

	moveq	#0,d0

	btst	#15,d4
	beq.s	loop1
	lsr.w	#8,d4
loop1:
	btst	d0,d4
	beq.s	nextpl

w9	btst	#6,$dff002
	bne.s	w9

	move.l	#$dfc0002,$40(a6)
	move.l	a0,$50(a6)	; APTH
	move.l	a1,$4c(a6)	; BPTH
	move.l	a1,$54(a6)	; DPTH
	move.w	d2,$58(a6)	; nach Farb-Werten kopieren	; SIZE
nextpl:	add.l	#(RESOLUTION/8)*INTERLACE,a1
	addq.w	#1,d0
	cmp.w	#DEPTH,d0
	blt.s	loop1

w10	btst	#6,$dff002
	bne.s	w10

	move.l	#$1000002,$40(a6)		; CON0		USED
	move.l	a0,$54(a6)			; DPTH
	move.w	d2,$58(a6)   ; Window lschen	; SIZE
	rts
;---------------------------------------------------------
RotateX:
	movem.l	d5/d7,-(a7)
	asl.w	#1,d6
	bge.s	.ok
	add.w	#720,d6
.ok:
	sub.w	d3,d0
	sub.w	d4,d1
	sub.w	d5,d2
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.w	d1,d5
	move.w	d2,d7
	muls	(a1,d6.w),d1	; ny=y*cos(al)
	muls	(a0,d6.w),d2	; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	(a0,d6.w),d5	; ny=y*sin(al)
	muls	(a1,d6.w),d7	; nz=z*cos(al)
	add.l	d7,d5		; fz=ny-nz
	add.l	d5,d5
	swap	d5
	move.w	d5,d2		;d2=z
	movem.l	(a7)+,d5/d7
	add.w	d3,d0
	add.w	d4,d1
	add.w	d5,d2
	rts

RotateY: 
	movem.l	d5/d7,-(a7)
	asl.w	#1,d6
	bge.s	.ok
	add.w	#720,d6
.ok:
	sub.w	d3,d0
	sub.w	d4,d1
	sub.w	d5,d2
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.w	d0,d5
	move.w	d2,d7
	muls	(a1,d6.w),d0	; nx=x*cos(be)
	muls	(a0,d6.w),d2	; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d5		; d5=-x
	muls	(a0,d6.w),d5	; nx=-x*sin(be)
	muls	(a1,d6.w),d7	; ny=y*cos(be)
	add.l	d7,d5		; fz=nx+ny
	add.l	d5,d5
	swap	d5
	move.w	d5,d2
	movem.l	(a7)+,d5/d7
	add.w	d3,d0
	add.w	d4,d1
	add.w	d5,d2
	rts
 
RotateZ:
	movem.l	d5/d7,-(a7)
	asl.w	#1,d6
	bge.s	.ok
	add.w	#720,d6
.ok:
	sub.w	d3,d0
	sub.w	d4,d1
	sub.w	d5,d2
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.w	d0,d5
	move.w	d1,d7
	muls	(a1,d6.w),d0	; nx=x*cos(ga)
	muls	(a0,d6.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d6.w),d5	; nx=x*sin(ga)
	muls	(a1,d6.w),d7	; ny=y*cos(ga)
	add.l	d7,d5		; fy=nx+ny
	add.l	d5,d5
	swap	d5
	move.w	d5,d1
	movem.l	(a7)+,d5/d7
	add.w	d3,d0
	add.w	d4,d1
	add.w	d5,d2
	rts
;---------------------------------------------------------
sintab	DC.W	0,$23B,$477,$6B2,$8ED,$B27,$D61,$F99
	DC.W	$11D0,$1405,$1639,$186C,$1A9C,$1CCA,$1EF7,$2120
	DC.W	$2347,$256C,$278D,$29AB,$2BC6,$2DDE,$2FF2,$3203
	DC.W	$340F,$3617,$381C,$3A1B,$3C17,$3E0D,$3FFF,$41EC
	DC.W	$43D3,$45B6,$4793,$496A,$4B3B,$4D07,$4ECD,$508C
	DC.W	$5246,$53F9,$55A5,$574B,$58E9,$5A81,$5C12,$5D9C
	DC.W	$5F1E,$6099,$620C,$6378,$64DC,$6638,$678D,$68D9
	DC.W	$6A1D,$6B58,$6C8C,$6DB6,$6ED9,$6FF2,$7103,$720B
	DC.W	$730A,$7400,$74EE,$75D2,$76AD,$777E,$7846,$7905
	DC.W	$79BB,$7A67,$7B09,$7BA2,$7C31,$7CB7,$7D32,$7DA4
	DC.W	$7E0D,$7E6B,$7EC0,$7F0A,$7F4B,$7F82,$7FAF,$7FD2
	DC.W	$7FEB,$7FFA
costab	DC.W    $7FFF,$7FFA,$7FEB,$7FD2,$7FAF,$7F82
	DC.W	$7F4B,$7F0A,$7EC0,$7E6B,$7E0D,$7DA4,$7D32,$7CB7
	DC.W	$7C31,$7BA2,$7B09,$7A67,$79BB,$7905,$7846,$777E
	DC.W	$76AD,$75D2,$74EE,$7400,$730A,$720B,$7103,$6FF2
	DC.W	$6ED9,$6DB6,$6C8B,$6B58,$6A1D,$68D9,$678D,$6638
	DC.W	$64DC,$6378,$620C,$6099,$5F1E,$5D9C,$5C12,$5A81
	DC.W	$58E9,$574B,$55A5,$53F9,$5246,$508C,$4ECD,$4D07
	DC.W	$4B3B,$496A,$4793,$45B6,$43D3,$41EC,$3FFF,$3E0D
	DC.W	$3C17,$3A1B,$381C,$3618,$340F,$3203,$2FF2,$2DDE
	DC.W	$2BC7,$29AB,$278D,$256C,$2347,$2120,$1EF7,$1CCB
	DC.W	$1A9C,$186C,$163A,$1406,$11D0,$F99,$D61,$B27
	DC.W	$8ED,$6B3,$477,$23C,0,$FDC5,$FB89,$F94E
	DC.W	$F713,$F4D9,$F2A0,$F067,$EE30,$EBFB,$E9C7,$E794
	DC.W	$E564,$E336,$E10A,$DEE0,$DCB9,$DA95,$D873,$D655
	DC.W	$D43A,$D222,$D00E,$CDFE,$CBF1,$C9E9,$C7E5,$C5E5
	DC.W	$C3EA,$C1F3,$C001,$BE14,$BC2D,$BA4B,$B86E,$B696
	DC.W	$B4C5,$B2F9,$B133,$AF74,$ADBB,$AC08,$AA5B,$A8B6
	DC.W	$A717,$A57F,$A3EE,$A264,$A0E2,$9F67,$9DF4,$9C88
	DC.W	$9B24,$99C8,$9874,$9728,$95E4,$94A8,$9375,$924A
	DC.W	$9128,$900E,$8EFD,$8DF5,$8CF6,$8C00,$8B13,$8A2E
	DC.W	$8954,$8882,$87BA,$86FB,$8645,$8599,$84F7,$845E
	DC.W	$83CF,$8349,$82CE,$825C,$81F3,$8195,$8140,$80F6
	DC.W	$80B5,$807E,$8051,$802E,$8015,$8006,$8001,$8006
	DC.W	$8015,$802E,$8051,$807E,$80B5,$80F6,$8140,$8195
	DC.W	$81F3,$825B,$82CD,$8349,$83CF,$845E,$84F7,$8599
	DC.W	$8645,$86FB,$87B9,$8882,$8953,$8A2E,$8B12,$8BFF
	DC.W	$8CF5,$8DF5,$8EFD,$900E,$9127,$9249,$9374,$94A7
	DC.W	$95E3,$9727,$9873,$99C7,$9B23,$9C87,$9DF3,$9F67
	DC.W	$A0E1,$A264,$A3ED,$A57E,$A716,$A8B5,$AA5B,$AC07
	DC.W	$ADBA,$AF73,$B133,$B2F8,$B4C4,$B696,$B86D,$BA4A
	DC.W	$BC2C,$BE14,$C000,$C1F2,$C3E9,$C5E4,$C7E4,$C9E8
	DC.W	$CBF0,$CDFD,$D00D,$D221,$D439,$D654,$D872,$DA94
	DC.W	$DCB8,$DEDF,$E109,$E335,$E563,$E794,$E9C6,$EBFA
	DC.W	$EE30,$F066,$F29F,$F4D8,$F712,$F94D,$FB88,$FDC4
sinend	DC.W	0,$23B,$477,$6B2,$8ED,$B27,$D61,$F99
	DC.W	$11D0,$1405,$1639,$186C,$1A9C,$1CCA,$1EF7,$2120
	DC.W	$2347,$256C,$278D,$29AB,$2BC6,$2DDE,$2FF2,$3203
	DC.W	$340F,$3617,$381C,$3A1B,$3C17,$3E0D,$3FFF,$41EC
	DC.W	$43D3,$45B6,$4793,$496A,$4B3B,$4D07,$4ECD,$508C
	DC.W	$5246,$53F9,$55A5,$574B,$58E9,$5A81,$5C12,$5D9C
	DC.W	$5F1E,$6099,$620C,$6378,$64DC,$6638,$678D,$68D9
	DC.W	$6A1D,$6B58,$6C8C,$6DB6,$6ED9,$6FF2,$7103,$720B
	DC.W	$730A,$7400,$74EE,$75D2,$76AD,$777E,$7846,$7905
	DC.W	$79BB,$7A67,$7B09,$7BA2,$7C31,$7CB7,$7D32,$7DA4
	DC.W	$7E0D,$7E6B,$7EC0,$7F0A,$7F4B,$7F82,$7FAF,$7FD2
	DC.W	$7FEB,$7FFA
cosend
;---------------------------------------------------------
PWidth:		dc.w	RESOLUTION-1
Width:		dc.w	RESOLUTION/8
WWidth:		dc.w	RESOLUTION/16
Height:		dc.w	INTERLACE
HeightM1:	dc.w	INTERLACE-1
Midx:		dc.w	(RESOLUTION/2-60)<<4
Midy:		dc.w	(INTERLACE/2)<<4
PlaneH:		dc.l	Screen1
PlaneS:		dc.l	Screen2
TMapAddress:	dc.l	Buffer
ends:		dc.w	0

addx     dc.l 0
addy     dc.l 0
addz     dc.l 0
rx       dc.w 0
ry       dc.w 0
rz       dc.w 0
         dc.w 0
pdptr    dc.l 0
atabptr  dc.l 0
hix      dc.w 0
lox      dc.w 0
hiy      dc.w 0
loy      dc.w 0
wsizex   dc.w 1
wsizey   dc.w 1
woffx    dc.w 0
woffy    dc.w 0
tmpmod   dc.w 0
scx1     dc.w 0
scy1     dc.w 0
scx2     dc.w 0
scy2     dc.w 0
endsc
line     dc.w 0
liner    dc.l 0
linrout  dc.l FLine
tmom:	 dc.l 0
ScenePtr dc.l 0
RootPtr  dc.l Root
chipbase dc.l $dff000
MulsPtr  dc.l MulsList
	cnop	0,2
;=========================================================
Scene1:
	dc.w 2
	dc.l Object1
	dc.l Object2

Object1:
	dc.l Points1
	dc.l Areas1
	dc.l Anim1
	dc.w 0,0,-600
	dc.w 0,0,0

Points1:
	dc.w 18
	dc.w 60,0,0
	dc.w 55,22,0
	dc.w 42,42,0
	dc.w 23,55,0
	dc.w 0,59,0
	dc.w -23,55,0
	dc.w -43,42,0
	dc.w -56,23,0
	dc.w -60,0,0
	dc.w -56,-23,0
	dc.w -43,-43,0
	dc.w -24,-56,0
	dc.w 0,-60,0
	dc.w 22,-56,0
	dc.w 42,-43,0
	dc.w 55,-24,0
	dc.w 0,0,-58
	dc.w 0,0,58

Areas1:	dc.w 32
	dc.w 3,$0100,16,3,2,16
	dc.w 3,$0204,16,4,3,16
	dc.w 3,$0100,16,5,4,16
	dc.w 3,$0204,16,6,5,16
	dc.w 3,$0100,16,7,6,16
	dc.w 3,$0204,16,8,7,16
	dc.w 3,$0100,16,9,8,16
	dc.w 3,$0204,16,10,9,16
	dc.w 3,$0100,16,11,10,16
	dc.w 3,$0204,16,12,11,16
	dc.w 3,$0100,16,13,12,16
	dc.w 3,$0204,16,14,13,16
	dc.w 3,$0100,16,15,14,16
	dc.w 3,$0204,16,0,15,16
	dc.w 3,$0100,16,1,0,16
	dc.w 3,$0204,16,2,1,16

	dc.w 3,$0204,17,2,3,17
	dc.w 3,$0100,17,3,4,17
	dc.w 3,$0204,17,4,5,17
	dc.w 3,$0100,17,5,6,17
	dc.w 3,$0204,17,6,7,17
	dc.w 3,$0100,17,7,8,17
	dc.w 3,$0204,17,8,9,17
	dc.w 3,$0100,17,9,10,17
	dc.w 3,$0204,17,10,11,17
	dc.w 3,$0100,17,11,12,17
	dc.w 3,$0204,17,12,13,17
	dc.w 3,$0100,17,13,14,17
	dc.w 3,$0204,17,14,15,17
	dc.w 3,$0100,17,15,0,17
	dc.w 3,$0204,17,0,1,17
	dc.w 3,$0100,17,1,2,17

Anim1:
;	dc.w 800,  0,0,0,   0,0,0
	dc.w 900,  0,0,0,   2,1,-1
	dc.w 100,  0,0,-20, 3,4,2
 	dc.w -1				;end of table
 	even

Object2:
	dc.l Points2
	dc.l Areas2
	dc.l Anim2
	dc.w 0,0,-625
	dc.w 0,0,0

Points2:
	dc.w 24
	dc.w -60,60,-80
	dc.w 60,60,-80
	dc.w 60,-60,-80
	dc.w -60,-60,-80
	dc.w -60,60,80
	dc.w -60,-60,80
	dc.w 60,-60,80
	dc.w 60,60,80
	dc.w 60,-80,-60
	dc.w -60,-80,-60
	dc.w -60,-80,60
	dc.w 60,-80,60
	dc.w 60,80,-60
	dc.w -60,80,-60
	dc.w -60,80,60
	dc.w 60,80,60
	dc.w -80,60,60
	dc.w -80,-60,60
	dc.w -80,-60,-60
	dc.w -80,60,-60
	dc.w 80,60,60
	dc.w 80,-60,60
	dc.w 80,-60,-60
	dc.w 80,60,-60

Areas2:	dc.w 6
	dc.w 4,8,0,3,2,1,0
	dc.w 4,8,4,7,6,5,4
	dc.w 4,16,8,9,10,11,8
	dc.w 4,16,12,15,14,13,12
	dc.w 4,24,16,17,18,19,16
	dc.w 4,24,20,23,22,21,20

Anim2:
;	dc.w 800,  0,0,0,   0,0,0
	dc.w 900,  0,0,0,  -1,-2,1
	dc.w 100,  0,0,-20, 3,4,2
 	dc.w -1				;end of table
 	even
;=========================================================
Root:	dc.l	Coords2DP1
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP2
	dc.l	0
	dc.w	0
	dc.w	0
Coords2DP1:
	dcb.b	MAXPOINTS1*4,0
Coords2DP2:
	dcb.b	MAXPOINTS2*4,0
MulsList:
	dcb.w	INTERLACE,0
	cnop	0,4
;---------------------------------------------------------
CopperList:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0180,$0000,$0182,$0777,$0184,$0804,$0186,$0FFF
	dc.w	$0188,$0FFF,$018A,$0BBB,$018C,$0F08,$018E,$0FFF
	dc.w	$0190,$00D0,$0192,$03A3,$0194,$0472,$0196,$0FFF
	dc.w	$0198,$08E8,$019A,$05C5,$019C,$0874,$019E,$0FFF
	dc.w	$01A0,$0DD0,$01A2,$0AA4,$01A4,$0A82,$01A6,$0FFF
	dc.w	$01A8,$0EE8,$01AA,$0CC6,$01AC,$0E84,$01AE,$0FFF
	dc.w	$01B0,$000F,$01B2,$044B,$01B4,$040A,$01B6,$0FFF
	dc.w	$01B8,$088F,$01BA,$066D,$01BC,$080B,$01BE,$0FFF
BitMaps:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$00EC,$0000,$00EE,$0000
	dc.w	$00F0,$0000,$00F2,$0000
	dc.w	$0100,$5200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0000,$010A,$0000
	dc.w	$009c,$8004
	dc.w	$ffff,$fffe
	even
;------------------------------------
Screen1:	dcb.b	40*256*5,0
Screen2:	dcb.b	40*256*5,0
Buffer:		dcb.b	40*256,0
