// Youtube HTML5 converter
// version 0.85
// 2011-12-12
// Copyright (c) 2010, Arne Schneck, Rob Middleton(aka themiddleman), chromeuser8
// Reworked by Fabien Coeurjoly to be up-to-date and work properly with current HTML5 implementations and Youtube endless changes
// Released under the GPL license
// http://www.gnu.org/copyleft/gpl.html
// 
// Changes version 0.84 -> 0.85 :
//     * Don't attempt to execute anything of this script in HTML5 mode. 
// Changes version 0.83 -> 0.84 :
//     * YouTube suppressed the url_fmt_map this script relied on previously... 
//       Now using another method, let's hope it won't change too soon!      
//     * Removed some dead code and cleanup in a few places 
// Changes version 0.82 -> 0.83 :
//     * Added very basic support for YouTube channels (only first title is played).
// Changes version 0.81 -> 0.82 :
//	   * The player container height set by YouTube is too small to show entirely
//       the HTML5 bultin-player controls. Adjusted its height accordingly.
// Changes version 0.80 -> 0.81 :
//     * "get_video" mode isn't supported by YouTube anymore, so "raw" mode is now
//       the default and only available mode.
//
// ==UserScript==
// @name          Youtube HTML5 Converter
// @namespace     none
// @description   Adds links below the video and replaces Flash with the builtin HTML5 mediaplayer.
// @include       http://youtube.*/watch*
// @include       http://*.youtube.com/watch*
// @include		  http://*.youtube.com/user/*
// @version		  $VER: Youtube HTML5 converter 0.85 (12.12.2011)
// @url			  http://fabportnawak.free.fr/owb/scripts/Youtube.js
// ==/UserScript==

args = {};
var player = document.getElementById("movie_player");

// ---------------------------------------------------------------------------------------------------------

// Only go further if the Flash player is there, else it's HTML5 mode
if(player)
{


function getFormatName(quality) {
	var ret = "(" + quality.toString() + ") unknown";
	switch(quality)
	{
		case 5:
			ret = "(" + quality.toString() + ") FLV H.263 400x240";
			break;
		case 34:
			ret = "(" + quality.toString() + ") FLV H.264 640x360";
			break;	
		case 35:
			ret = "(" + quality.toString() + ") FLV H.264 854x480";
			break;	
		case 18:
			ret = "(" + quality.toString() + ") MP4 H.264 640x360";
			break;	
		case 22:
			ret = "(" + quality.toString() + ") MP4 H.264 1280x720";
			break;	
		case 37:
			ret = "(" + quality.toString() + ") MP4 H.264 1920x1080";
			break;	
		case 38:
			ret = "(" + quality.toString() + ") MP4 H.264 4096x3072";
			break;	
		case 43:
			ret = "(" + quality.toString() + ") WEBM VP8 640x360";
			break;	
		case 44:
			ret = "(" + quality.toString() + ") WEBM VP8 854x480";
			break;	
		case 45:
			ret = "(" + quality.toString() + ") WEBM VP8 1280x720";
			break;
		case 17:
			ret = "(" + quality.toString() + ") 3GP MP4 176x144";
			break;																										
	}
	return ret;
}

function runScript() {

unsafeWindow = window;

GM_getValue = function ( cookieName, oDefault ) {
    var cookieJar = document.cookie.split( "; " );
    for( var x = 0; x < cookieJar.length; x++ ) {
        var oneCookie = cookieJar[x].split( "=" );
        if( oneCookie[0] == escape( cookieName ) ) {
            try {
                var footm = unescape( oneCookie[1] );
            } catch(e) { return oDefault; }
            return footm;
        }
    }
    return oDefault;
};

GM_setValue = function ( cookieName, cookieValue, lifeTime ) {
    if( !cookieName ) { return; }
    if( lifeTime == "delete" ) { lifeTime = -10; } else { lifeTime = 31536000; }
    document.cookie = escape( cookieName ) + "=" + escape( cookieValue ) + ";expires=" + ( new Date( ( new Date() ).getTime() + ( 1000 * lifeTime ) ) ).toGMTString() + ";path=/";
}

var thescript = this;

function addScript(contents, id, isurl) {
	var head, script;
	head = document.getElementsByTagName('head')[0];
	if (!head) { return; }
	script = document.getElementById(id);
	if(script != undefined) {
		head.removeChild(script);
	}
	script = document.createElement('script');
	script.type = 'text/javascript';
	script.id = id;
	if(isurl) {
		script.src = contents
	} else {
		script.innerHTML = contents;
	}
	head.appendChild(script);
}

//http://diveintogreasemonkey.org/patterns/add-css.html
function addGlobalStyle(css) {
	var head, style;
	head = document.getElementsByTagName('head')[0];
	if (!head) { return; }
	style = document.createElement('style');
	style.type = 'text/css';
	try {
		style.innerHTML = css;
	} catch(x) { style.innerText = css; }
	head.appendChild(style);
}

/*
 * pMan preferences manager for greasemonkey scripts
 * http://userscripts.org/scripts/show/71904
 */
var pMan=function(a){var d=this;d.parentElm=null;d.PMan=function(){if(a.elmId)d.parentElm=document.getElementById(a.elmId);else{var c=document.createElement("div");c.style.width="300px";c.style.position="fixed";c.style.left="50%";c.style.marginLeft="-150px";c.style.top="150px";document.getElementsByTagName("body")[0].appendChild(c);d.parentElm=c}};d._save=function(){for(var c=0;c<a.prefs.length;c++){var b=document.getElementById("pManOption"+c);GM_setValue(a.prefs[c].name,b.value)}return false};d._hide= function(){d.parentElm.style.display="none";return false};d._savehide=function(){d._save();d._hide();return false};d.show=function(){for(var c="<div style='"+(a.bordercolor?"border:1px solid "+a.bordercolor+";":"")+(a.color?"color:"+a.color+";":"")+(a.bgcolor?"background-color:"+a.bgcolor+";":"")+"padding:3px;'><div style='font-weight:bold;text-align:center;padding:3px;'>"+(a.title||"")+"</div>",b=0;b<a.prefs.length;b++){c+="<div title='"+(a.prefs[b].description||"")+"'>"+a.prefs[b].name+" <select id='pManOption"+ b+"'>";for(var e=0;e<a.prefs[b].opts.length;e++)c+="<option value='"+(a.prefs[b].vals?a.prefs[b].vals[e]:a.prefs[b].opts[e])+"'>"+a.prefs[b].opts[e]+"</option>";c+="</select></div>"}c+="<div style='text-align:right'><a href='#' id='pManButtonCancel'>Cancel</a> <a href='#' id='pManButtonSave'>Save</a></div></div>";d.parentElm.innerHTML=c;document.getElementById("pManButtonCancel").addEventListener("click",d._hide,true);document.getElementById("pManButtonSave").addEventListener("click",d._savehide, true);for(b=0;b<a.prefs.length;b++)document.getElementById("pManOption"+b).value=d.getVal(a.prefs[b].name);d.parentElm.style.display=""};d.getVal=function(c){for(var b=0;b<a.prefs.length;b++)if(a.prefs[b].name==c)return a.prefs[b].vals?GM_getValue(a.prefs[b].name,a.prefs[b].vals[a.prefs[b].defaultVal]):GM_getValue(a.prefs[b].name,a.prefs[b].opts[a.prefs[b].defaultVal]);return"pref default doesnt exist"};d.PMan()};

var prefloc = document.createElement("div");
var views = document.getElementById('watch-ratings-views');
if(! views) {
	views = document.getElementById('watch-info');
	if(!views) {
		views = document.getElementById('playnav-video-details');
	}
}
prefloc.style.width = "300px";
prefloc.style.margin = "auto";
prefloc.id = "ywofpreferences";
views.parentNode.insertBefore(prefloc,views);

var prefMan = new pMan({
	title:"Youtube HTML5 Converter Preferences",
	color:"black",
	bgcolor:"white",
	bordercolor:"black",
	prefs:[
		{
			name:"Default Quality",
			description:"If the default quality is not available the next best quality video will be played",
			opts:[	getFormatName(5),getFormatName(34),getFormatName(35),
					getFormatName(18),getFormatName(22),getFormatName(37),getFormatName(38),
					getFormatName(43),getFormatName(44),getFormatName(45),
					getFormatName(17),
					"Flash"
				 ],
			vals:["5","34","35","18","22","37","38","43","44","45","17","Flash"],
			defaultVal:3
		},{
			name:"Autoplay",
			description:"",
			opts:["On","Off"],
			vals:["true","false"],
			defaultVal:0
		},{
			name:"Player Size",
			description:"The size of the player",
			opts:["small","big"],
			defaultVal:0
		}
	],
	elmId:"ywofpreferences"
});

/*
 * Players
 * The default is the generic player that should work with whatever 
 *  plugin is installed.
 * All should have the following:
 *
 * string name
 * 
 * string desctiption
 * 
 * function init
 * arguments: (none)
 * returns "this" player object
 * 
 * function writePlayer
 * arguments: (string) id of the parent element to fill with player
 *            (string) video url
 *            (string) autoplay (true or false)
 *            (string) width (number and 'px')
 *            (string) height (number and 'px')
 * returns: none
 * 
 * function seek
 * arguments: (int) time to seek to in seconds
 * returns: none
 * (If this doesnt work just use an empty function anyway.)
 */

var playersAvailable = [{
	name:"HTML5 Player",
	description:"HTML5 Builtin player",
	init:function() {
		return this;
	},
	writePlayer:function(parentDivId, url, autoplay, width, height) {
		var parentDiv = document.getElementById(parentDivId);
		parentDiv.style.height = parseInt(height)+'px';
		var s_autoplay = autoplay ? "autoplay" : "";
		parentDiv.innerHTML = '<video src="' + url + '" width="' + parseInt(width) + '" height="' + parseInt(height) + '"' + s_autoplay + ' controls></video>';
	},
	seek:function(seconds) {
		// should get added someday
	}
}];

// Add css for links.
// This is probably the best way to make text look like links, using the
// normal ways wont work in GM because there is nowhere to put 
// "return false;" in the link.
addGlobalStyle(".link{color:#0033CC;}" + 
		".link:hover{cursor: pointer; text-decoration:underline;}");

var defaultQuality = prefMan.getVal("Default Quality");
var playerDiv = document.getElementById("watch-player-div");
if(! playerDiv) {
	playerDiv = document.getElementById("watch-player");
	if(!playerDiv) {
		playerDiv = document.getElementById("playnav-player");
	}
}

var playerDivLoad = playerDiv.innerHTML; // For restoring flash.
var activePlayer = playersAvailable[0].init();


var flashvars = player.getAttribute("flashvars");
var ampSplit = flashvars.split("&");

for(var i = 0; i < ampSplit.length; i++) {
	var eqSplit = ampSplit[i].split("=");
	args[eqSplit[0]] = eqSplit[1];
}

var urlsAvailable = new Array();
var formatsAvailable = new Array();

var formatmap = decodeURIComponent(args['fmt_list']).split(",");
console.warn("Available YouTube Formats:");
for(var i = 0; i < formatmap.length; i++) {
	formatsAvailable[i] = formatmap[i].split('/')[0];	
	console.warn(formatsAvailable[i]);
}

var urlmap = decodeURIComponent(args['url_encoded_fmt_stream_map']).split(",");
console.warn("Available YouTube URL:");
for(var i = 0; i < urlmap.length; i++) {
	urlsAvailable[i] = decodeURIComponent(urlmap[i].substr(4)).split(';')[0];
	console.warn(urlsAvailable[i]);
}

if(defaultQuality != "flash") {
	// If they don't want flash clear it asap so it doesn't start autoplaying.
	playerDiv.innerHTML = "";
}

// Rewrite time links function it is our function instead
unsafeWindow.yt.www.watch.player.seekTo = activePlayer.seek;

var baseDiv = document.getElementById('baseDiv');

function writePlayer(quality) {
	// If we use the regular video URL in the media player, the video sometimes
	// won't start. Adding '&begin=0' to the video URL seems to fix the problem.
	var playerSize = prefMan.getVal("Player Size");
	var watchVideo = document.getElementById("watch-video");
	var contentDiv = document.getElementById("content");
	
	if(playerSize === "big") {
		if(baseDiv) {
			baseDiv.setAttribute("class", baseDiv.getAttribute('class') + " watch-wide-mode");
		}
		if(watchVideo) {
			watchVideo.setAttribute("class", watchVideo.getAttribute("class") + " wide");
		}
		if(contentDiv) {
			contentDiv.setAttribute("class", contentDiv.getAttribute("class") + " watch-wide");
		}
	}
	else {
		if(baseDiv) {
			baseDiv.setAttribute("class", "");
		}
		if(watchVideo) {
			watchVideo.setAttribute("class", "");
		}
		if(contentDiv) {
			contentDiv.setAttribute("class", "");
		}
	}
	var width = (playerSize === "big") ? "960px" : "640px";
	var height = (playerSize === "big") ? "505px" : "388px";
	
	var qualityId = -1;
	for(i = 0; i<formatsAvailable.length; i++)
	{ 
		if(formatsAvailable[i] == quality)
		{
			qualityId = i;
			break;
		}
	}

	activePlayer.writePlayer(playerDiv.id,
			urlsAvailable[qualityId],
			prefMan.getVal("Autoplay"),
			width,
			height);
}

function restoreFlash() {
	playerDiv.innerHTML = playerDivLoad;
}

var haveFlash;
var noplayerDiv = document.getElementById("watch-noplayer-div");
if(noplayerDiv == null) {
	haveFlash = true;
} 
else {
	haveFlash = false;
}


var linkbar = document.createElement("div");
var linkViewFlash = "";
var linkViewPreferences = "";
var downloadLinks = "";
var playLinks = "";

for(var i = 0; i < formatsAvailable.length; i++) {
	if(typeof(urlsAvailable[i]) != "undefined") {
		downloadLinks += '| <a href="' + urlsAvailable[i] + '&begin=0">' + 
				formatsAvailable[i].toString() + '</a> ';
		
		playLinks += '| <a class="link" id="play' + formatsAvailable[i] + '">' + 
				formatsAvailable[i].toString() + '</a> ';
	}
}

if(haveFlash) {
	linkViewFlash = ' &diams; <a class="link" id="restoreFlash">View Flash</a>';
}

linkViewPreferences = '<a class="link" id="preferencesLink">Preferences</a>';
linkbar.innerHTML = '<div id="dlbar" style="padding-top: 8px;">'
	+ 'Download '
	+ downloadLinks
	+ ' &diams; View without Flash '
	+ playLinks
	+ linkViewFlash
	+ '<div style="float:right;">' + linkViewPreferences + '</div>'
	+ '</div>';

views.parentNode.insertBefore(linkbar,views);

for(var i = 0; i < formatsAvailable.length; i++) {
	if(typeof(urlsAvailable[i]) != "undefined") {
		var playLink = document.getElementById('play' + formatsAvailable[i]);
		var writePlayerFunction = function(qual) {
			return function (event) {
				writePlayer(qual);
			};
		};
		playLink.addEventListener("click", writePlayerFunction(formatsAvailable[i]), true);
	}
}

if(haveFlash) {
	var restoreFlashLink = document.getElementById('restoreFlash');
	restoreFlashLink.addEventListener("click", restoreFlash, true);
}

var preferencesLink = document.getElementById('preferencesLink');
preferencesLink.addEventListener("click", prefMan.show, true);


// Finally, write the player, if the desired format is not available we 
// keep going down in quality until we find one.

if(defaultQuality != "flash") {

	var defaultQualityId = -1;
	
	for(i = 0; i < formatsAvailable.length; i++)
	{ 
		if(formatsAvailable[i] == parseInt(defaultQuality))
		{
			defaultQualityId = i;
			break;
		}
	}

	if(defaultQualityId < 0)
		format = 18; // Try to force it anyway
	else
		format = formatsAvailable[defaultQualityId]; 
		
	writePlayer(format);
}

//alert("Your default quality is set to " + defaultQuality + " and I am playing " + formatsAvailable[defaultQualityId]);

// Make sure we remove explicitely the HTMLMediaElement, since it can be leaked in some cases
function pageUnloaded()
{
	playerDiv.removeChild(playerDiv.firstChild);
}

window.addEventListener("unload", pageUnloaded, false);

}

if(/Chrome/.test(navigator.userAgent)) {
    var script = document.createElement("script");
    script.type = "application/javascript";
    script.textContent = "(" + runScript + ")();";
    document.body.appendChild(script);
} else {
    runScript();
}

} // endif(player)
